/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.hl7.impl;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.v25.datatype.EI;
import ca.uhn.hl7v2.model.v25.datatype.XPN;
import ca.uhn.hl7v2.model.v25.segment.ORC;
import ca.uhn.hl7v2.model.v25.segment.PID;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.finance.order.CustomerOrder;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.ArchetypeQueryHelper;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.hl7.impl.HL7MessageHelper;

abstract class OrderMessageProcessor {
    private final IArchetypeService service;
    private final PatientRules rules;
    private final UserRules userRules;

    public OrderMessageProcessor(IArchetypeService service, PatientRules rules, UserRules userRules) {
        this.service = service;
        this.rules = rules;
        this.userRules = userRules;
    }

    protected Act getOrder(String orderShortName, ORC orc, IMObjectBean bean, CustomerOrder state) {
        Act result = null;
        EI placerOrderNumber = orc.getPlacerOrderNumber();
        String entityIdentifier = placerOrderNumber.getEntityIdentifier().getValue();
        if (StringUtils.isEmpty((CharSequence)entityIdentifier)) {
            CustomerOrder.addNote((IMObjectBean)bean, (String)"No Placer Order Number specified. Order placed outside OpenVPMS");
        } else {
            long id = this.getOrderId(placerOrderNumber);
            if (id >= 0L) {
                result = (Act)this.service.get(orderShortName, id, Act.class);
                if (result != null) {
                    IMObjectBean orderBean;
                    Reference patientRef;
                    Party patient = state.getPatient();
                    if (patient != null && (patientRef = (orderBean = this.service.getBean((IMObject)result)).getTargetRef("patient")) != null && !Objects.equals(patient.getObjectReference(), patientRef)) {
                        String displayName = DescriptorHelper.getDisplayName((String)orderShortName, (ArchetypeService)this.service);
                        CustomerOrder.addNote((IMObjectBean)bean, (String)("Patient is different to that in the original " + displayName + ". Was '" + ArchetypeQueryHelper.getName((Reference)patientRef, (IArchetypeService)this.service) + "' (" + patientRef.getId() + "). Now '" + patient.getName() + "' (" + patient.getId() + ")"));
                    }
                } else {
                    String note = "Order with Placer Order Number '" + entityIdentifier + "'";
                    String namespaceId = placerOrderNumber.getNamespaceID().getValue();
                    if (!StringUtils.isEmpty((CharSequence)namespaceId)) {
                        note = note + " submitted by " + namespaceId;
                    }
                    note = note + " has no corresponding " + DescriptorHelper.getDisplayName((String)orderShortName, (ArchetypeService)this.service);
                    CustomerOrder.addNote((IMObjectBean)bean, (String)note);
                }
            } else {
                String note = "Order with Placer Order Number '" + entityIdentifier + "'";
                String namespaceId = placerOrderNumber.getNamespaceID().getValue();
                if (!StringUtils.isEmpty((CharSequence)namespaceId)) {
                    note = note + " submitted by " + namespaceId;
                }
                note = note + " was placed outside OpenVPMS";
                CustomerOrder.addNote((IMObjectBean)bean, (String)note);
            }
        }
        return result;
    }

    protected long getOrderId(EI placerOrderNumber) {
        return HL7MessageHelper.getId(placerOrderNumber);
    }

    protected CustomerOrder createState(PID pid, Reference location) throws HL7Exception {
        Party patient = null;
        Party customer = null;
        long id = pid.getPatientIdentifierListReps() != 0 ? HL7MessageHelper.getId(pid.getPatientIdentifierList(0)) : HL7MessageHelper.getId(pid.getPatientID());
        if (id != -1L) {
            patient = (Party)this.service.get("party.patientpet", id, Party.class);
        }
        String note = null;
        if (patient == null) {
            XPN xpn = pid.getPatientName(0);
            String firstName = xpn.getGivenName().getValue();
            String lastName = xpn.getFamilyName().getSurname().getValue();
            String name = !StringUtils.isEmpty((CharSequence)lastName) && !StringUtils.isEmpty((CharSequence)firstName) ? firstName + " " + lastName : (!StringUtils.isEmpty((CharSequence)lastName) ? lastName : firstName);
            note = "Unknown patient, Id='" + pid.getPatientID().getIDNumber() + "', name='" + name + "'";
        } else {
            customer = this.rules.getOwner(patient);
        }
        return this.createState(patient, customer, note, location, this.service);
    }

    protected abstract CustomerOrder createState(Party var1, Party var2, String var3, Reference var4, IArchetypeService var5);

    protected IArchetypeService getService() {
        return this.service;
    }

    protected User getClinician(long id) {
        User user = (User)this.service.get("security.user", id, User.class);
        return user != null && this.userRules.isClinician(user) ? user : null;
    }
}

