/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.hl7.impl;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.v25.message.ORM_O01;
import ca.uhn.hl7v2.model.v25.segment.ORC;
import ca.uhn.hl7v2.model.v25.segment.PID;
import java.util.List;
import org.openvpms.archetype.rules.finance.order.CustomerOrder;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.ActBean;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.hl7.impl.OrderMessageProcessor;

public class ORMProcessor
extends OrderMessageProcessor {
    public ORMProcessor(IArchetypeService service, PatientRules rules, UserRules userRules) {
        super(service, rules, userRules);
    }

    public List<Act> process(ORM_O01 message, Reference location) throws HL7Exception {
        PID pid = message.getPATIENT().getPID();
        CustomerOrder state = this.createState(pid, location);
        ORC orc = message.getORDER().getORC();
        String orderControl = orc.getOrderControl().getValue();
        if (!"CA".equals(orderControl)) {
            throw new HL7Exception("Unsupported order control: " + orderControl);
        }
        this.addItem(orc, state);
        return state.getActs();
    }

    @Override
    protected CustomerOrder createState(Party patient, Party customer, String note, Reference location, IArchetypeService service) {
        return new State(patient, customer, note, location, service);
    }

    private void addItem(ORC item, CustomerOrder state) {
        IMObjectBean bean = state.getReturn();
        IMObjectBean itemBean = state.createReturnItem();
        Act investigation = this.getOrder("act.patientInvestigation", item, bean, state);
        if (investigation != null) {
            itemBean.setValue("sourceInvestigation", (Object)investigation.getObjectReference());
            IMObjectBean investigationBean = this.getService().getBean((IMObject)investigation);
            itemBean.setTarget("product", investigationBean.getTargetRef("product"));
            itemBean.setTarget("investigationType", investigationBean.getTargetRef("investigationType"));
            itemBean.setValue("sourceInvoiceItem", (Object)investigationBean.getSourceRef("invoiceItem"));
        }
    }

    private class State
    extends CustomerOrder {
        State(Party patient, Party customer, String note, Reference location, IArchetypeService service) {
            super(patient, customer, note, location, service);
        }

        public ActBean createOrderItem() {
            throw new UnsupportedOperationException("Orders aren't supported");
        }

        public IMObjectBean createReturnItem() {
            return this.createItem("act.customerReturnItemInvestigation", this.getReturn());
        }

        protected IMObjectBean createOrder() {
            throw new UnsupportedOperationException("Orders aren't supported");
        }

        protected IMObjectBean createReturn() {
            return this.createParent("act.customerReturnInvestigation");
        }
    }
}

