/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.hl7.impl;

import ca.uhn.hl7v2.AcknowledgmentCode;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.v25.segment.MSA;
import ca.uhn.hl7v2.model.v25.segment.MSH;
import ca.uhn.hl7v2.parser.Parser;
import java.util.Date;
import org.openvpms.archetype.component.dispatcher.Queue;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.hl7.impl.HL7MessageHelper;
import org.openvpms.hl7.impl.MLLPSender;
import org.openvpms.hl7.io.MessageService;
import org.openvpms.hl7.io.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MessageQueue
extends Queue<Message, MLLPSender>
implements Statistics {
    private final MessageService service;
    private final HapiContext context;
    private MLLPSender connector;
    private DocumentAct currentAct;
    private static final Logger log = LoggerFactory.getLogger(MessageQueue.class);

    public MessageQueue(MLLPSender connector, MessageService service, HapiContext context) {
        super((Object)connector);
        this.connector = connector;
        this.service = service;
        this.context = context;
    }

    public synchronized int getRetryInterval() {
        int interval = this.connector.getRetryInterval();
        if (interval <= 0) {
            interval = 30;
        }
        return interval;
    }

    public DocumentAct add(Message message) throws HL7Exception {
        return this.service.save(message, this.connector);
    }

    public synchronized DocumentAct peekFirstAct() {
        this.peekFirst();
        return this.currentAct;
    }

    public synchronized DocumentAct sent(Message response) {
        if (this.currentAct == null) {
            throw new IllegalStateException("No current message");
        }
        long waitUntil = -1L;
        DocumentAct result = this.currentAct;
        MSA msa = HL7MessageHelper.getMSA(response);
        if (msa != null) {
            String ackCode = msa.getAcknowledgmentCode().getValue();
            if (AcknowledgmentCode.AA.toString().equals(ackCode)) {
                this.processed();
            } else if (AcknowledgmentCode.AE.toString().equals(ackCode)) {
                this.handleError(response, "PENDING");
                waitUntil = System.currentTimeMillis() + 30000L;
            } else {
                this.handleError(response, "ERROR");
            }
        } else {
            this.unsupportedResponse(response);
        }
        this.setWaitUntil(waitUntil);
        return result;
    }

    public synchronized void setConnector(MLLPSender connector) {
        this.connector = connector;
        this.setSuspended(connector.isSuspended());
    }

    @Override
    public synchronized MLLPSender getConnector() {
        return this.connector;
    }

    @Override
    public int getQueued() {
        return this.countMessages("PENDING");
    }

    @Override
    public int getErrors() {
        return this.countMessages("ERROR");
    }

    @Override
    public boolean isRunning() {
        return !this.isSuspended();
    }

    protected void processed(Message object, Date processed) {
        try {
            this.service.accepted(this.currentAct, processed);
        }
        finally {
            this.completed(null, null);
        }
    }

    protected void completed(Date errorDate, String error) {
        super.completed(errorDate, error);
        this.currentAct = null;
    }

    protected Message getNext(MLLPSender owner) {
        DocumentAct act;
        Message result = null;
        while ((act = this.service.next(this.connector)) != null) {
            Message message = this.decode(act);
            if (message == null) continue;
            this.currentAct = act;
            result = message;
            break;
        }
        return result;
    }

    private void handleError(Message ack, String status) {
        String error = HL7MessageHelper.getErrorMessage(ack);
        this.error(status, error);
    }

    private void unsupportedResponse(Message response) {
        StringBuilder error = new StringBuilder();
        error.append("Unsupported response: ");
        try {
            MSH header = (MSH)response.get("MSH");
            error.append(HL7MessageHelper.getMessageName(header));
        }
        catch (HL7Exception exception) {
            log.error("Failed to determine message type", (Throwable)exception);
            error.append("unknown");
        }
        error.append("\nMessage: ");
        try {
            error.append(HL7MessageHelper.toString(response));
        }
        catch (HL7Exception exception) {
            log.error("Failed to format message", (Throwable)exception);
            error.append("unknown");
        }
        this.error("ERROR", error.toString());
    }

    private Message decode(DocumentAct act) {
        Message result = null;
        try {
            result = this.service.get(act, (Parser)this.context.getGenericParser());
        }
        catch (HL7Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            this.service.error(act, "ERROR", new Date(), exception.getMessage());
        }
        return result;
    }

    private int countMessages(String status) {
        return this.service.getMessages(this.connector, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void error(String status, String error) {
        Date now = new Date();
        try {
            log.error("Error received from " + this.connector + ":" + error);
            this.service.error(this.currentAct, status, now, error);
        }
        finally {
            this.completed(now, error);
        }
    }
}

