/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.hl7.impl;

import java.util.Objects;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.hl7.impl.HL7Mapping;
import org.openvpms.hl7.io.Connector;

class MLLPSender
extends Connector {
    public static final int DEFAULT_RESPONSE_TIMEOUT = 30;
    public static final int DEFAULT_RETRY_INTERVAL = 30;
    private final String host;
    private final int port;
    private final int responseTimeout;
    private final int retryInterval;
    private final boolean suspended;

    public MLLPSender(String host, int port, String sendingApplication, String sendingFacility, String receivingApplication, String receivingFacility, Reference reference, HL7Mapping mapping) {
        this(host, port, sendingApplication, sendingFacility, receivingApplication, receivingFacility, 30, 30, false, reference, mapping);
    }

    public MLLPSender(String host, int port, String sendingApplication, String sendingFacility, String receivingApplication, String receivingFacility, int responseTimeout, int retryInterval, boolean suspended, Reference reference, HL7Mapping mapping) {
        super(sendingApplication, sendingFacility, receivingApplication, receivingFacility, reference, mapping);
        this.host = host;
        this.port = port;
        this.responseTimeout = responseTimeout;
        this.retryInterval = retryInterval;
        this.suspended = suspended;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public int getResponseTimeout() {
        return this.responseTimeout;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    @Override
    public boolean equals(Object obj) {
        boolean result;
        boolean bl = result = super.equals(obj) && obj instanceof MLLPSender;
        if (result) {
            MLLPSender other = (MLLPSender)obj;
            result = this.port == other.port && Objects.equals(this.host, other.host) && this.responseTimeout == other.responseTimeout && this.retryInterval == other.retryInterval;
        }
        return result;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("host", (Object)this.host).append("port", this.port).toString();
    }

    public static MLLPSender create(Entity object, ArchetypeService service) {
        IMObjectBean bean = service.getBean((IMObject)object);
        HL7Mapping mapping = MLLPSender.getMapping(bean, service);
        return new MLLPSender(bean.getString("host"), bean.getInt("port"), bean.getString("sendingApplication"), bean.getString("sendingFacility"), bean.getString("receivingApplication"), bean.getString("receivingFacility"), bean.getInt("responseTimeout", 30), bean.getInt("retryInterval", 30), bean.getBoolean("suspended"), object.getObjectReference(), mapping);
    }

    @Override
    protected HashCodeBuilder hashCode(HashCodeBuilder builder) {
        return super.hashCode(builder).append((Object)this.host).append(this.port);
    }
}

