/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.hl7.impl;

import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.v25.message.ORM_O01;
import java.util.Date;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.hl7.impl.HL7Mapping;
import org.openvpms.hl7.impl.MessageDispatcherImpl;
import org.openvpms.hl7.impl.ORMMessageFactory;
import org.openvpms.hl7.io.Connector;
import org.openvpms.hl7.io.MessageDispatcher;
import org.openvpms.hl7.laboratory.Laboratories;
import org.openvpms.hl7.laboratory.LaboratoryOrderService;
import org.openvpms.hl7.patient.PatientContext;

public class LaboratoryOrderServiceImpl
implements LaboratoryOrderService {
    private final Laboratories laboratories;
    private final MessageDispatcher dispatcher;
    private final ORMMessageFactory factory;

    public LaboratoryOrderServiceImpl(ArchetypeService service, LookupService lookups, Laboratories laboratories, MessageDispatcherImpl dispatcher) {
        this.laboratories = laboratories;
        this.dispatcher = dispatcher;
        this.factory = new ORMMessageFactory(dispatcher.getMessageContext(), service, lookups);
    }

    @Override
    public boolean createOrder(PatientContext context, long placerOrderNumber, String serviceId, Date date, Entity laboratory) {
        boolean result = false;
        Connector connector = this.laboratories.getSender(laboratory);
        if (connector != null) {
            HL7Mapping config = connector.getMapping();
            ORM_O01 message = this.factory.createOrder(context, placerOrderNumber, serviceId, date, config);
            this.dispatcher.queue((Message)message, connector, config);
            result = true;
        }
        return result;
    }

    @Override
    public boolean cancelOrder(PatientContext context, long placerOrderNumber, String serviceId, Date date, Entity laboratory) {
        boolean result = false;
        Connector connector = this.laboratories.getSender(laboratory);
        if (connector != null) {
            HL7Mapping config = connector.getMapping();
            ORM_O01 message = this.factory.cancelOrder(context, placerOrderNumber, serviceId, date, config);
            this.dispatcher.queue((Message)message, connector, config);
            result = true;
        }
        return result;
    }
}

