/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.hl7.impl;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.app.HL7Service;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.v25.datatype.HD;
import ca.uhn.hl7v2.model.v25.segment.MSH;
import ca.uhn.hl7v2.protocol.ReceivingApplication;
import ca.uhn.hl7v2.protocol.ReceivingApplicationException;
import ca.uhn.hl7v2.protocol.ReceivingApplicationExceptionHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.openvpms.component.model.user.User;
import org.openvpms.hl7.impl.HL7MessageHelper;
import org.openvpms.hl7.impl.MessageReceiver;
import org.openvpms.hl7.io.Connector;
import org.openvpms.hl7.io.MessageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DemultiplexingReceiver
implements ReceivingApplication,
ReceivingApplicationExceptionHandler {
    private final MessageService messageService;
    private final HL7Service service;
    private final int port;
    private final Map<Connector, MessageReceiver> receivers = new HashMap<Connector, MessageReceiver>();
    private static final String META_DATA_KEY = DemultiplexingReceiver.class.getName();
    private static final Logger log = LoggerFactory.getLogger(DemultiplexingReceiver.class);

    public DemultiplexingReceiver(MessageService messageService, HapiContext context, int port) {
        this.messageService = messageService;
        this.port = port;
        this.service = context.newServer(port, false);
        this.service.registerApplication((ReceivingApplication)this);
        this.service.setExceptionHandler((ReceivingApplicationExceptionHandler)this);
    }

    public synchronized MessageReceiver add(Connector connector, ReceivingApplication receiver, User user) {
        MessageReceiver result = new MessageReceiver(receiver, connector, this.messageService, user, this.service);
        this.receivers.put(connector, result);
        return result;
    }

    public synchronized void remove(Connector connector) {
        this.receivers.remove(connector);
    }

    public synchronized boolean isEmpty() {
        return this.receivers.isEmpty();
    }

    public void start() {
        try {
            log.info("Starting to listen for HL7 messages on port=" + this.port);
            this.service.startAndWait();
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            log.warn("Interrupted while starting DemultiplexingReceiver for port=" + this.port, (Throwable)exception);
        }
    }

    public synchronized void stop() {
        log.info("Stopping listening for HL7 messages on port=" + this.port);
        try {
            this.service.stopAndWait();
        }
        catch (Throwable exception) {
            log.error("Failed to stop listening on port=" + this.port + ": " + exception.getMessage(), exception);
        }
    }

    public boolean isRunning() {
        return this.service.isRunning();
    }

    public Message processMessage(Message message, Map<String, Object> metaData) throws ReceivingApplicationException, HL7Exception {
        MessageReceiver receiver = this.getReceiver(message);
        if (receiver == null) {
            throw new ReceivingApplicationException("No receiver to handle message");
        }
        metaData.put(META_DATA_KEY, receiver);
        return receiver.processMessage(message, metaData);
    }

    public boolean canProcess(Message message) {
        MessageReceiver receiver = this.getReceiver(message);
        return receiver != null && receiver.canProcess(message);
    }

    public String processException(String incomingMessage, Map<String, Object> incomingMetadata, String outgoingMessage, Exception exception) throws HL7Exception {
        String result = outgoingMessage;
        MessageReceiver receiver = (MessageReceiver)incomingMetadata.get(META_DATA_KEY);
        if (receiver != null) {
            result = receiver.processException(incomingMessage, incomingMetadata, outgoingMessage, exception);
        } else {
            log.error(exception.getMessage(), (Throwable)exception);
        }
        return result;
    }

    private MessageReceiver getReceiver(Message message) {
        MSH msh = HL7MessageHelper.getMSH(message);
        String sendingApp = null;
        String sendingFacility = null;
        String receivingApp = null;
        String receivingFacility = null;
        if (msh != null) {
            sendingApp = this.getNamespaceID(msh.getSendingApplication());
            sendingFacility = this.getNamespaceID(msh.getSendingFacility());
            receivingApp = this.getNamespaceID(msh.getReceivingApplication());
            receivingFacility = this.getNamespaceID(msh.getReceivingFacility());
            for (Map.Entry<Connector, MessageReceiver> entry : this.receivers.entrySet()) {
                Connector connector = entry.getKey();
                if (!Objects.equals(connector.getSendingApplication(), sendingApp) || !Objects.equals(connector.getSendingFacility(), sendingFacility) || !Objects.equals(connector.getReceivingApplication(), receivingApp) || !Objects.equals(connector.getReceivingFacility(), receivingFacility)) continue;
                return entry.getValue();
            }
        }
        String type = msh != null ? HL7MessageHelper.getMessageName(msh) : null;
        String header = null;
        if (msh != null) {
            try {
                header = HL7MessageHelper.toString(msh);
            }
            catch (HL7Exception exception) {
                log.warn("Failed to encode header", (Throwable)exception);
            }
        }
        log.warn("No receiver for message of type=" + type + ", Sending Facility=" + sendingFacility + ", Sending Application=" + sendingApp + ", Receiving Facility=" + receivingFacility + ", Receiving Application=" + receivingApp + ", received on port=" + this.port + ", header=" + header);
        return null;
    }

    private String getNamespaceID(HD hd) {
        return hd.getNamespaceID().getValue();
    }
}

