/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.hl7.impl;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v25.segment.AL1;
import ca.uhn.hl7v2.model.v25.segment.PID;
import ca.uhn.hl7v2.model.v25.segment.PV1;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.Parser;
import java.io.IOException;
import java.util.List;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.hl7.impl.HL7Mapping;
import org.openvpms.hl7.impl.PIDPopulator;
import org.openvpms.hl7.impl.PV1Populator;
import org.openvpms.hl7.patient.PatientContext;

abstract class AbstractMessageFactory {
    private final HapiContext messageContext;
    private final ArchetypeService service;
    private final LookupService lookups;
    private final PIDPopulator pidPopulator;
    private final PV1Populator pv1Populator;

    public AbstractMessageFactory(HapiContext messageContext, ArchetypeService service, LookupService lookups) {
        this.messageContext = messageContext;
        this.service = service;
        this.lookups = lookups;
        this.pidPopulator = new PIDPopulator(service, lookups);
        this.pv1Populator = new PV1Populator();
    }

    protected ArchetypeService getArchetypeService() {
        return this.service;
    }

    protected LookupService getLookupService() {
        return this.lookups;
    }

    protected ModelClassFactory getModelClassFactory() {
        return this.messageContext.getModelClassFactory();
    }

    protected void init(AbstractMessage message, String messageCode, String triggerEvent) throws IOException, HL7Exception {
        message.setParser((Parser)this.messageContext.getGenericParser());
        message.initQuickstart(messageCode, triggerEvent, "P");
    }

    protected void populate(PID pid, PatientContext context, HL7Mapping config) throws HL7Exception {
        this.pidPopulator.populate(pid, context, config);
    }

    protected void populate(PV1 pv1, PatientContext context, HL7Mapping config) throws HL7Exception {
        this.pv1Populator.populate(pv1, context, config);
    }

    protected void populateAllergies(Group group, PatientContext context) throws HL7Exception {
        List<Act> allergies = context.getAllergies();
        if (!allergies.isEmpty()) {
            for (int i = 0; i < allergies.size(); ++i) {
                AL1 al1 = (AL1)group.get("AL1", i);
                this.populateAllergy(al1, allergies.get(i), i + 1);
            }
        }
    }

    protected void populateAllergy(AL1 al1, Act act, int id) throws DataTypeException {
        al1.getSetIDAL1().setValue(Integer.toString(id));
        IMObjectBean bean = this.getArchetypeService().getBean((IMObject)act);
        al1.getAllergenCodeMnemonicDescription().getText().setValue(bean.getString("reason"));
        al1.getAllergenTypeCode().getIdentifier().setValue("MA");
        al1.getAllergySeverityCode().getIdentifier().setValue("U");
        al1.getAllergyReactionCode(0).setValue(bean.getString("notes"));
    }
}

