/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.hl7.impl;

import ca.uhn.hl7v2.model.Message;
import java.math.BigDecimal;
import java.util.Date;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.hl7.impl.HL7Mapping;
import org.openvpms.hl7.impl.MessageDispatcherImpl;
import org.openvpms.hl7.impl.RDEMessageFactory;
import org.openvpms.hl7.io.Connector;
import org.openvpms.hl7.io.MessageDispatcher;
import org.openvpms.hl7.patient.PatientContext;
import org.openvpms.hl7.pharmacy.Pharmacies;
import org.openvpms.hl7.pharmacy.PharmacyOrderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PharmacyOrderServiceImpl
implements PharmacyOrderService {
    private final Pharmacies pharmacies;
    private final MessageDispatcher dispatcher;
    private final RDEMessageFactory factory;
    private static final Logger log = LoggerFactory.getLogger(PharmacyOrderServiceImpl.class);

    public PharmacyOrderServiceImpl(ArchetypeService service, LookupService lookups, Pharmacies pharmacies, MessageDispatcherImpl dispatcher) {
        this.pharmacies = pharmacies;
        this.dispatcher = dispatcher;
        this.factory = new RDEMessageFactory(dispatcher.getMessageContext(), service, lookups);
    }

    @Override
    public boolean createOrder(PatientContext context, Product product, BigDecimal quantity, long placerOrderNumber, Date date, Entity pharmacy) {
        boolean result = false;
        Connector connector = this.getConnector(pharmacy);
        if (connector != null) {
            HL7Mapping config = connector.getMapping();
            Message message = this.factory.createOrder(context, product, quantity, placerOrderNumber, connector.getSendingApplication(), date, config);
            this.dispatcher.queue(message, connector, config);
            result = true;
        } else if (log.isDebugEnabled()) {
            log.debug("Cannot create order={} for patient={}, product={}, quantity={}, pharmacy={}: no connector", new Object[]{placerOrderNumber, this.toString((IMObject)context.getPatient()), this.toString((IMObject)product), quantity, this.toString((IMObject)pharmacy)});
        }
        return result;
    }

    @Override
    public boolean updateOrder(PatientContext context, Product product, BigDecimal quantity, long placerOrderNumber, Date date, Entity pharmacy) {
        boolean result = false;
        Connector connector = this.getConnector(pharmacy);
        if (connector != null) {
            HL7Mapping config = connector.getMapping();
            Message message = this.factory.updateOrder(context, product, quantity, placerOrderNumber, connector.getSendingApplication(), date, config);
            this.dispatcher.queue(message, connector, config);
            result = true;
        } else if (log.isDebugEnabled()) {
            log.debug("Cannot update order={} for patient={}, product={}, quantity={}, pharmacy={}: no connector", new Object[]{placerOrderNumber, this.toString((IMObject)context.getPatient()), this.toString((IMObject)product), quantity, this.toString((IMObject)pharmacy)});
        }
        return result;
    }

    @Override
    public void cancelOrder(PatientContext context, Product product, BigDecimal quantity, long placerOrderNumber, Date date, Entity pharmacy) {
        Connector connector = this.getConnector(pharmacy);
        if (connector != null) {
            HL7Mapping config = connector.getMapping();
            Message message = this.factory.cancelOrder(context, product, quantity, placerOrderNumber, connector.getSendingApplication(), config, date);
            this.dispatcher.queue(message, connector, config);
        } else if (log.isDebugEnabled()) {
            log.debug("Cannot cancel order={} for patient={}, product={}, quantity={}, pharmacy={}: no connector", new Object[]{placerOrderNumber, this.toString((IMObject)context.getPatient()), this.toString((IMObject)product), quantity, this.toString((IMObject)pharmacy)});
        }
    }

    @Override
    public void discontinueOrder(PatientContext context, Product product, BigDecimal quantity, long placerOrderNumber, Date date, Entity pharmacy) {
        Connector connector = this.getConnector(pharmacy);
        if (connector != null) {
            HL7Mapping config = connector.getMapping();
            Message message = this.factory.discontinueOrder(context, product, quantity, placerOrderNumber, connector.getSendingApplication(), config, date);
            this.dispatcher.queue(message, connector, config);
        } else if (log.isDebugEnabled()) {
            log.debug("Cannot discontinue order={} for patient={}, product={}, quantity={}, pharmacy={}: no connector", new Object[]{placerOrderNumber, this.toString((IMObject)context.getPatient()), this.toString((IMObject)product), quantity, this.toString((IMObject)pharmacy)});
        }
    }

    private Connector getConnector(Entity pharmacy) {
        return this.pharmacies.getSender(pharmacy);
    }

    private String toString(IMObject object) {
        return object != null ? object.getName() + " (" + object.getId() + ")" : "null";
    }
}

