/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.hl7.impl;

import ca.uhn.hl7v2.model.Message;
import java.util.Collection;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.hl7.impl.ADTMessageFactory;
import org.openvpms.hl7.impl.HL7Mapping;
import org.openvpms.hl7.impl.MessageDispatcherImpl;
import org.openvpms.hl7.io.Connector;
import org.openvpms.hl7.io.MessageDispatcher;
import org.openvpms.hl7.patient.PatientContext;
import org.openvpms.hl7.patient.PatientEventServices;
import org.openvpms.hl7.patient.PatientInformationService;

public class PatientInformationServiceImpl
implements PatientInformationService {
    private final PatientEventServices services;
    private final MessageDispatcher dispatcher;
    private ADTMessageFactory factory;

    public PatientInformationServiceImpl(IArchetypeService service, LookupService lookups, PatientEventServices services, MessageDispatcherImpl dispatcher) {
        this.factory = new ADTMessageFactory(dispatcher.getMessageContext(), (ArchetypeService)service, lookups);
        this.services = services;
        this.dispatcher = dispatcher;
    }

    @Override
    public void admitted(PatientContext context) {
        Collection<Connector> senders = this.services.getConnections(context.getLocation());
        for (Connector connector : senders) {
            HL7Mapping config = connector.getMapping();
            if (!config.sendADT()) continue;
            Message message = this.factory.createAdmit(context, config);
            this.queue(message, connector, config);
        }
    }

    @Override
    public void admissionCancelled(PatientContext context) {
        Collection<Connector> senders = this.services.getConnections(context.getLocation());
        for (Connector connector : senders) {
            HL7Mapping config = connector.getMapping();
            if (!config.sendADT()) continue;
            Message message = config.sendCancelAdmit() ? this.factory.createCancelAdmit(context, config) : this.factory.createDischarge(context, config);
            this.queue(message, connector, config);
        }
    }

    @Override
    public void discharged(PatientContext context) {
        Collection<Connector> senders = this.services.getConnections(context.getLocation());
        for (Connector connector : senders) {
            HL7Mapping config = connector.getMapping();
            if (!config.sendADT()) continue;
            Message message = this.factory.createDischarge(context, config);
            this.queue(message, connector, config);
        }
    }

    @Override
    public void updated(PatientContext context) {
        Collection<Connector> senders = this.services.getConnections(context.getLocation());
        for (Connector connector : senders) {
            HL7Mapping config = connector.getMapping();
            if (!config.sendADT() || !config.sendUpdatePatient()) continue;
            Message message = this.factory.createUpdate(context, config);
            this.queue(message, connector, config);
        }
    }

    protected void queue(Message message, Connector connector, HL7Mapping config) {
        this.dispatcher.queue(message, connector, config);
    }
}

