/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.hl7.impl;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.XAD;
import ca.uhn.hl7v2.model.v25.datatype.XPN;
import ca.uhn.hl7v2.model.v25.segment.PID;
import java.util.Date;
import java.util.function.Predicate;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.hl7.impl.HL7Mapping;
import org.openvpms.hl7.impl.PopulateHelper;
import org.openvpms.hl7.patient.PatientContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PIDPopulator {
    private final ArchetypeService service;
    private final LookupService lookups;
    private static final String CODING_SYSTEM = "OpenVPMS";
    private static final Logger log = LoggerFactory.getLogger(PIDPopulator.class);

    public PIDPopulator(ArchetypeService service, LookupService lookups) {
        this.service = service;
        this.lookups = lookups;
    }

    public void populate(PID pid, PatientContext context, HL7Mapping config) throws HL7Exception {
        pid.getSetIDPID().setValue("1");
        String patientId = Long.toString(context.getPatientId());
        if (config.getPopulatePID3() || !config.getPopulatePID2()) {
            pid.getPatientIdentifierList(0).getIDNumber().setValue(patientId);
        }
        if (config.getPopulatePID2()) {
            pid.getPatientID().getIDNumber().setValue(patientId);
        }
        if (context.getCustomer() != null) {
            String customerId = Long.toString(context.getCustomerId());
            pid.getPatientAccountNumber().getIDNumber().setValue(customerId);
        }
        XPN patientName = pid.getPatientName(0);
        patientName.getFamilyName().getSurname().setValue(context.getPatientLastName());
        patientName.getGivenName().setValue(context.getPatientFirstName());
        Date dateOfBirth = context.getDateOfBirth();
        if (dateOfBirth != null) {
            PopulateHelper.populateDTM(pid.getDateTimeOfBirth().getTime(), dateOfBirth, config);
        }
        pid.getAdministrativeSex().setValue(this.getPatientSex(context, config));
        Contact home = context.getAddress();
        if (home != null) {
            XAD address = pid.getPatientAddress(0);
            this.populateAddress(address, home);
        }
        pid.getPhoneNumberHome(0).getTelephoneNumber().setValue(context.getHomePhone());
        pid.getPhoneNumberBusiness(0).getTelephoneNumber().setValue(context.getWorkPhone());
        if (!this.populateSpecies(pid, context, config)) {
            this.populateBreed(pid, context);
        }
    }

    private String getPatientSex(PatientContext context, HL7Mapping mapping) {
        String sex = context.getPatientSex();
        boolean desexed = context.isDesexed();
        String result = "MALE".equals(sex) ? (desexed ? mapping.getMaleDesexed() : mapping.getMale()) : ("FEMALE".equals(sex) ? (desexed ? mapping.getFemaleDesexed() : mapping.getFemale()) : mapping.getUnknownSex());
        return result;
    }

    private void populateAddress(XAD address, Contact home) throws HL7Exception {
        IMObjectBean bean = this.service.getBean((IMObject)home);
        address.getStreetAddress().getStreetOrMailingAddress().setValue(bean.getString("address"));
        address.getCity().setValue(this.lookups.getName((IMObject)home, "suburb"));
        address.getZipOrPostalCode().setValue(bean.getString("postcode"));
        address.getStateOrProvince().setValue(this.lookups.getName((IMObject)home, "state"));
    }

    private boolean populateSpecies(PID pid, PatientContext context, HL7Mapping mapping) throws HL7Exception {
        boolean mapped = false;
        String species = context.getSpeciesCode();
        String name = context.getSpeciesName();
        String system = CODING_SYSTEM;
        if (species != null && mapping.getSpeciesLookup() != null) {
            mapped = true;
            String archetype = mapping.getSpeciesLookup();
            Lookup source = this.lookups.getLookup("lookup.species", species);
            if (source != null) {
                IMObjectBean bean = this.service.getBean((IMObject)source);
                Lookup target = (Lookup)bean.getTarget("mapping", Lookup.class, Policies.active((Predicate)Predicates.targetIsA((String[])new String[]{archetype})));
                if (target != null) {
                    species = target.getCode();
                    name = target.getName();
                } else if (mapping.getUnmappedSpecies() != null) {
                    name = species = mapping.getUnmappedSpecies();
                } else {
                    log.warn("No mapping for species=" + species + " for " + archetype);
                    species = null;
                    name = null;
                }
                system = null;
            }
        }
        if (species != null) {
            CE code = pid.getSpeciesCode();
            code.getIdentifier().setValue(species);
            code.getText().setValue(name);
            code.getNameOfCodingSystem().setValue(system);
        }
        return mapped;
    }

    private void populateBreed(PID pid, PatientContext context) throws HL7Exception {
        String breed = context.getBreedCode();
        if (breed != null) {
            CE code = pid.getBreedCode();
            code.getIdentifier().setValue(breed);
            code.getText().setValue(context.getBreedName());
            code.getNameOfCodingSystem().setValue(CODING_SYSTEM);
        }
    }
}

