/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.hl7.impl;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.v25.segment.EVN;
import ca.uhn.hl7v2.model.v25.segment.MSH;
import java.util.Date;
import org.openvpms.hl7.impl.HL7Mapping;
import org.openvpms.hl7.impl.PopulateHelper;
import org.openvpms.hl7.io.Connector;

class HeaderPopulator {
    HeaderPopulator() {
    }

    public void populate(Message message, Connector connector, Date timestamp, String messageControlId, HL7Mapping config) throws HL7Exception {
        MSH msh = (MSH)message.get("MSH");
        msh.getSendingApplication().getNamespaceID().setValue(connector.getSendingApplication());
        msh.getSendingFacility().getNamespaceID().setValue(connector.getSendingFacility());
        msh.getReceivingApplication().getNamespaceID().setValue(connector.getReceivingApplication());
        msh.getReceivingFacility().getNamespaceID().setValue(connector.getReceivingFacility());
        PopulateHelper.populateDTM(msh.getDateTimeOfMessage().getTime(), timestamp, config);
        msh.getMessageControlID().setValue(messageControlId);
        msh.getCharacterSet(0).setValue("UTF-8");
        for (String name : message.getNames()) {
            if (!"EVN".equals(name)) continue;
            EVN evn = (EVN)message.get(name);
            evn.getEventTypeCode().setValue(msh.getMessageType().getTriggerEvent().getValue());
            PopulateHelper.populateDTM(evn.getRecordedDateTime().getTime(), timestamp, config);
            evn.getEventFacility().getNamespaceID().setValue(msh.getSendingFacility().getNamespaceID().getValue());
            break;
        }
    }
}

