/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.hl7.impl;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.CWE;
import ca.uhn.hl7v2.model.v25.datatype.CX;
import ca.uhn.hl7v2.model.v25.datatype.EI;
import ca.uhn.hl7v2.model.v25.datatype.MSG;
import ca.uhn.hl7v2.model.v25.segment.ERR;
import ca.uhn.hl7v2.model.v25.segment.MSA;
import ca.uhn.hl7v2.model.v25.segment.MSH;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HL7MessageHelper {
    private static final Logger log = LoggerFactory.getLogger(HL7MessageHelper.class);

    public static String getMessageName(MSH header) {
        MSG type = header.getMessageType();
        return type.getMessageCode() + "^" + type.getTriggerEvent() + "^" + type.getMessageStructure();
    }

    public static MSH getMSH(Message message) {
        return (MSH)HL7MessageHelper.get(message, "MSH");
    }

    public static MSA getMSA(Message message) {
        return (MSA)HL7MessageHelper.get(message, "MSA");
    }

    public static String getErrorMessage(Message ack) {
        MSA msa = HL7MessageHelper.getMSA(ack);
        List<ERR> errors = HL7MessageHelper.getAll(ack, "ERR");
        StringBuilder buffer = new StringBuilder();
        String text = msa.getTextMessage().getValue();
        if (!StringUtils.isEmpty((CharSequence)text)) {
            buffer.append(text);
        }
        for (ERR err : errors) {
            String userMessage;
            String diagnostic;
            String errorCode;
            String hl7ErrorCode = HL7MessageHelper.formatCWE(err.getHL7ErrorCode());
            if (hl7ErrorCode != null) {
                HL7MessageHelper.append(buffer, "HL7 Error Code: ", hl7ErrorCode);
            }
            if (!StringUtils.isEmpty((CharSequence)(errorCode = HL7MessageHelper.formatCWE(err.getApplicationErrorCode())))) {
                HL7MessageHelper.append(buffer, "Application Error Code: ", errorCode);
            }
            if (!StringUtils.isEmpty((CharSequence)(diagnostic = err.getDiagnosticInformation().getValue()))) {
                HL7MessageHelper.append(buffer, "Diagnostic Information: ", diagnostic);
            }
            if (StringUtils.isEmpty((CharSequence)(userMessage = err.getUserMessage().getValue()))) continue;
            HL7MessageHelper.append(buffer, "User Message: ", userMessage);
        }
        String condition = HL7MessageHelper.formatCE(msa.getErrorCondition());
        if (!StringUtils.isEmpty((CharSequence)condition)) {
            HL7MessageHelper.append(buffer, "Error Condition: ", condition);
        }
        if (buffer.length() == 0) {
            buffer.append("Message body: ");
            try {
                buffer.append(HL7MessageHelper.toString(ack));
            }
            catch (HL7Exception exception) {
                buffer.append("unknown");
                log.error("Failed to encode message", (Throwable)exception);
            }
        }
        return buffer.toString();
    }

    public static <T extends Structure> T get(Message message, String name) {
        try {
            for (String n : message.getNames()) {
                if (!name.equals(n)) continue;
                return (T)message.get(name);
            }
        }
        catch (HL7Exception exception) {
            log.error("Failed to access " + name, (Throwable)exception);
        }
        return null;
    }

    public static <T extends Structure> List<T> getAll(Message message, String name) {
        List result = Collections.emptyList();
        try {
            for (String n : message.getNames()) {
                Structure[] list;
                if (!name.equals(n) || (list = message.getAll(name)).length == 0) continue;
                result = new ArrayList();
                for (Structure s : list) {
                    result.add(s);
                }
            }
        }
        catch (HL7Exception exception) {
            log.error("Failed to access " + name, (Throwable)exception);
        }
        return result;
    }

    public static String toString(Message message) throws HL7Exception {
        return message.encode().replaceAll("\r", "\n");
    }

    public static String toString(MSH header) throws HL7Exception {
        return header.encode().replaceAll("\r", "\n");
    }

    public static long getId(CE value) {
        return HL7MessageHelper.getId(value.getIdentifier().getValue());
    }

    public static long getId(CX value) {
        return HL7MessageHelper.getId(value.getIDNumber().getValue());
    }

    public static long getId(EI value) {
        return HL7MessageHelper.getId(value.getEntityIdentifier().getValue());
    }

    public static long getId(String value) {
        long id = -1L;
        if (!StringUtils.isEmpty((CharSequence)value)) {
            try {
                id = Long.valueOf(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return id;
    }

    private static String formatCWE(CWE field) {
        String originalText;
        String result = HL7MessageHelper.formatIdText(field.getIdentifier().getValue(), field.getText().getValue());
        if (result != null && !StringUtils.isEmpty((CharSequence)(originalText = field.getOriginalText().getValue()))) {
            result = result + "\nOriginal Text: ";
            result = result + originalText;
        }
        return result;
    }

    private static String formatCE(CE field) {
        return HL7MessageHelper.formatIdText(field.getIdentifier().getValue(), field.getText().getValue());
    }

    private static String formatIdText(String id, String text) {
        String result = null;
        if (!StringUtils.isEmpty((CharSequence)id) || !StringUtils.isEmpty((CharSequence)text)) {
            result = !StringUtils.isEmpty((CharSequence)id) && !StringUtils.isEmpty((CharSequence)text) ? id + " - " + text : (!StringUtils.isEmpty((CharSequence)id) ? id : text);
        }
        return result;
    }

    private static void append(StringBuilder buffer, String ... values) {
        if (buffer.length() != 0) {
            buffer.append("\n");
        }
        for (String value : values) {
            buffer.append(value);
        }
    }
}

