/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tools.archetype.comparator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openvpms.component.business.domain.im.datatypes.property.AssertionProperty;
import org.openvpms.component.business.domain.im.datatypes.property.NamedProperty;
import org.openvpms.component.business.domain.im.datatypes.property.PropertyList;
import org.openvpms.component.model.archetype.AssertionDescriptor;
import org.openvpms.component.model.archetype.NodeDescriptor;
import org.openvpms.component.model.archetype.PropertyMap;
import org.openvpms.tools.archetype.comparator.AbstractComparator;
import org.openvpms.tools.archetype.comparator.NodeChange;
import org.openvpms.tools.archetype.comparator.NodeFieldChange;

public class NodeComparator
extends AbstractComparator {
    public NodeChange compare(NodeDescriptor oldVersion, NodeDescriptor newVersion) {
        ArrayList<NodeFieldChange> changes = new ArrayList<NodeFieldChange>();
        this.compare(NodeFieldChange.Field.DESCRIPTION, oldVersion.getDescription(), newVersion.getDescription(), changes);
        this.compare(NodeFieldChange.Field.DISPLAY_NAME, oldVersion.getDisplayName(), newVersion.getDisplayName(), changes);
        this.compare(NodeFieldChange.Field.TYPE, oldVersion.getType(), newVersion.getType(), changes);
        this.compare(NodeFieldChange.Field.BASE_NAME, oldVersion.getBaseName(), newVersion.getBaseName(), changes);
        this.compare(NodeFieldChange.Field.PATH, oldVersion.getPath(), newVersion.getPath(), changes);
        this.compare(NodeFieldChange.Field.PARENT_CHILD, oldVersion.isParentChild(), newVersion.isParentChild(), changes);
        this.compare(NodeFieldChange.Field.MIN_LENGTH, oldVersion.getMinLength(), newVersion.getMinLength(), changes);
        this.compare(NodeFieldChange.Field.MAX_LENGTH, oldVersion.getMaxLength(), newVersion.getMaxLength(), changes);
        this.compare(NodeFieldChange.Field.MIN_CARDINALITY, oldVersion.getMinCardinality(), newVersion.getMinCardinality(), changes);
        this.compare(NodeFieldChange.Field.MAX_CARDINALITY, oldVersion.getMaxCardinality(), newVersion.getMaxCardinality(), changes);
        this.compare(NodeFieldChange.Field.FILTER, oldVersion.getFilter(), newVersion.getFilter(), changes);
        this.compare(NodeFieldChange.Field.INDEX, oldVersion.getIndex(), newVersion.getIndex(), changes);
        this.compare(NodeFieldChange.Field.DEFAULT_VALUE, oldVersion.getDefaultValue(), newVersion.getDefaultValue(), changes);
        this.compare(NodeFieldChange.Field.READ_ONLY, oldVersion.isReadOnly(), newVersion.isReadOnly(), changes);
        this.compare(NodeFieldChange.Field.HIDDEN, oldVersion.isHidden(), newVersion.isHidden(), changes);
        this.compare(NodeFieldChange.Field.DERIVED, oldVersion.isDerived(), newVersion.isDerived(), changes);
        this.compare(NodeFieldChange.Field.DERIVED_VALUE, oldVersion.getDerivedValue(), newVersion.getDerivedValue(), changes);
        this.compareAssertions(oldVersion, newVersion, changes);
        return changes.isEmpty() ? null : new NodeChange(oldVersion, newVersion, changes);
    }

    private void compare(NodeFieldChange.Field field, Object oldVersion, Object newVersion, List<NodeFieldChange> changes) {
        if (!Objects.equals(oldVersion, newVersion)) {
            changes.add(new NodeFieldChange(field, oldVersion, newVersion));
        }
    }

    private void compareAssertions(NodeDescriptor oldVersion, NodeDescriptor newVersion, List<NodeFieldChange> changes) {
        Map oldAssertions = oldVersion.getAssertionDescriptors();
        Map newAssertions = newVersion.getAssertionDescriptors();
        Set<String> deleted = this.getDeleted(oldAssertions, newAssertions);
        Set<String> added = this.getAdded(oldAssertions, newAssertions);
        Set<String> retained = this.getRetained(oldAssertions, newAssertions);
        for (String deletedKey : deleted) {
            changes.add(new NodeFieldChange(NodeFieldChange.Field.ASSERTION, oldAssertions.get(deletedKey), null));
        }
        for (String retainedKey : retained) {
            AssertionDescriptor oldAssertion = (AssertionDescriptor)oldAssertions.get(retainedKey);
            AssertionDescriptor newAssertion = (AssertionDescriptor)newAssertions.get(retainedKey);
            this.compareAssertion(oldAssertion, newAssertion, changes);
        }
        for (String addedKey : added) {
            changes.add(new NodeFieldChange(NodeFieldChange.Field.ASSERTION, null, newAssertions.get(addedKey)));
        }
    }

    private void compareAssertion(AssertionDescriptor oldVersion, AssertionDescriptor newVersion, List<NodeFieldChange> changes) {
        boolean equals = Objects.equals(newVersion.getErrorMessage(), oldVersion.getErrorMessage());
        if (equals) {
            PropertyMap oldMap = oldVersion.getPropertyMap();
            PropertyMap newMap = newVersion.getPropertyMap();
            equals = this.comparePropertyMap(oldMap, newMap);
        }
        if (!equals) {
            changes.add(new NodeFieldChange(NodeFieldChange.Field.ASSERTION, oldVersion, newVersion));
        }
    }

    private boolean compareNamedProperty(org.openvpms.component.model.archetype.NamedProperty oldVersion, org.openvpms.component.model.archetype.NamedProperty newVersion) {
        if (oldVersion.getName().equals(newVersion.getName())) {
            if (oldVersion instanceof PropertyMap && newVersion instanceof PropertyMap) {
                return this.comparePropertyMap((PropertyMap)oldVersion, (PropertyMap)newVersion);
            }
            if (oldVersion instanceof PropertyList && newVersion instanceof PropertyList) {
                return this.comparePropertyList((PropertyList)oldVersion, (PropertyList)newVersion);
            }
            if (oldVersion instanceof AssertionProperty && newVersion instanceof AssertionProperty) {
                return this.compareAssertionProperty((AssertionProperty)oldVersion, (AssertionProperty)newVersion);
            }
        }
        return false;
    }

    private boolean comparePropertyMap(PropertyMap oldVersion, PropertyMap newVersion) {
        Set newNames;
        Set oldNames = oldVersion.getProperties().keySet();
        if (oldNames.equals(newNames = newVersion.getProperties().keySet())) {
            for (String name : oldNames) {
                org.openvpms.component.model.archetype.NamedProperty newProperty;
                org.openvpms.component.model.archetype.NamedProperty oldProperty = (org.openvpms.component.model.archetype.NamedProperty)oldVersion.getProperties().get(name);
                if (this.compareNamedProperty(oldProperty, newProperty = (org.openvpms.component.model.archetype.NamedProperty)newVersion.getProperties().get(name))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean comparePropertyList(PropertyList oldVersion, PropertyList newVersion) {
        NamedProperty[] newProperties;
        NamedProperty[] oldProperties = oldVersion.getPropertiesAsArray();
        if (oldProperties.length == (newProperties = newVersion.getPropertiesAsArray()).length) {
            for (int i = 0; i < oldProperties.length; ++i) {
                if (this.compareNamedProperty(oldProperties[i], newProperties[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean compareAssertionProperty(AssertionProperty oldVersion, AssertionProperty newVersion) {
        return Objects.equals(oldVersion.getType(), newVersion.getType()) && Objects.equals(oldVersion.getValue(), newVersion.getValue());
    }
}

