/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.query.criteria;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.dao.hibernate.im.query.QueryBuilderException;
import org.openvpms.component.business.dao.hibernate.im.query.TypeSet;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.service.archetype.descriptor.cache.IArchetypeDescriptorCache;
import org.openvpms.component.model.archetype.NodeDescriptor;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.system.common.query.criteria.Type;

public class Context {
    private final IArchetypeDescriptorCache cache;

    public Context(IArchetypeDescriptorCache cache) {
        this.cache = cache;
    }

    public <T extends IMObject> Type<T> getType(Class<T> type, String ... archetypes) {
        Map<String, org.openvpms.component.model.archetype.ArchetypeDescriptor> descriptors = this.getDescriptors(archetypes, false);
        if (descriptors.isEmpty()) {
            throw new IllegalArgumentException("No archetypes not found for: " + StringUtils.join((Object[])archetypes, (String)", "));
        }
        Class<?> impl = TypeSet.getClass(descriptors.values());
        if (!type.isAssignableFrom(impl)) {
            throw new IllegalArgumentException("Argument 'type' is not assignable from " + impl.getName() + ": " + type.getName());
        }
        return new Type(impl, descriptors, null);
    }

    public <T> Type<T> getTypeForJoin(Type<?> from, String name) {
        List<NodeDescriptor> nodes = this.getNodes(from, name);
        Map<String, org.openvpms.component.model.archetype.ArchetypeDescriptor> descriptors = this.getDescriptors(nodes);
        if (descriptors.isEmpty()) {
            throw new IllegalArgumentException("Node " + name + " is not associated with any archetypes");
        }
        return new Type(TypeSet.getClass(descriptors.values()), descriptors, nodes.get(0));
    }

    public <T> Type<T> getTypeForJoin(Type<?> from, String name, String[] archetypes) {
        Map<String, org.openvpms.component.model.archetype.ArchetypeDescriptor> map;
        Class type;
        List<NodeDescriptor> nodes = this.getNodes(from, name);
        NodeDescriptor first = nodes.get(0);
        if (first.getArchetypeRange() != null || first.getFilter() != null) {
            Map<String, org.openvpms.component.model.archetype.ArchetypeDescriptor> descriptors = this.getDescriptors(nodes);
            type = null;
            map = this.getDescriptors(archetypes, false);
            for (String archetype : map.keySet()) {
                org.openvpms.component.model.archetype.ArchetypeDescriptor descriptor = descriptors.get(archetype);
                if (descriptor == null) {
                    throw new IllegalArgumentException("Archetype=" + archetype + " not present for node=" + name);
                }
                type = descriptor.getClassType();
            }
            if (type == null) {
                throw new IllegalArgumentException("No archetypes found for " + StringUtils.join((Object[])archetypes, (String)","));
            }
        } else {
            throw new IllegalArgumentException("Cannot join on " + name);
        }
        Type result = new Type(type, map, first);
        return result;
    }

    public <T> Type<T> getTypeForNode(Type<?> parent, String name) {
        Type type;
        Map<String, org.openvpms.component.model.archetype.ArchetypeDescriptor> parentArchetypes = parent.getArchetypeDescriptors();
        if (parentArchetypes == null) {
            throw new IllegalArgumentException("Leaf node");
        }
        List<NodeDescriptor> nodes = this.getNodes(name, parentArchetypes);
        NodeDescriptor first = nodes.get(0);
        if (first.getArchetypeRange().length != 0 || first.getFilter() != null) {
            Map<String, org.openvpms.component.model.archetype.ArchetypeDescriptor> descriptors = this.getDescriptors(nodes);
            type = new Type(first.getClassType(), descriptors, first);
        } else {
            type = new Type(first.getClassType(), null, first);
        }
        return type;
    }

    private Map<String, org.openvpms.component.model.archetype.ArchetypeDescriptor> getDescriptors(List<NodeDescriptor> nodes) {
        HashSet<String> matches = new HashSet<String>();
        for (NodeDescriptor descriptor : nodes) {
            this.mergeArchetypeRange(matches, descriptor);
        }
        String[] archetypes = matches.toArray(new String[matches.size()]);
        Map<String, org.openvpms.component.model.archetype.ArchetypeDescriptor> descriptors = this.getDescriptors(archetypes, false);
        if (descriptors.isEmpty()) {
            throw new QueryBuilderException(QueryBuilderException.ErrorCode.NoMatchingArchetypesForShortName, ArrayUtils.toString((Object)archetypes));
        }
        return descriptors;
    }

    private List<NodeDescriptor> getNodes(String name, Map<String, org.openvpms.component.model.archetype.ArchetypeDescriptor> descriptors) {
        ArrayList<NodeDescriptor> result = new ArrayList<NodeDescriptor>();
        NodeDescriptor matching = null;
        for (org.openvpms.component.model.archetype.ArchetypeDescriptor descriptor : descriptors.values()) {
            NodeDescriptor node = descriptor.getNodeDescriptor(name);
            if (node == null) {
                throw new QueryBuilderException(QueryBuilderException.ErrorCode.NoNodeDescWithName, descriptor.getName(), name);
            }
            if (matching == null) {
                matching = node;
            } else if (!node.getPath().equals(matching.getPath()) || !node.getType().equals(matching.getType())) {
                throw new QueryBuilderException(QueryBuilderException.ErrorCode.NodeDescriptorsDoNotMatch, name);
            }
            result.add(node);
        }
        if (result.isEmpty()) {
            throw new IllegalArgumentException("Argument '" + name + "' is not a node of " + StringUtils.join(descriptors.values(), (String)","));
        }
        return result;
    }

    private List<NodeDescriptor> getNodes(Type<?> type, String name) {
        Map<String, org.openvpms.component.model.archetype.ArchetypeDescriptor> descriptors = type.getArchetypeDescriptors();
        if (descriptors == null) {
            throw new IllegalArgumentException("Leaf node");
        }
        return this.getNodes(name, descriptors);
    }

    private Map<String, org.openvpms.component.model.archetype.ArchetypeDescriptor> getDescriptors(String[] archetypes, boolean primaryOnly) {
        HashMap<String, org.openvpms.component.model.archetype.ArchetypeDescriptor> result = new HashMap<String, org.openvpms.component.model.archetype.ArchetypeDescriptor>();
        HashSet<String> expanded = new HashSet<String>();
        for (String archetype : archetypes) {
            List<String> matches = this.cache.getArchetypeShortNames(archetype, primaryOnly);
            expanded.addAll(matches);
        }
        for (String archetype : expanded) {
            ArchetypeDescriptor descriptor = this.cache.getArchetypeDescriptor(archetype);
            result.put(archetype, descriptor);
        }
        return result;
    }

    private void mergeArchetypeRange(Set<String> matches, NodeDescriptor descriptor) {
        String[] archetypes = descriptor.getArchetypeRange();
        if (archetypes == null || archetypes.length == 0) {
            if (descriptor.getFilter() == null) {
                org.openvpms.component.model.archetype.ArchetypeDescriptor archetype = descriptor.getArchetypeDescriptor();
                String name = archetype != null ? archetype.getArchetypeType() : "unknown";
                throw new QueryBuilderException(QueryBuilderException.ErrorCode.NoArchetypeRangeAssertion, name, descriptor.getName());
            }
            matches.add(descriptor.getFilter());
        } else {
            matches.addAll(Arrays.asList(archetypes));
        }
    }
}

