/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.jxpath;

import java.math.BigDecimal;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.Constant;
import org.apache.commons.jxpath.ri.compiler.Expression;
import org.apache.commons.jxpath.ri.compiler.LocationPath;
import org.apache.commons.jxpath.ri.compiler.NameAttributeTest;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.Step;
import org.apache.commons.jxpath.ri.compiler.TreeCompiler;
import org.openvpms.component.system.common.jxpath.BigDecimalOperationAdd;
import org.openvpms.component.system.common.jxpath.BigDecimalOperationDivide;
import org.openvpms.component.system.common.jxpath.BigDecimalOperationEqual;
import org.openvpms.component.system.common.jxpath.BigDecimalOperationGreaterThan;
import org.openvpms.component.system.common.jxpath.BigDecimalOperationGreaterThanOrEqual;
import org.openvpms.component.system.common.jxpath.BigDecimalOperationLessThan;
import org.openvpms.component.system.common.jxpath.BigDecimalOperationLessThanOrEqual;
import org.openvpms.component.system.common.jxpath.BigDecimalOperationMod;
import org.openvpms.component.system.common.jxpath.BigDecimalOperationMultiply;
import org.openvpms.component.system.common.jxpath.BigDecimalOperationNegate;
import org.openvpms.component.system.common.jxpath.BigDecimalOperationNotEqual;
import org.openvpms.component.system.common.jxpath.BigDecimalOperationSubtract;
import org.openvpms.component.system.common.jxpath.OpenVPMSCoreFunction;

public class OpenVPMSTreeCompiler
extends TreeCompiler {
    private static final QName QNAME_NAME = new QName(null, "name");

    public Object number(String value) {
        return new Constant((Number)new BigDecimal(value));
    }

    public Object divide(Object left, Object right) {
        return new BigDecimalOperationDivide((Expression)left, (Expression)right);
    }

    public Object equal(Object left, Object right) {
        if (this.isNameAttributeTest((Expression)left)) {
            return new NameAttributeTest((Expression)left, (Expression)right);
        }
        return new BigDecimalOperationEqual((Expression)left, (Expression)right);
    }

    public Object greaterThan(Object left, Object right) {
        return new BigDecimalOperationGreaterThan((Expression)left, (Expression)right);
    }

    public Object greaterThanOrEqual(Object left, Object right) {
        return new BigDecimalOperationGreaterThanOrEqual((Expression)left, (Expression)right);
    }

    public Object lessThan(Object left, Object right) {
        return new BigDecimalOperationLessThan((Expression)left, (Expression)right);
    }

    public Object lessThanOrEqual(Object left, Object right) {
        return new BigDecimalOperationLessThanOrEqual((Expression)left, (Expression)right);
    }

    public Object minus(Object left, Object right) {
        return new BigDecimalOperationSubtract((Expression)left, (Expression)right);
    }

    public Object minus(Object argument) {
        return new BigDecimalOperationNegate((Expression)argument);
    }

    public Object mod(Object left, Object right) {
        return new BigDecimalOperationMod((Expression)left, (Expression)right);
    }

    public Object multiply(Object left, Object right) {
        return new BigDecimalOperationMultiply((Expression)left, (Expression)right);
    }

    public Object notEqual(Object left, Object right) {
        return new BigDecimalOperationNotEqual((Expression)left, (Expression)right);
    }

    public Object sum(Object[] arguments) {
        return new BigDecimalOperationAdd(this.toExpressionArray(arguments));
    }

    public Object function(int code, Object[] args) {
        return new OpenVPMSCoreFunction(code, this.toExpressionArray(args));
    }

    private boolean isNameAttributeTest(Expression arg) {
        if (!(arg instanceof LocationPath)) {
            return false;
        }
        Step[] steps = ((LocationPath)arg).getSteps();
        if (steps.length != 1) {
            return false;
        }
        if (steps[0].getAxis() != 5) {
            return false;
        }
        NodeTest test = steps[0].getNodeTest();
        if (!(test instanceof NodeNameTest)) {
            return false;
        }
        return ((NodeNameTest)test).getNodeName().equals((Object)QNAME_NAME);
    }

    private Expression[] toExpressionArray(Object[] array) {
        Expression[] expArray = null;
        if (array != null) {
            expArray = new Expression[array.length];
            for (int i = 0; i < expArray.length; ++i) {
                expArray[i] = (Expression)array[i];
            }
        }
        return expArray;
    }
}

