/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.security.memory;

import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.Properties;
import org.openvpms.component.business.domain.im.security.ArchetypeAwareGrantedAuthority;
import org.openvpms.component.business.domain.im.security.User;
import org.openvpms.component.business.service.security.memory.UserMap;
import org.springframework.beans.propertyeditors.PropertiesEditor;
import org.springframework.util.StringUtils;

public class UserMapEditor
extends PropertyEditorSupport {
    @Override
    public void setAsText(String str) throws IllegalArgumentException {
        UserMap userMap = new UserMap();
        if (StringUtils.hasText((String)str)) {
            PropertiesEditor propertiesEditor = new PropertiesEditor();
            propertiesEditor.setAsText(str);
            Properties props = (Properties)propertiesEditor.getValue();
            UserMapEditor.addUsersFromProperties(userMap, props);
        }
        this.setValue(userMap);
    }

    public static UserMap addUsersFromProperties(UserMap userMap, Properties props) {
        for (Object o : props.keySet()) {
            String username = (String)o;
            String value = props.getProperty(username);
            String[] tokens = StringUtils.commaDelimitedListToStringArray((String)value);
            String password = tokens[0];
            ArrayList<ArchetypeAwareGrantedAuthority> authorities = new ArrayList<ArchetypeAwareGrantedAuthority>();
            for (int index = 1; index < tokens.length; ++index) {
                authorities.add(new ArchetypeAwareGrantedAuthority(tokens[index]));
            }
            userMap.addUser(new User(username, password, true));
        }
        return userMap;
    }
}

