/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.helper.lookup;

import java.util.Collection;
import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.openvpms.component.business.service.archetype.helper.LookupHelperException;
import org.openvpms.component.business.service.archetype.helper.lookup.LookupAssertion;
import org.openvpms.component.business.service.archetype.helper.lookup.LookupAssertionHelper;
import org.openvpms.component.model.archetype.ArchetypeDescriptor;
import org.openvpms.component.model.archetype.AssertionDescriptor;
import org.openvpms.component.model.archetype.NodeDescriptor;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;

abstract class AbstractLookupAssertion
implements LookupAssertion {
    private final AssertionDescriptor descriptor;
    private final String type;
    private final ArchetypeService service;
    private final LookupService lookupService;

    protected AbstractLookupAssertion(AssertionDescriptor descriptor, String type, ArchetypeService service, LookupService lookupService) {
        this.descriptor = descriptor;
        this.type = type;
        this.service = service;
        this.lookupService = lookupService;
    }

    @Override
    public AssertionDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public List<Lookup> getLookups() {
        throw new LookupHelperException(LookupHelperException.ErrorCode.InvalidLookupAssertion, new Object[]{this.descriptor.getName()});
    }

    @Override
    public Collection<Lookup> getLookups(IMObject context) {
        return this.getLookups();
    }

    @Override
    public Lookup getLookup(String code) {
        throw new LookupHelperException(LookupHelperException.ErrorCode.InvalidLookupAssertion, new Object[]{this.descriptor.getName()});
    }

    @Override
    public Lookup getLookup(IMObject context, String code) {
        return this.getLookup(code);
    }

    @Override
    public String getName(String code) {
        Lookup lookup = this.getLookup(code);
        return lookup != null ? lookup.getName() : null;
    }

    @Override
    public String getName(IMObject context, String code) {
        return this.getName(code);
    }

    @Override
    public Lookup getDefault() {
        for (Lookup lookup : this.getLookups()) {
            if (!lookup.isDefaultLookup()) continue;
            return lookup;
        }
        return null;
    }

    protected ArchetypeService getArchetypeService() {
        return this.service;
    }

    protected LookupService getLookupService() {
        return this.lookupService;
    }

    protected String getProperty(String name) {
        return LookupAssertionHelper.getValue(this.descriptor, name);
    }

    protected Lookup getLookup(IMObject context, String nodePath, String relationshipShortName, String relationshipNode) {
        String shortName;
        String[] shortNames;
        Lookup result = null;
        String code = this.getPathValue(context, nodePath);
        String[] stringArray = shortNames = this.getArchetypeShortNames(relationshipShortName, relationshipNode);
        int n = stringArray.length;
        for (int i = 0; i < n && (result = this.lookupService.getLookup(shortName = stringArray[i], code, false)) == null; ++i) {
        }
        return result;
    }

    protected String[] getArchetypeShortNames(String relationship, String node) {
        String filter;
        ArchetypeDescriptor archetype = this.service.getArchetypeDescriptor(relationship);
        if (archetype == null) {
            throw new LookupHelperException(LookupHelperException.ErrorCode.LookupRelationshipArchetypeNotDefined, new Object[]{relationship});
        }
        NodeDescriptor ndesc = archetype.getNodeDescriptor(node);
        if (ndesc == null) {
            throw new LookupHelperException(LookupHelperException.ErrorCode.InvalidLookupRelationshipArchetypeDefinition, new Object[]{relationship, node});
        }
        String[] types = ndesc.getArchetypeRange();
        if (types.length == 0 && (filter = ndesc.getFilter()) != null) {
            types = new String[]{filter};
        }
        if (types.length == 0) {
            throw new LookupHelperException(LookupHelperException.ErrorCode.NoArchetypeRangeInLookupRelationship, new Object[]{relationship, node});
        }
        return types;
    }

    protected String getPathValue(IMObject context, String path) {
        return (String)JXPathContext.newContext((Object)context).getValue(path);
    }
}

