/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.helper;

import java.util.Comparator;
import java.util.Date;
import java.util.function.Predicate;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.bean.PolicyBuilder;
import org.openvpms.component.model.bean.RelatedObjectPolicyBuilder;
import org.openvpms.component.model.bean.RelatedObjects;
import org.openvpms.component.model.object.Relationship;

public class DefaultRelatedObjectPolicyBuilder<T, R extends Relationship, P extends RelatedObjects<T, R, P>>
implements RelatedObjectPolicyBuilder<T, R, P> {
    private final P parent;
    private final PolicyBuilder<R> builder;

    public DefaultRelatedObjectPolicyBuilder(P parent, Class<R> type) {
        this.parent = parent;
        this.builder = Policies.newPolicy(type);
    }

    public RelatedObjectPolicyBuilder<T, R, P> active() {
        this.builder.active();
        return this;
    }

    public RelatedObjectPolicyBuilder<T, R, P> active(Date time) {
        this.builder.active(time);
        return this;
    }

    public RelatedObjectPolicyBuilder<T, R, P> activeObjects() {
        this.builder.activeObjects();
        return this;
    }

    public RelatedObjectPolicyBuilder<T, R, P> inactiveObjects() {
        this.builder.inactiveObjects();
        return this;
    }

    public RelatedObjectPolicyBuilder<T, R, P> anyObject() {
        this.builder.anyObject();
        return this;
    }

    public RelatedObjectPolicyBuilder<T, R, P> predicate(Predicate<R> predicate) {
        this.builder.predicate(predicate);
        return this;
    }

    public RelatedObjectPolicyBuilder<T, R, P> and(Predicate<R> predicate) {
        this.builder.and(predicate);
        return this;
    }

    public RelatedObjectPolicyBuilder<T, R, P> or(Predicate<R> predicate) {
        this.builder.or(predicate);
        return this;
    }

    public RelatedObjectPolicyBuilder<T, R, P> comparator(Comparator<R> comparator) {
        this.builder.comparator(comparator);
        return this;
    }

    public P build() {
        return (P)this.parent.policy(this.builder.build());
    }
}

