/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.handler;

import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.service.archetype.handler.ArchetypeHandler;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.service.archetype.ArchetypeService;

public abstract class AbstractArchetypeHandlers<T> {
    private final ArchetypeService service;

    protected AbstractArchetypeHandlers(ArchetypeService service) {
        this.service = service;
    }

    public abstract ArchetypeHandler<T> getHandler(String var1);

    protected String getShortName(String shortName, Collection<String> wildcards) {
        return this.getShortName(new String[]{shortName}, wildcards);
    }

    protected String getShortName(String[] shortNames, Collection<String> wildcards) {
        String match = null;
        int bestDotCount = -1;
        int bestWildCardCount = -1;
        int bestMatchCount = -1;
        for (String wildcard : wildcards) {
            if (!TypeHelper.matches(shortNames, wildcard)) continue;
            if (match == null) {
                match = wildcard;
                bestDotCount = StringUtils.countMatches((CharSequence)wildcard, (CharSequence)".");
                bestWildCardCount = StringUtils.countMatches((CharSequence)wildcard, (CharSequence)"*");
                String[] matches = this.getShortNames(wildcard, false);
                bestMatchCount = matches.length;
                continue;
            }
            int dotCount = StringUtils.countMatches((CharSequence)wildcard, (CharSequence)".");
            int wildcardCount = StringUtils.countMatches((CharSequence)wildcard, (CharSequence)"*");
            if (dotCount > bestDotCount || dotCount == bestDotCount && wildcardCount < bestWildCardCount) {
                bestDotCount = dotCount;
                bestWildCardCount = wildcardCount;
                match = wildcard;
                continue;
            }
            String[] wildcardMatches = this.getShortNames(wildcard, false);
            int matchCount = wildcardMatches.length;
            if (matchCount >= bestMatchCount) continue;
            bestMatchCount = matchCount;
            match = wildcard;
        }
        return match;
    }

    protected String[] getShortNames(String shortName) {
        return DescriptorHelper.getShortNames(shortName, this.service);
    }

    protected String[] getShortNames(String shortName, boolean primaryOnly) {
        return DescriptorHelper.getShortNames(shortName, primaryOnly, this.service);
    }
}

