/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.functor;

import java.util.Comparator;
import org.apache.commons.collections4.comparators.ReverseComparator;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.system.common.util.DateHelper;

public class ActComparator<T extends Act>
implements Comparator<T> {
    private static final Comparator<Act> ASCENDING = new ActComparator<Act>();
    private static final Comparator<Act> DESCENDING = new ReverseComparator(ASCENDING);

    private ActComparator() {
    }

    @Override
    public int compare(T o1, T o2) {
        int result = DateHelper.compareTo(o1.getActivityStartTime(), o2.getActivityStartTime(), false);
        if (result == 0) {
            result = Long.compare(o1.getId(), o2.getId());
        }
        return result;
    }

    public static <T extends Act> Comparator<T> ascending() {
        return (ActComparator)ASCENDING;
    }

    public static <T extends Act> Comparator<T> descending() {
        return DESCENDING;
    }
}

