/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im.common;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class MapConverter<K, VS, VT> {
    public void convert(Map<K, VT> target, Map<K, VS> source) {
        if (target.isEmpty()) {
            for (Map.Entry<K, VS> entry : source.entrySet()) {
                VT value = this.convert(entry.getValue());
                target.put(entry.getKey(), value);
            }
        } else if (source.isEmpty()) {
            target.clear();
        } else {
            Map<K, VT> retained = this.getRetained(target, source);
            Set<K> removed = this.getRemoved(target, retained);
            this.remove(target, removed);
            for (Map.Entry<K, VT> entry : retained.entrySet()) {
                VT value = entry.getValue();
                VS src = source.get(entry.getKey());
                this.convert(target, entry.getKey(), value, src);
            }
            Map<K, VS> added = this.getAdded(retained, source);
            for (Map.Entry<K, VS> entry : added.entrySet()) {
                VT value = this.convert(entry.getValue());
                target.put(entry.getKey(), value);
            }
        }
    }

    protected void convert(Map<K, VT> map, K key, VT target, VS source) {
        VT newValue = this.convert(source);
        if (!Objects.equals(map.get(key), newValue)) {
            map.put(key, newValue);
        }
    }

    protected abstract VT convert(VS var1);

    protected void remove(Map<K, VT> target, Set<K> set) {
        if (!set.isEmpty()) {
            target.keySet().removeAll(set);
        }
    }

    protected Set<K> getRemoved(Map<K, VT> target, Map<K, VT> retained) {
        HashMap<K, VT> result = new HashMap<K, VT>(target);
        result.keySet().removeAll(retained.keySet());
        return result.keySet();
    }

    protected Map<K, VT> getRetained(Map<K, VT> target, Map<K, VS> source) {
        HashMap<K, VT> result = new HashMap<K, VT>(target);
        result.keySet().retainAll(source.keySet());
        return result;
    }

    protected Map<K, VS> getAdded(Map<K, VT> retained, Map<K, VS> source) {
        HashMap<K, VS> result = new HashMap<K, VS>(source);
        result.keySet().removeAll(retained.keySet());
        return result;
    }
}

