/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.StaleObjectStateException;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.openvpms.component.business.dao.hibernate.im.common.AuditableIMObjectDO;
import org.openvpms.component.business.dao.hibernate.im.common.Context;
import org.openvpms.component.business.dao.hibernate.im.common.DeferredAssembler;
import org.openvpms.component.business.dao.hibernate.im.common.HibernateHelper;
import org.openvpms.component.business.dao.hibernate.im.common.IMObjectDO;
import org.openvpms.component.business.dao.hibernate.im.common.IMObjectDOImpl;
import org.openvpms.component.business.dao.hibernate.im.common.ReferenceUpdater;
import org.openvpms.component.business.dao.hibernate.im.security.UserDO;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.model.object.AuditableIMObject;
import org.openvpms.component.model.object.Reference;

public class DOState {
    private final IMObjectDO object;
    private final boolean isNew;
    private final long version;
    private IMObject source;
    private List<DeferredAssembler> deferred;
    private List<ReferenceUpdater> updaters;
    private Map<Reference, ReferenceUpdater> reverters;
    private Map<String, DOState> states;

    public DOState(IMObjectDO object) {
        this(object, null);
    }

    public DOState(IMObjectDO object, IMObject source) {
        this.object = object;
        this.source = source;
        this.isNew = source != null && source.isNew();
        long l = this.version = source != null ? source.getVersion() : 0L;
        if (!this.isNew && source != null && source.getVersion() != object.getVersion()) {
            throw new StaleObjectStateException(object.getClass().getName(), (Serializable)Long.valueOf(object.getId()));
        }
    }

    public IMObjectDO getObject() {
        return this.object;
    }

    public IMObject getSource() {
        return this.source;
    }

    public boolean equals(Object other) {
        return other == this || other instanceof DOState && this.object.equals(((DOState)other).object);
    }

    public int hashCode() {
        return this.object.hashCode();
    }

    public void addState(DOState state) {
        if (this.states == null) {
            this.states = new LinkedHashMap<String, DOState>();
        } else if (!state.isUninitialised()) {
            this.removeState(state.getObject());
        }
        this.states.put(state.getKey(), state);
    }

    public void removeState(IMObjectDO object) {
        if (this.states != null && this.states.remove(this.getKey(object)) == null && !HibernateHelper.isUnintialised(object) && object.getId() != -1L) {
            String key;
            object = (IMObjectDO)HibernateHelper.deproxy(object);
            for (Class<?> impl = object.getClass(); impl != IMObjectDOImpl.class && impl != Object.class && this.states.remove(key = impl.getName() + "#" + object.getId()) == null; impl = impl.getSuperclass()) {
            }
        }
    }

    public void addDeferred(DeferredAssembler assembler) {
        if (this.deferred == null) {
            this.deferred = new ArrayList<DeferredAssembler>();
        }
        this.deferred.add(assembler);
    }

    public void removeDeferred(DeferredAssembler assembler) {
        this.deferred.remove(assembler);
    }

    public Set<DeferredAssembler> getDeferred() {
        DeferredCollector collector = new DeferredCollector();
        collector.visit(this);
        return collector.getAssemblers();
    }

    public void addReferenceUpdater(ReferenceUpdater updater) {
        if (this.updaters == null) {
            this.updaters = new ArrayList<ReferenceUpdater>();
        }
        this.updaters.add(updater);
    }

    public boolean isComplete() {
        return new CompleteVistor().visit(this);
    }

    public void updateIds(Context context) {
        new IdUpdater(context).visit(this);
    }

    public Collection<IMObjectDO> getObjects() {
        ObjectCollector collector = new ObjectCollector();
        collector.visit(this);
        return collector.getObjects();
    }

    public void update(IMObject source) {
        if (source.getVersion() != this.object.getVersion()) {
            throw new StaleObjectStateException(this.object.getClass().getName(), (Serializable)Long.valueOf(this.object.getId()));
        }
        this.source = source;
        if (this.deferred != null) {
            this.deferred.clear();
        }
        if (this.updaters != null) {
            if (this.reverters == null) {
                this.reverters = new HashMap<Reference, ReferenceUpdater>();
            }
            for (ReferenceUpdater updater : this.updaters) {
                if (this.reverters.containsKey(updater.getReference())) continue;
                this.reverters.put(updater.getReference(), updater);
            }
            this.updaters.clear();
        }
    }

    public void destroy() {
        new Cleaner().visit(this);
    }

    public boolean isUninitialised() {
        return HibernateHelper.isUnintialised(this.object);
    }

    public String toString() {
        final StringBuilder builder = new StringBuilder();
        Visitor visitor = new Visitor(){
            boolean first = true;

            @Override
            protected boolean doVisit(DOState state) {
                if (!this.first) {
                    builder.append("\n -> ");
                } else {
                    this.first = false;
                }
                if (state.getSource() != null) {
                    builder.append(state.getSource().getObjectReference());
                } else if (state.isUninitialised()) {
                    builder.append("uninitialised=").append(state.getKey());
                } else {
                    builder.append(state.getObject().getObjectReference());
                }
                return true;
            }
        };
        visitor.visit(this);
        return builder.toString();
    }

    public static Map<DOState, Set<DeferredAssembler>> getDeferred(Collection<DOState> states) {
        HashMap<DOState, Set<DeferredAssembler>> result = new HashMap<DOState, Set<DeferredAssembler>>();
        DeferredCollector collector = new DeferredCollector();
        for (DOState state : states) {
            collector.visit(state);
            result.put(state, collector.getAssemblers());
        }
        return result;
    }

    public static Collection<IMObjectDO> getObjects(Collection<DOState> states) {
        ObjectCollector collector = new ObjectCollector();
        for (DOState state : states) {
            collector.visitFirst(state);
        }
        for (DOState state : states) {
            collector.visit(state);
        }
        return collector.getObjects();
    }

    public static void updateIds(Collection<DOState> states, Context context) {
        IdUpdater updater = new IdUpdater(context);
        for (DOState state : states) {
            updater.visit(state);
        }
    }

    public static void rollbackIds(Collection<DOState> states) {
        IdReverter reverter = new IdReverter();
        for (DOState state : states) {
            reverter.visit(state);
        }
    }

    protected String getKey() {
        return this.getKey(this.object);
    }

    private String getKey(IMObjectDO object) {
        HibernateProxy proxy;
        LazyInitializer init;
        String id = null;
        if (object instanceof HibernateProxy && (init = (proxy = (HibernateProxy)object).getHibernateLazyInitializer()).isUninitialized()) {
            id = init.getPersistentClass().getName() + "#" + init.getIdentifier().toString();
        }
        if (id == null) {
            id = object.getLinkId();
        }
        return id;
    }

    private static class ObjectCollector
    extends Visitor {
        private final Map<String, IMObjectDO> objects = new LinkedHashMap<String, IMObjectDO>();

        private ObjectCollector() {
        }

        public Collection<IMObjectDO> getObjects() {
            return this.objects.values();
        }

        public void visitFirst(DOState state) {
            this.addVisited(state);
            this.doVisit(state);
        }

        @Override
        protected boolean doVisit(DOState state) {
            IMObjectDO object = state.getObject();
            this.objects.put(state.getKey(), object);
            return true;
        }
    }

    private static class Cleaner
    extends Visitor {
        private Cleaner() {
        }

        @Override
        public boolean visit(DOState state) {
            this.addVisited(state);
            this.visitChildren(state);
            this.doVisit(state);
            return true;
        }

        @Override
        protected boolean doVisit(DOState state) {
            Map states;
            Map reverters;
            List updaters;
            List deferred = state.deferred;
            if (deferred != null) {
                deferred.clear();
            }
            if ((updaters = state.updaters) != null) {
                updaters.clear();
            }
            if ((reverters = state.reverters) != null) {
                reverters.clear();
            }
            if ((states = state.states) != null) {
                states.clear();
            }
            return true;
        }
    }

    private static class DeferredCollector
    extends Visitor {
        private Set<DeferredAssembler> assemblers;
        private static final Set<DeferredAssembler> EMPTY = Collections.emptySet();

        private DeferredCollector() {
        }

        public Set<DeferredAssembler> getAssemblers() {
            Set<DeferredAssembler> result = this.assemblers;
            this.assemblers = null;
            return result != null ? result : EMPTY;
        }

        @Override
        protected boolean doVisit(DOState state) {
            List deferred = state.deferred;
            if (deferred != null && !state.deferred.isEmpty()) {
                if (this.assemblers == null) {
                    this.assemblers = new LinkedHashSet<DeferredAssembler>();
                }
                this.assemblers.addAll(deferred);
            }
            return true;
        }
    }

    private static class IdReverter
    extends Visitor {
        private IdReverter() {
        }

        @Override
        protected boolean doVisit(DOState state) {
            IMObject source;
            if (state.isNew && (source = state.source) != null) {
                source.setId(-1L);
                source.setVersion(state.version);
            }
            if (state.reverters != null) {
                for (ReferenceUpdater reverter : state.reverters.values()) {
                    reverter.revert();
                }
            }
            return true;
        }
    }

    private static class IdUpdater
    extends Visitor {
        private final Context context;

        public IdUpdater(Context context) {
            this.context = context;
        }

        @Override
        protected boolean doVisit(DOState state) {
            List updaters;
            IMObjectDO object = state.getObject();
            IMObject source = state.getSource();
            if (source != null) {
                source.setId(object.getId());
                source.setVersion(object.getVersion());
                if (source instanceof AuditableIMObject && object instanceof AuditableIMObjectDO) {
                    AuditableIMObject auditableSource = (AuditableIMObject)source;
                    AuditableIMObjectDO auditableObject = (AuditableIMObjectDO)object;
                    auditableSource.setCreated(auditableObject.getCreated());
                    auditableSource.setUpdated(auditableObject.getUpdated());
                    UserDO createdBy = auditableObject.getCreatedBy();
                    UserDO updatedBy = auditableObject.getUpdatedBy();
                    auditableSource.setCreatedBy((Reference)(createdBy != null ? createdBy.getObjectReference() : null));
                    auditableSource.setUpdatedBy((Reference)(updatedBy != null ? updatedBy.getObjectReference() : null));
                }
            }
            if ((updaters = state.updaters) != null) {
                for (ReferenceUpdater updater : updaters) {
                    DOState target = this.context.getCached(updater.getReference());
                    if (target == null) continue;
                    IMObjectReference ref = target.getObject().getObjectReference();
                    updater.doUpdate(ref);
                }
            }
            return true;
        }
    }

    private static class CompleteVistor
    extends Visitor {
        private CompleteVistor() {
        }

        @Override
        protected boolean doVisit(DOState state) {
            List deferred = state.deferred;
            return deferred == null || deferred.isEmpty();
        }
    }

    private static abstract class Visitor {
        private final Set<String> visited = new HashSet<String>();

        private Visitor() {
        }

        public boolean visit(DOState state) {
            this.addVisited(state);
            boolean result = this.doVisit(state);
            if (result) {
                result = this.visitChildren(state);
            }
            return result;
        }

        public boolean visit(List<DOState> states) {
            DOState state;
            boolean result = true;
            Iterator<DOState> iterator = states.iterator();
            while (iterator.hasNext() && (result = this.visit(state = iterator.next()))) {
            }
            return result;
        }

        protected abstract boolean doVisit(DOState var1);

        protected boolean visitChildren(DOState state) {
            boolean result = true;
            Map states = state.states;
            if (states != null) {
                for (DOState child : states.values()) {
                    if (this.visited(child) || this.visit(child)) continue;
                    result = false;
                    break;
                }
            }
            return result;
        }

        protected boolean addVisited(DOState state) {
            return this.visited.add(state.getKey());
        }

        private boolean visited(DOState state) {
            return this.visited.contains(state.getKey());
        }
    }
}

