/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im.common;

import java.util.HashMap;
import java.util.Map;
import org.openvpms.component.business.dao.hibernate.im.common.AbstractAssembler;
import org.openvpms.component.business.dao.hibernate.im.common.Assembler;
import org.openvpms.component.business.dao.hibernate.im.common.Context;
import org.openvpms.component.business.dao.hibernate.im.common.DOState;
import org.openvpms.component.business.dao.hibernate.im.common.IMObjectAssembler;
import org.openvpms.component.business.dao.hibernate.im.common.IMObjectDO;
import org.openvpms.component.business.dao.hibernate.im.common.IMObjectDOImpl;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.service.archetype.descriptor.cache.IArchetypeDescriptorCache;
import org.openvpms.component.model.object.Reference;

public abstract class CompoundAssembler
extends AbstractAssembler
implements Assembler {
    private final IArchetypeDescriptorCache archetypes;
    private final Map<Class<? extends IMObject>, Assembler> doAssemblers = new HashMap<Class<? extends IMObject>, Assembler>();
    private final Map<Class<? extends IMObjectDO>, Assembler> assemblers = new HashMap<Class<? extends IMObjectDO>, Assembler>();
    private final Map<Class<? extends org.openvpms.component.model.object.IMObject>, Class<? extends IMObjectDOImpl>> typeImplMap = new HashMap<Class<? extends org.openvpms.component.model.object.IMObject>, Class<? extends IMObjectDOImpl>>();
    private final Map<String, String> typeDONameMap = new HashMap<String, String>();

    public CompoundAssembler(IArchetypeDescriptorCache archetypes) {
        this.archetypes = archetypes;
    }

    public String getDOClassName(String className) {
        return this.typeDONameMap.get(className);
    }

    public <T extends org.openvpms.component.model.object.IMObject> Class<? extends IMObjectDOImpl> getDOClass(Class<T> type) {
        return this.typeImplMap.get(type);
    }

    public void addAssembler(IMObjectAssembler<? extends IMObject, ? extends IMObjectDO> assembler) {
        this.doAssemblers.put(assembler.getTypeImpl(), assembler);
        this.assemblers.put(assembler.getDOType(), assembler);
        this.assemblers.put(assembler.getDOImplType(), assembler);
        Class<org.openvpms.component.model.object.IMObject> type = assembler.getType();
        if (type != null) {
            this.typeImplMap.put(type, assembler.getDOImplType());
        }
        this.typeImplMap.put(assembler.getTypeImpl(), assembler.getDOImplType());
        this.typeDONameMap.put(assembler.getTypeImpl().getName(), assembler.getDOType().getName());
    }

    @Override
    public DOState assemble(IMObject source, Context context) {
        Assembler assembler = this.getAssembler(source);
        return assembler.assemble(source, context);
    }

    @Override
    public DOState assemble(Reference source, Context context) {
        ArchetypeDescriptor archetypeDescriptor = this.archetypes.getArchetypeDescriptor(source.getArchetype());
        if (archetypeDescriptor == null) {
            throw new IllegalStateException("No archetype descriptor for reference: " + source);
        }
        Assembler assembler = this.doAssemblers.get(archetypeDescriptor.getClassType());
        if (assembler == null) {
            throw new IllegalArgumentException("Unsupported type " + archetypeDescriptor.getClassType() + " for reference " + source);
        }
        return assembler.assemble(source, context);
    }

    @Override
    public DOState assemble(IMObjectDO target, IMObject source, Context context) {
        target = this.deproxy(target);
        Assembler assembler = this.getAssembler(source);
        return assembler.assemble(target, source, context);
    }

    @Override
    public IMObject assemble(IMObjectDO source, Context context) {
        source = this.deproxy(source);
        Assembler assembler = this.getAssembler(source);
        return assembler.assemble(source, context);
    }

    @Override
    public IMObject assemble(IMObject target, IMObjectDO source, Context context) {
        source = this.deproxy(source);
        Assembler assembler = this.getAssembler(source);
        return assembler.assemble(target, source, context);
    }

    private Assembler getAssembler(IMObject source) {
        Assembler assembler = this.doAssemblers.get(source.getClass());
        if (assembler == null) {
            throw new IllegalArgumentException("Unsupported type: " + source.getClass().getName());
        }
        return assembler;
    }

    private Assembler getAssembler(IMObjectDO source) {
        Assembler assembler = this.assemblers.get(source.getClass());
        if (assembler == null) {
            Class<? extends IMObjectDO> bestMatch = null;
            for (Map.Entry<Class<? extends IMObjectDO>, Assembler> entry : this.assemblers.entrySet()) {
                Class<? extends IMObjectDO> type = entry.getKey();
                if (!type.isAssignableFrom(source.getClass()) || bestMatch != null && !bestMatch.isAssignableFrom(type)) continue;
                bestMatch = type;
                assembler = entry.getValue();
            }
            if (assembler == null) {
                throw new IllegalArgumentException("Unsupported type: " + source.getClass().getName());
            }
        }
        return assembler;
    }
}

