/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2018 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.component.business.service.cache;


import org.ehcache.core.spi.service.StatisticsService;

/**
 * Basic implementation of the {@link EhcacheManager} interface.
 *
 * @author Tim Anderson
 */
public class BasicEhcacheManager extends AbstractEhcacheManager {

    /**
     * Constructs a {@link BasicEhcacheManager}.
     *
     * @param defaultMaxElements the default maximum no. of elements
     */
    public BasicEhcacheManager(long defaultMaxElements) {
        super(null, defaultMaxElements);
    }

    /**
     * Constructs an {@link AbstractEhcacheManager}.
     *
     * @param statistics         the statistics service
     * @param defaultMaxElements the default maximum no. of elements
     */
    public BasicEhcacheManager(StatisticsService statistics, long defaultMaxElements) {
        super(statistics, defaultMaxElements);
    }
}
