/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2025 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.component.business.service.archetype.assertion;

import org.openvpms.component.business.domain.im.archetype.descriptor.ActionContext;
import org.openvpms.component.business.domain.im.archetype.descriptor.AssertionDescriptor;
import org.openvpms.component.model.object.IMObject;

import java.util.Collection;

/**
 * {@link IMObject} assertions.
 *
 * @author Tim Anderson
 */
public class IMObjectAssertions extends AbstractIMObjectAssertions {

    /**
     * Assertion to indicate that there can be only one active object of a particular type.
     */
    public static final String UNIQUE_TYPE = "uniqueType";

    /**
     * The singleton instance.
     */
    private static final IMObjectAssertions instance = new IMObjectAssertions();

    /**
     * Default constructor.
     */
    private IMObjectAssertions() {
        // no-op
    }

    /**
     * Validates a relationship assertion.
     *
     * @param context the assertion context
     */
    public static boolean validate(ActionContext context) {
        return instance.isValid(context);
    }

    /**
     * Validates an identity assertion.
     *
     * @param context the assertion context
     */
    protected boolean isValid(ActionContext context) {
        boolean result = false;
        AssertionDescriptor assertion = context.getAssertion();
        if (UNIQUE_TYPE.equals(assertion.getName())) {
            Collection<IMObject> entries = getObjects(context.getValue(), IMObject.class);
            if (entries != null) {
                result = validateUniqueType(entries);
            }
        }
        return result;
    }
}
