/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tools.security.loader;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.openvpms.tools.security.loader.Role;
import org.xml.sax.ContentHandler;

public class UserData
implements Serializable {
    private String name;
    private String password;
    private String description;
    private List<Role> roleList = new ArrayList<Role>();

    public void addRole(Role vRole) throws IndexOutOfBoundsException {
        this.roleList.add(vRole);
    }

    public void addRole(int index, Role vRole) throws IndexOutOfBoundsException {
        this.roleList.add(index, vRole);
    }

    public Enumeration<? extends Role> enumerateRole() {
        return Collections.enumeration(this.roleList);
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public Role getRole(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.roleList.size()) {
            throw new IndexOutOfBoundsException("getRole: Index value '" + index + "' not in range [0.." + (this.roleList.size() - 1) + "]");
        }
        return this.roleList.get(index);
    }

    public Role[] getRole() {
        Role[] array = new Role[]{};
        return this.roleList.toArray(array);
    }

    public int getRoleCount() {
        return this.roleList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<? extends Role> iterateRole() {
        return this.roleList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllRole() {
        this.roleList.clear();
    }

    public boolean removeRole(Role vRole) {
        boolean removed = this.roleList.remove(vRole);
        return removed;
    }

    public Role removeRoleAt(int index) {
        Role obj = this.roleList.remove(index);
        return obj;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setRole(int index, Role vRole) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.roleList.size()) {
            throw new IndexOutOfBoundsException("setRole: Index value '" + index + "' not in range [0.." + (this.roleList.size() - 1) + "]");
        }
        this.roleList.set(index, vRole);
    }

    public void setRole(Role[] vRoleArray) {
        this.roleList.clear();
        for (int i = 0; i < vRoleArray.length; ++i) {
            this.roleList.add(vRoleArray[i]);
        }
    }

    public static UserData unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (UserData)Unmarshaller.unmarshal(UserData.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

