/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tools.data.loader;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.tools.data.loader.ArchetypeDataLoaderException;
import org.openvpms.tools.data.loader.LoadCache;

class Data {
    private final String id;
    private final String shortName;
    private final String collection;
    private Map<String, String> attributes = new LinkedHashMap<String, String>();
    private final Location location;

    public Data(XMLStreamReader reader) {
        this.shortName = reader.getAttributeValue(null, "archetype");
        this.location = reader.getLocation();
        if (StringUtils.isEmpty((CharSequence)this.shortName)) {
            throw new ArchetypeDataLoaderException(ArchetypeDataLoaderException.ErrorCode.InvalidArchetype, this.location.getLineNumber(), this.location.getColumnNumber(), "<null>");
        }
        if (!"data".equals(reader.getLocalName())) {
            throw new ArchetypeDataLoaderException(ArchetypeDataLoaderException.ErrorCode.UnexpectedElement, reader.getLocalName(), this.location.getLineNumber(), this.location.getColumnNumber());
        }
        this.id = reader.getAttributeValue(null, "id");
        this.collection = reader.getAttributeValue(null, "collection");
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            if ("archetype".equals(name) || "id".equals(name) || "collection".equals(name) || StringUtils.isEmpty((CharSequence)value)) continue;
            this.attributes.put(name, value);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getChildId() {
        return this.attributes.get("childId");
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getCollection() {
        return this.collection;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Location getLocation() {
        return this.location;
    }

    public boolean isComplete(LoadCache cache) {
        for (String value : this.attributes.values()) {
            if (!value.startsWith("id:") || cache.getReference(value) != null) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("<data ");
        for (Map.Entry<String, String> attribute : this.attributes.entrySet()) {
            result.append(attribute.getKey());
            result.append("=\"");
            result.append(attribute.getValue());
            result.append("\" ");
        }
        result.append("/>");
        return result.toString();
    }
}

