/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.query.criteria;

import java.util.ArrayList;
import java.util.List;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.query.criteria.From;
import org.openvpms.component.query.criteria.Join;
import org.openvpms.component.system.common.query.criteria.Context;
import org.openvpms.component.system.common.query.criteria.JoinImpl;
import org.openvpms.component.system.common.query.criteria.PathImpl;
import org.openvpms.component.system.common.query.criteria.Type;

public class FromImpl<Z extends IMObject, X extends IMObject>
extends PathImpl<X>
implements From<Z, X> {
    private final List<JoinImpl<X, ? extends IMObject>> joins = new ArrayList<JoinImpl<X, ? extends IMObject>>();

    public FromImpl(Type<X> type, PathImpl<?> parent, Context context) {
        super(type, parent, context);
    }

    public <Y extends IMObject> Join<X, Y> join(String name) {
        return this.join(name, JoinImpl.JoinType.INNER);
    }

    public <Y extends IMObject> Join<X, Y> join(String name, String archetype) {
        return this.join(name, new String[]{archetype}, JoinImpl.JoinType.INNER);
    }

    public <Y extends IMObject> Join<X, Y> join(String name, String ... archetypes) {
        return this.join(name, archetypes, JoinImpl.JoinType.INNER);
    }

    public <Y extends IMObject> Join<X, Y> leftJoin(String name) {
        return this.join(name, JoinImpl.JoinType.LEFT);
    }

    public <Y extends IMObject> Join<X, Y> leftJoin(String name, String archetype) {
        return this.join(name, new String[]{archetype}, JoinImpl.JoinType.LEFT);
    }

    public <Y extends IMObject> Join<X, Y> leftJoin(String name, String ... archetypes) {
        return this.join(name, archetypes, JoinImpl.JoinType.LEFT);
    }

    public List<JoinImpl<X, ? extends IMObject>> getJoins() {
        return this.joins;
    }

    private <Y extends IMObject> Join<X, Y> join(String name, JoinImpl.JoinType joinType) {
        Context context = this.getContext();
        Type type = context.getTypeForJoin(this.getType(), name);
        JoinImpl join = new JoinImpl(type, this, context, joinType);
        this.joins.add(join);
        return join;
    }

    private <Y extends IMObject> Join<X, Y> join(String name, String[] archetypes, JoinImpl.JoinType joinType) {
        Context context = this.getContext();
        Type type = context.getTypeForJoin(this.getType(), name, archetypes);
        JoinImpl join = new JoinImpl(type, this, context, joinType);
        this.joins.add(join);
        return join;
    }
}

