/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.Predicate;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeList;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.domain.im.common.Beanable;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.domain.im.common.IMObjectRelationship;
import org.openvpms.component.business.domain.im.datatypes.quantity.Money;
import org.openvpms.component.business.service.archetype.ArchetypeServiceHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.functor.IsActiveRelationship;
import org.openvpms.component.business.service.archetype.helper.AbstractNodePropertySet;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.helper.IMObjectBeanException;
import org.openvpms.component.business.service.archetype.helper.RelatedIMObjectsImpl;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.business.service.archetype.helper.lookup.LookupAssertion;
import org.openvpms.component.business.service.archetype.helper.lookup.LookupAssertionFactory;
import org.openvpms.component.business.service.lookup.LookupServiceHelper;
import org.openvpms.component.model.archetype.ArchetypeRange;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.bean.Policy;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.bean.RelatedIMObjects;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.PeriodRelationship;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.jxpath.JXPathHelper;

public class IMObjectBean
implements org.openvpms.component.model.bean.IMObjectBean {
    private final NodePropertySet properties;
    private IArchetypeService service;
    private LookupService lookups;

    public IMObjectBean(org.openvpms.component.model.object.IMObject object) {
        this(object, null);
    }

    public IMObjectBean(org.openvpms.component.model.object.IMObject object, IArchetypeService service) {
        this.service = service;
        this.properties = new NodePropertySet(this.cast(object));
    }

    public IMObjectBean(org.openvpms.component.model.object.IMObject object, IArchetypeService service, LookupService lookups) {
        this.service = service;
        this.lookups = lookups;
        this.properties = new NodePropertySet(this.cast(object));
    }

    public IMObject getObject() {
        return this.properties.getObject();
    }

    public <T extends org.openvpms.component.model.object.IMObject> T getObject(Class<T> type) {
        return this.cast(this.properties.getObject(), type);
    }

    public IMObjectReference getReference() {
        return this.getObject().getObjectReference();
    }

    public boolean isA(String ... shortNames) {
        return this.getObject().isA(shortNames);
    }

    public boolean hasNode(String name) {
        return this.getDescriptor(name) != null;
    }

    public NodeDescriptor getDescriptor(String name) {
        return this.getArchetype().getNodeDescriptor(name);
    }

    public NodeDescriptor getNode(String name) {
        return this.getDescriptor(name);
    }

    public String getDisplayName() {
        return this.getArchetype().getDisplayName();
    }

    public ArchetypeDescriptor getArchetype() {
        return this.properties.getArchetype();
    }

    public String getDisplayName(String name) {
        NodeDescriptor node = this.toNode(name);
        return node.getDisplayName();
    }

    public int getMaxLength(String name) {
        NodeDescriptor node = this.toNode(name);
        return node.getMaxLength();
    }

    public String[] getArchetypeRange(String name) {
        NodeDescriptor node = this.toNode(name);
        return DescriptorHelper.getShortNames(node, (ArchetypeService)this.getArchetypeService());
    }

    public ArchetypeRange getArchetypes(String name) {
        NodeDescriptor node = this.toNode(name);
        ArchetypeRange range = node.getArchetypes();
        return ArchetypeList.expand(range, this.service);
    }

    public boolean getBoolean(String name) {
        return this.properties.getBoolean(name);
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        return this.properties.getBoolean(name, defaultValue);
    }

    public int getInt(String name) {
        return this.properties.getInt(name);
    }

    public int getInt(String name, int defaultValue) {
        return this.properties.getInt(name, defaultValue);
    }

    public long getLong(String name) {
        return this.properties.getLong(name);
    }

    public long getLong(String name, long defaultValue) {
        return this.properties.getLong(name, defaultValue);
    }

    public String getString(String name) {
        return this.properties.getString(name);
    }

    public String getString(String name, String defaultValue) {
        return this.properties.getString(name, defaultValue);
    }

    public BigDecimal getBigDecimal(String name) {
        return this.properties.getBigDecimal(name);
    }

    public BigDecimal getBigDecimal(String name, BigDecimal defaultValue) {
        return this.properties.getBigDecimal(name, defaultValue);
    }

    public Money getMoney(String name) {
        return this.properties.getMoney(name);
    }

    public Money getMoney(String name, Money defaultValue) {
        return this.properties.getMoney(name, defaultValue);
    }

    public Date getDate(String name) {
        return this.properties.getDate(name);
    }

    public Date getDate(String name, Date defaultValue) {
        return this.properties.getDate(name, defaultValue);
    }

    public IMObjectReference getReference(String node) {
        return this.properties.getReference(node);
    }

    public IMObject getObject(String name) {
        Object value;
        List<IMObject> values;
        NodeDescriptor node = this.toNode(name);
        IMObject result = node.isCollection() ? (!(values = this.getValues(node)).isEmpty() ? values.get(0) : null) : ((value = this.getValue(node)) instanceof Reference ? this.resolve((Reference)value, Policy.State.ANY) : (IMObject)value);
        return result;
    }

    public <T extends org.openvpms.component.model.object.IMObject> T getObject(String name, Class<T> type) {
        IMObject result = this.getObject(name);
        return this.cast(result, type);
    }

    public Object getValue(String name) {
        NodeDescriptor node = this.toNode(name);
        return this.getValue(node);
    }

    public List<org.openvpms.component.model.object.IMObject> getValues(String name) {
        NodeDescriptor node = this.toNode(name);
        return this.getValues(node);
    }

    public Lookup getLookup(String name) {
        NodeDescriptor node = this.toNode(name);
        Lookup result = null;
        IMObject object = this.getObject();
        Object value = node.getValue(object);
        if (value != null) {
            LookupAssertion assertion = LookupAssertionFactory.create(node, this.service, this.getLookups());
            result = assertion.getLookup(object, value.toString());
        }
        return result;
    }

    public List<org.openvpms.component.model.object.IMObject> getValues(String name, java.util.function.Predicate<org.openvpms.component.model.object.IMObject> predicate) {
        return this.getValues(name).stream().filter(predicate).collect(Collectors.toList());
    }

    public <T extends org.openvpms.component.model.object.IMObject> List<T> getValues(String name, Class<T> type, java.util.function.Predicate<T> predicate) {
        return this.getValues(name, type).stream().filter(predicate).collect(Collectors.toList());
    }

    public <T extends org.openvpms.component.model.object.IMObject> T getValue(String name, Class<T> type, java.util.function.Predicate<T> predicate) {
        Optional first = this.getValues(name, type).stream().filter(predicate).findFirst();
        return (T)((org.openvpms.component.model.object.IMObject)first.orElse(null));
    }

    public List<org.openvpms.component.model.object.IMObject> removeValues(String name) {
        return this.removeValues(name, org.openvpms.component.model.object.IMObject.class);
    }

    public <T extends org.openvpms.component.model.object.IMObject> List<T> removeValues(String name, Class<T> type) {
        List<T> values = this.getValues(name, type);
        for (org.openvpms.component.model.object.IMObject value : values) {
            this.removeValue(name, value);
        }
        return values;
    }

    public IMObject getSource(String name) {
        return this.getSource(name, IMObject.class);
    }

    public <T extends org.openvpms.component.model.object.IMObject> T getSource(String name, Class<T> type) {
        return this.getSource(name, type, Policies.any());
    }

    public <R extends Relationship> IMObject getSource(String name, Policy<R> policy) {
        return this.getSource(name, IMObject.class, policy);
    }

    public <R extends Relationship> IMObject getSource(Collection<R> relationships, Policy<R> policy) {
        return this.getRelatedObject(relationships, policy, true);
    }

    public <T extends org.openvpms.component.model.object.IMObject, R extends Relationship> T getSource(Collection<R> relationships, Class<T> type, Policy<R> policy) {
        return this.cast(this.getSource((Collection)relationships, (Policy)policy), type);
    }

    public <T extends org.openvpms.component.model.object.IMObject, R extends Relationship> T getSource(String name, Class<T> type, Policy<R> policy) {
        return this.cast(this.getRelatedObject(name, policy, true), type);
    }

    public boolean hasSource(String name, org.openvpms.component.model.object.IMObject object) {
        return this.getValue(name, Relationship.class, Predicates.sourceEquals((org.openvpms.component.model.object.IMObject)object)) != null;
    }

    public IMObject getTarget(String name) {
        return this.getTarget(name, IMObject.class);
    }

    public <T extends org.openvpms.component.model.object.IMObject> T getTarget(String name, Class<T> type) {
        return this.getTarget(name, type, Policies.any());
    }

    public <R extends Relationship> IMObject getTarget(String name, Policy<R> policy) {
        return this.getTarget(name, IMObject.class, policy);
    }

    public <T extends org.openvpms.component.model.object.IMObject, R extends Relationship> T getTarget(String name, Class<T> type, Policy<R> policy) {
        return this.cast(this.getRelatedObject(name, policy, false), type);
    }

    public <R extends Relationship> org.openvpms.component.model.object.IMObject getTarget(Collection<R> relationships, Policy<R> policy) {
        return this.getRelatedObject(relationships, policy, false);
    }

    public <T extends org.openvpms.component.model.object.IMObject, R extends Relationship> T getTarget(Collection<R> relationships, Class<T> type, Policy<R> policy) {
        return this.cast(this.getTarget(relationships, policy), type);
    }

    public boolean hasTarget(String name, org.openvpms.component.model.object.IMObject object) {
        return this.hasTarget(name, object.getObjectReference());
    }

    public boolean hasTarget(String name, Reference target) {
        return this.getValue(name, Relationship.class, Predicates.targetEquals((Reference)target)) != null;
    }

    public Relationship setTarget(String name, Reference target) {
        Relationship relationship = this.getObject(name, Relationship.class);
        if (relationship == null) {
            if (target != null) {
                relationship = this.addTarget(name, target);
            }
        } else {
            relationship.setTarget(target);
        }
        return relationship;
    }

    public Relationship setTarget(String name, org.openvpms.component.model.object.IMObject target) {
        return this.setTarget(name, target != null ? target.getObjectReference() : null);
    }

    public List<org.openvpms.component.model.object.IMObject> getSources(String name) {
        return this.getSources(name, org.openvpms.component.model.object.IMObject.class);
    }

    public <T extends org.openvpms.component.model.object.IMObject> List<T> getSources(String name, Class<T> type) {
        return this.getSources(name, type, Policies.any());
    }

    public <R extends Relationship> List<org.openvpms.component.model.object.IMObject> getSources(String name, Policy<R> policy) {
        return this.getSources(name, org.openvpms.component.model.object.IMObject.class, policy);
    }

    public <T extends org.openvpms.component.model.object.IMObject, R extends Relationship> List<T> getSources(String name, Class<T> type, Policy<R> policy) {
        return this.getRelatedObjects(name, type, policy, true);
    }

    public List<org.openvpms.component.model.object.IMObject> getTargets(String name) {
        return this.getTargets(name, org.openvpms.component.model.object.IMObject.class);
    }

    public <T extends org.openvpms.component.model.object.IMObject> List<T> getTargets(String name, Class<T> type) {
        return this.getTargets(name, type, Policies.any());
    }

    public <R extends Relationship> List<org.openvpms.component.model.object.IMObject> getTargets(String name, Policy<R> policy) {
        return this.getTargets(name, org.openvpms.component.model.object.IMObject.class, policy);
    }

    public <T extends org.openvpms.component.model.object.IMObject, R extends Relationship> List<T> getTargets(String name, Class<T> type, Policy<R> policy) {
        return this.getRelatedObjects(name, type, policy, false);
    }

    public Reference getSourceRef(String name) {
        return this.getSourceRef(name, Policies.any());
    }

    public <R extends Relationship> Reference getSourceRef(String name, Policy<R> policy) {
        return this.getRelatedRef(name, policy, true);
    }

    public List<Reference> getSourceRefs(String name) {
        return this.getSourceRefs(name, Policies.any());
    }

    public <R extends Relationship> List<Reference> getSourceRefs(String name, Policy<R> policy) {
        return this.getRelatedRefs(name, policy, true);
    }

    public Reference getTargetRef(String name) {
        return this.getTargetRef(name, Policies.any());
    }

    public <R extends Relationship> IMObjectReference getTargetRef(String name, Policy<R> policy) {
        return this.getRelatedRef(name, policy, false);
    }

    public List<Reference> getTargetRefs(String name) {
        return this.getTargetRefs(name, Policies.any());
    }

    public <R extends Relationship> List<Reference> getTargetRefs(String name, Policy<R> policy) {
        return this.getRelatedRefs(name, policy, false);
    }

    public Relationship addTarget(String name, Reference target) {
        String archetype = this.getRelationshipTargetArchetype(name, target);
        return this.addTarget(name, archetype, target);
    }

    public Relationship addTarget(String name, org.openvpms.component.model.object.IMObject target) {
        return this.addTarget(name, target.getObjectReference());
    }

    public Relationship addTarget(String name, String archetype, org.openvpms.component.model.object.IMObject target) {
        return this.addTarget(name, archetype, target.getObjectReference());
    }

    public Relationship addTarget(String name, String archetype, Reference target) {
        return this.addRelationship(name, archetype, this.getReference(), target);
    }

    public IMObjectRelationship addTarget(String sourceName, org.openvpms.component.model.object.IMObject target, String targetName) {
        Relationship relationship = this.addTarget(sourceName, target);
        this.getBean(target).addValue(targetName, (org.openvpms.component.model.object.IMObject)relationship);
        return (IMObjectRelationship)relationship;
    }

    public IMObjectRelationship addTarget(String sourceName, String archetype, org.openvpms.component.model.object.IMObject target, String targetName) {
        Relationship relationship = this.addTarget(sourceName, archetype, target);
        this.getBean(target).addValue(targetName, (org.openvpms.component.model.object.IMObject)relationship);
        return (IMObjectRelationship)relationship;
    }

    public Relationship removeTarget(String name, Reference target) {
        Relationship result = this.getValue(name, Relationship.class, Predicates.targetEquals((Reference)target));
        if (result != null) {
            this.removeValue(name, (org.openvpms.component.model.object.IMObject)result);
        }
        return result;
    }

    public Relationship removeTarget(String name, org.openvpms.component.model.object.IMObject target) {
        return this.removeTarget(name, target.getObjectReference());
    }

    public void removeTargets(String sourceName, org.openvpms.component.model.object.IMObject target, String targetName) {
        List<Relationship> relationships = this.getValues(sourceName, Relationship.class, Predicates.targetEquals((org.openvpms.component.model.object.IMObject)target));
        if (!relationships.isEmpty()) {
            IMObjectBean targetBean = this.getBean(target);
            for (Relationship relationship : relationships) {
                this.removeValue(sourceName, (org.openvpms.component.model.object.IMObject)relationship);
                targetBean.removeValue(targetName, (org.openvpms.component.model.object.IMObject)relationship);
            }
        }
    }

    public Relationship addSource(String name, Reference source) {
        String archetype = this.getRelationshipSourceArchetype(name, source);
        return this.addSource(name, archetype, source);
    }

    public Relationship addSource(String name, org.openvpms.component.model.object.IMObject source) {
        return this.addSource(name, source.getObjectReference());
    }

    public Relationship addSource(String name, String archetype, Reference source) {
        return this.addRelationship(name, archetype, source, this.getReference());
    }

    public Relationship addSource(String name, String archetype, org.openvpms.component.model.object.IMObject source) {
        return this.addSource(name, archetype, source.getObjectReference());
    }

    public Relationship addSource(String targetName, org.openvpms.component.model.object.IMObject source, String sourceName) {
        Relationship relationship = this.addSource(targetName, source);
        this.getBean(source).addValue(sourceName, (org.openvpms.component.model.object.IMObject)relationship);
        return relationship;
    }

    public Relationship addSource(String targetName, String archetype, org.openvpms.component.model.object.IMObject source, String sourceName) {
        Relationship relationship = this.addSource(targetName, archetype, source);
        this.getBean(source).addValue(sourceName, (org.openvpms.component.model.object.IMObject)relationship);
        return relationship;
    }

    public RelatedIMObjects<org.openvpms.component.model.object.IMObject, Relationship> getRelated(String name) {
        return this.getRelated(name, org.openvpms.component.model.object.IMObject.class);
    }

    public <T extends org.openvpms.component.model.object.IMObject, R extends Relationship> RelatedIMObjects<T, R> getRelated(String name, Class<T> type) {
        return this.getRelated(name, type, Relationship.class);
    }

    public <T extends org.openvpms.component.model.object.IMObject, R extends Relationship> RelatedIMObjects<T, R> getRelated(String name, Class<T> type, Class<R> relType) {
        List<R> relationships = this.getValues(name, relType);
        return new RelatedIMObjectsImpl<T, R>(this.getObject(), relationships, type, (ArchetypeService)this.service);
    }

    public <R extends Relationship> List<IMObject> getRelated(String name, Policy<R> policy) {
        return this.getRelated(name, IMObject.class, policy);
    }

    public <T extends IMObject, R extends Relationship> List<T> getRelated(String name, Class<T> type, Policy<R> policy) {
        List<T> relationships;
        ArrayList<T> result = new ArrayList<T>();
        IMObjectReference ref = this.getReference();
        java.util.function.Predicate predicate = policy.getPredicate();
        Comparator comparator = policy.getComparator();
        List<T> list = relationships = predicate != null ? this.getValues(name, policy.getType(), predicate) : this.getValues(name, policy.getType());
        if (comparator != null) {
            relationships.sort(comparator);
        }
        Policy.State state = policy.getState();
        for (Relationship relationship : relationships) {
            IMObject related = this.getSourceOrTarget(relationship, ref, state);
            if (related == null) continue;
            result.add(this.cast(related, type));
        }
        return result;
    }

    public void save(org.openvpms.component.model.object.IMObject ... objects) {
        ArrayList<IMObject> toSave = new ArrayList<IMObject>();
        toSave.add(this.getObject());
        for (org.openvpms.component.model.object.IMObject object : objects) {
            toSave.add((IMObject)object);
        }
        this.service.save(toSave);
    }

    public void save(Collection<org.openvpms.component.model.object.IMObject> objects) {
        ArrayList<IMObject> toSave = new ArrayList<IMObject>();
        toSave.add(this.getObject());
        for (org.openvpms.component.model.object.IMObject object : objects) {
            toSave.add((IMObject)object);
        }
        this.service.save(toSave);
    }

    public <T extends org.openvpms.component.model.object.IMObject> List<T> getValues(String name, Class<T> type) {
        List<org.openvpms.component.model.object.IMObject> values = this.getValues(name);
        for (org.openvpms.component.model.object.IMObject value : values) {
            if (type.isInstance(value)) continue;
            throw new IMObjectBeanException(IMObjectBeanException.ErrorCode.InvalidClassCast, type.getName(), value.getClass().getName());
        }
        return values;
    }

    public List<org.openvpms.component.model.object.IMObject> getValues(String name, Predicate predicate) {
        java.util.function.Predicate<org.openvpms.component.model.object.IMObject> evaluate = arg_0 -> ((Predicate)predicate).evaluate(arg_0);
        return this.getValues(name, evaluate);
    }

    public <T extends org.openvpms.component.model.object.IMObject> List<T> getValues(String name, Predicate predicate, Class<T> type) {
        return this.getValues(name, type, arg_0 -> ((Predicate)predicate).evaluate(arg_0));
    }

    public IMObject getValue(String name, Predicate predicate) {
        for (org.openvpms.component.model.object.IMObject object : this.getValues(name)) {
            if (!predicate.evaluate((Object)object)) continue;
            return (IMObject)object;
        }
        return null;
    }

    public <T extends IMObject> T getValue(String name, Predicate predicate, Class<T> type) {
        for (IMObject object : this.getValues(name, type)) {
            if (!predicate.evaluate((Object)object)) continue;
            return (T)object;
        }
        return null;
    }

    public IMObject getNodeSourceObject(String node) {
        return this.getNodeSourceObject(node, true);
    }

    public IMObject getNodeSourceObject(String node, boolean active) {
        return active ? this.getSource(node, Policies.active()) : this.getSource(node);
    }

    public IMObject getNodeSourceObject(String node, Predicate predicate) {
        return this.getNodeSourceObject(node, predicate, true);
    }

    public IMObject getNodeSourceObject(String node, Predicate predicate, boolean active) {
        return this.getSource(node, Policies.match((boolean)active, arg_0 -> ((Predicate)predicate).evaluate(arg_0)));
    }

    public IMObject getNodeTargetObject(String node) {
        return this.getNodeTargetObject(node, true);
    }

    public IMObject getNodeTargetObject(String node, boolean active) {
        return active ? this.getTarget(node, Policies.active()) : this.getTarget(node);
    }

    public IMObject getNodeTargetObject(String node, Predicate predicate) {
        return this.getNodeTargetObject(node, predicate, true);
    }

    public IMObject getNodeTargetObject(String node, Predicate predicate, boolean active) {
        return this.getTarget(node, Policies.match((boolean)active, arg_0 -> ((Predicate)predicate).evaluate(arg_0)));
    }

    public IMObject getNodeSourceObject(String node, Date time) {
        return this.getSource(node, Policies.active((Date)time));
    }

    public IMObject getNodeSourceObject(String node, Date time, boolean active) {
        return this.getSource(node, Policies.active((Date)time, (boolean)active));
    }

    public IMObject getNodeTargetObject(String node, Date time) {
        return this.getTarget(node, Policies.active((Date)time));
    }

    public IMObject getNodeTargetObject(String node, Date time, boolean active) {
        return this.getTarget(node, Policies.active((Date)time, (boolean)active));
    }

    public List<IMObject> getNodeSourceObjects(String node) {
        List<org.openvpms.component.model.object.IMObject> sources = this.getSources(node, Policies.active());
        return sources;
    }

    public <T extends IMObject> List<T> getNodeSourceObjects(String node, Class<T> type) {
        return this.getSources(node, type, Policies.active());
    }

    public List<IMObject> getNodeSourceObjects(String node, Date time) {
        return this.getSources(node, Policies.active((Date)time));
    }

    public <T extends IMObject> List<T> getNodeSourceObjects(String node, Date time, Class<T> type) {
        return this.getSources(node, type, Policies.active((Date)time));
    }

    public List<IMObject> getNodeSourceObjects(String node, Date time, boolean active) {
        return this.getSources(node, Policies.active((Date)time, (boolean)active));
    }

    public <T extends IMObject> List<T> getNodeSourceObjects(String node, Date time, boolean active, Class<T> type) {
        return this.getSources(node, type, Policies.active((Date)time, (boolean)active));
    }

    public List<IMObject> getNodeSourceObjects(String node, Predicate predicate) {
        return this.getNodeSourceObjects(node, predicate, true);
    }

    public List<IMObject> getNodeSourceObjects(String node, Predicate predicate, boolean active) {
        return this.getNodeSourceObjects(node, predicate, active, IMObject.class);
    }

    public <T extends IMObject> List<T> getNodeSourceObjects(String node, Predicate predicate, boolean active, Class<T> type) {
        return this.getSources(node, type, Policies.match((boolean)active, arg_0 -> ((Predicate)predicate).evaluate(arg_0)));
    }

    public <T extends IMObject, R extends Relationship> Map<R, T> getNodeSourceObjects(String node, Class<T> type, Class<R> relationshipType) {
        return this.getNodeSourceObjects(node, type, relationshipType, true);
    }

    public <T extends IMObject, R extends Relationship> Map<R, T> getNodeSourceObjects(String node, Class<T> type, Class<R> relationshipType, boolean active) {
        List<R> relationships = this.getValues(node, relationshipType);
        Policy policy = active ? Policies.active(relationshipType) : Policies.any(relationshipType);
        return this.getRelationshipObjects(relationships, type, policy, true);
    }

    public List<IMObject> getNodeTargetObjects(String node) {
        return this.getTargets(node, Policies.active());
    }

    public <R extends Relationship> List<IMObject> getNodeTargetObjects(String node, Comparator<R> comparator) {
        return this.getNodeTargetObjects(node, IMObject.class, comparator);
    }

    public <T extends IMObject> List<T> getNodeTargetObjects(String node, Class<T> type) {
        return this.getTargets(node, type, Policies.active());
    }

    public <T extends IMObject, R extends Relationship> List<T> getNodeTargetObjects(String node, Class<T> type, Comparator<R> comparator) {
        return this.getNodeTargetObjects(node, IsActiveRelationship.isActiveNow(), true, type, comparator);
    }

    public List<IMObject> getNodeTargetObjects(String node, Date time) {
        return this.getTargets(node, Policies.active((Date)time));
    }

    public <T extends IMObject> List<T> getNodeTargetObjects(String node, Date time, Class<T> type) {
        return this.getNodeTargetObjects(node, time, true, type);
    }

    public List<IMObject> getNodeTargetObjects(String node, Date time, boolean active) {
        return this.getNodeTargetObjects(node, time, active, IMObject.class);
    }

    public <T extends IMObject> List<T> getNodeTargetObjects(String node, Date time, boolean active, Class<T> type) {
        return this.getTargets(node, type, Policies.active((Date)time, (boolean)active));
    }

    public List<IMObject> getNodeTargetObjects(String node, Predicate predicate) {
        return this.getTargets(node, Policies.active(arg_0 -> ((Predicate)predicate).evaluate(arg_0)));
    }

    public <T extends IMObject> List<T> getNodeTargetObjects(String node, Predicate predicate, Class<T> type) {
        return this.getTargets(node, type, Policies.active(arg_0 -> ((Predicate)predicate).evaluate(arg_0)));
    }

    public List<IMObject> getNodeTargetObjects(String node, Predicate predicate, boolean active) {
        return this.getNodeTargetObjects(node, predicate, active, IMObject.class);
    }

    public <T extends IMObject> List<T> getNodeTargetObjects(String node, Predicate predicate, boolean active, Class<T> type) {
        return this.getTargets(node, type, Policies.match((boolean)active, arg_0 -> ((Predicate)predicate).evaluate(arg_0)));
    }

    public <T extends IMObject, R extends Relationship> List<T> getNodeTargetObjects(String node, Predicate predicate, boolean active, Class<T> type, Comparator<R> comparator) {
        Policy policy = Policies.match((boolean)active, arg_0 -> ((Predicate)predicate).evaluate(arg_0), comparator);
        return this.getRelatedObjects(node, type, policy, false);
    }

    public <T extends IMObject, R extends Relationship> Map<R, T> getNodeTargetObjects(String node, Class<T> type, Class<R> relationshipType) {
        return this.getNodeTargetObjects(node, type, relationshipType, true);
    }

    public <T extends IMObject, R extends Relationship> Map<R, T> getNodeTargetObjects(String node, Class<T> type, Class<R> relationshipType, boolean active) {
        List<R> relationships = this.getValues(node, relationshipType);
        Policy policy = active ? Policies.active(relationshipType) : Policies.any(relationshipType);
        return this.getRelationshipObjects(relationships, type, policy, false);
    }

    public IMObjectReference getNodeSourceObjectRef(String node) {
        return this.getNodeSourceObjectRef(node, true);
    }

    public IMObjectReference getNodeSourceObjectRef(String node, boolean active) {
        return (IMObjectReference)this.getSourceRef(node, active ? Policies.active() : Policies.any());
    }

    public List<IMObjectReference> getNodeSourceObjectRefs(String node) {
        return this.getSourceRefs(node, Policies.active());
    }

    public List<IMObjectReference> getNodeSourceObjectRefs(String node, Date time) {
        return this.getSourceRefs(node, Policies.active((Date)time));
    }

    public List<IMObjectReference> getNodeSourceObjectRefs(String node, Predicate predicate) {
        return this.getSourceRefs(node, Policies.any(arg_0 -> ((Predicate)predicate).evaluate(arg_0)));
    }

    public List<IMObjectReference> getNodeTargetObjectRefs(String node) {
        return this.getTargetRefs(node, Policies.active());
    }

    public IMObjectReference getNodeTargetObjectRef(String node) {
        return this.getTargetRef(node, Policies.active());
    }

    public IMObjectReference getNodeTargetObjectRef(String node, boolean active) {
        return this.getTargetRef(node, active ? Policies.active() : Policies.any());
    }

    public List<IMObjectReference> getNodeTargetObjectRefs(String node, Date time) {
        return this.getTargetRefs(node, Policies.active((Date)time));
    }

    public List<IMObjectReference> getNodeTargetObjectRefs(String node, Predicate predicate) {
        return this.getTargetRefs(node, Policies.any(arg_0 -> ((Predicate)predicate).evaluate(arg_0)));
    }

    public <T extends IMObject, R extends Relationship> List<T> getSourceObjects(Collection<R> relationships, String shortName, Class<T> type) {
        return this.getSourceObjects(relationships, new String[]{shortName}, type);
    }

    public <T extends IMObject, R extends Relationship> List<T> getSourceObjects(Collection<R> relationships, String[] shortNames, Class<T> type) {
        return this.getSourceObjects(relationships, shortNames, true, type);
    }

    public <T extends IMObject, R extends Relationship> List<T> getSourceObjects(Collection<R> relationships, String[] shortNames, boolean active, Class<T> type) {
        Policy match = Policies.match((boolean)active, this.getActiveIsA(active, shortNames));
        List<Object> list = relationships instanceof List ? (List<Object>)relationships : new ArrayList<R>(relationships);
        return this.getRelatedObjects(list, type, match, true);
    }

    public <T extends IMObject, R extends Relationship> List<T> getTargetObjects(Collection<R> relationships, String shortName, Class<T> type) {
        return this.getTargetObjects(relationships, new String[]{shortName}, type);
    }

    public <T extends IMObject, R extends Relationship> List<T> getTargetObjects(Collection<R> relationships, String[] shortNames, Class<T> type) {
        return this.getTargetObjects(relationships, shortNames, true, type);
    }

    public <T extends IMObject, R extends Relationship> List<T> getTargetObjects(Collection<R> relationships, String[] shortNames, boolean active, Class<T> type) {
        Policy policy = Policies.match((boolean)active, this.getActiveIsA(active, shortNames));
        List<Object> list = relationships instanceof List ? (List<Object>)relationships : new ArrayList<R>(relationships);
        return this.getRelatedObjects(list, type, policy, false);
    }

    public <R extends Relationship> IMObject getSourceObject(Collection<R> relationships, String shortName) {
        return this.getSourceObject(relationships, new String[]{shortName});
    }

    public <R extends Relationship> IMObject getSourceObject(Collection<R> relationships, String shortName, boolean active) {
        return this.getSourceObject(relationships, new String[]{shortName}, active);
    }

    public <R extends Relationship> IMObject getSourceObject(Collection<R> relationships, String[] shortNames) {
        return this.getSourceObject(relationships, shortNames, true);
    }

    public <R extends Relationship> IMObject getSourceObject(Collection<R> relationships, String[] shortNames, boolean active) {
        Policy policy = Policies.match((boolean)active, this.getActiveIsA(active, shortNames));
        List<Object> list = relationships instanceof List ? (List<Object>)relationships : new ArrayList<R>(relationships);
        return this.getRelatedObject((Collection<? extends org.openvpms.component.model.object.IMObject>)list, policy, true);
    }

    public <R extends Relationship> IMObject getTargetObject(Collection<R> relationships, String shortName) {
        return this.getTargetObject(relationships, new String[]{shortName});
    }

    public <R extends Relationship> IMObject getTargetObject(Collection<R> relationships, String shortName, boolean active) {
        return this.getTargetObject(relationships, new String[]{shortName}, active);
    }

    public <R extends Relationship> IMObject getTargetObject(Collection<R> relationships, String[] shortNames) {
        return this.getTargetObject(relationships, shortNames, true);
    }

    public <R extends Relationship> IMObject getTargetObject(Collection<R> relationships, String[] shortNames, boolean active) {
        Policy policy = Policies.match((boolean)active, this.getActiveIsA(active, shortNames));
        List<Object> list = relationships instanceof List ? (List<Object>)relationships : new ArrayList<R>(relationships);
        return this.getRelatedObject((Collection<? extends org.openvpms.component.model.object.IMObject>)list, policy, false);
    }

    public <R extends PeriodRelationship> IMObject getSourceObject(Collection<R> relationships, String shortName, Date time) {
        return this.getSourceObject(relationships, shortName, time, true);
    }

    public <R extends PeriodRelationship> IMObject getSourceObject(Collection<R> relationships, String shortName, Date time, boolean active) {
        return this.getSourceObject(relationships, new String[]{shortName}, time, active);
    }

    public <R extends PeriodRelationship> IMObject getSourceObject(Collection<R> relationships, String[] shortNames, Date time) {
        return this.getSourceObject(relationships, shortNames, time, true);
    }

    public <R extends PeriodRelationship> IMObject getSourceObject(Collection<R> relationships, String[] shortNames, Date time, boolean active) {
        Policy policy = Policies.match((boolean)active, this.getIsActiveRelationship(time, shortNames));
        List<Object> list = relationships instanceof List ? (List<Object>)relationships : new ArrayList<R>(relationships);
        return this.getRelatedObject((Collection<? extends org.openvpms.component.model.object.IMObject>)list, policy, true);
    }

    public <R extends PeriodRelationship> IMObject getTargetObject(Collection<R> relationships, String shortName, Date time) {
        return this.getTargetObject(relationships, shortName, time, true);
    }

    public <R extends PeriodRelationship> IMObject getTargetObject(Collection<R> relationships, String shortName, Date time, boolean active) {
        return this.getTargetObject(relationships, new String[]{shortName}, time, active);
    }

    public <R extends PeriodRelationship> IMObject getTargetObject(Collection<R> relationships, String[] shortNames, Date time) {
        return this.getTargetObject(relationships, shortNames, time, true);
    }

    public <R extends PeriodRelationship> IMObject getTargetObject(Collection<R> relationships, String[] shortNames, Date time, boolean active) {
        Policy policy = Policies.match((boolean)active, this.getIsActiveRelationship(time, shortNames));
        List<Object> list = relationships instanceof List ? (List<Object>)relationships : new ArrayList<R>(relationships);
        return this.getRelatedObject((Collection<? extends org.openvpms.component.model.object.IMObject>)list, policy, false);
    }

    public <R extends Relationship> IMObjectReference getSourceObjectRef(Collection<R> relationships, String shortName) {
        return this.getSourceObjectRef(relationships, shortName, true);
    }

    public <R extends Relationship> IMObjectReference getSourceObjectRef(Collection<R> relationships, String shortName, boolean active) {
        return this.getSourceObjectRef(relationships, new String[]{shortName}, active);
    }

    public <R extends Relationship> IMObjectReference getSourceObjectRef(Collection<R> relationships, String[] shortNames, boolean active) {
        return this.getObjectRef(relationships, shortNames, active, true);
    }

    public <R extends Relationship> IMObjectReference getTargetObjectRef(Collection<R> relationships, String shortName) {
        return this.getTargetObjectRef(relationships, shortName, true);
    }

    public <R extends Relationship> IMObjectReference getTargetObjectRef(Collection<R> relationships, String shortName, boolean active) {
        return this.getTargetObjectRef(relationships, new String[]{shortName}, active);
    }

    public <R extends Relationship> IMObjectReference getTargetObjectRef(Collection<R> relationships, String[] shortNames, boolean active) {
        return this.getObjectRef(relationships, shortNames, active, false);
    }

    public boolean hasNodeTarget(String node, IMObject object) {
        return this.getNodeTargetObjectRefs(node).contains(object.getObjectReference());
    }

    public boolean hasNodeTarget(String node, IMObject object, Date time) {
        return this.getNodeTargetObjectRefs(node, time).contains(object.getObjectReference());
    }

    public boolean hasNodeSource(String node, IMObject object) {
        return this.getNodeSourceObjectRefs(node).contains(object.getObjectReference());
    }

    public void setValue(String name, Object value) {
        this.properties.set(name, value);
    }

    public void addValue(String name, org.openvpms.component.model.object.IMObject value) {
        NodeDescriptor node = this.toNode(name);
        node.addChildToCollection(this.properties.getObject(), value);
    }

    public void removeValue(String name, org.openvpms.component.model.object.IMObject value) {
        NodeDescriptor node = this.toNode(name);
        node.removeChildFromCollection(this.properties.getObject(), value);
    }

    public IMObjectRelationship addNodeTarget(String name, Reference target) {
        return (IMObjectRelationship)this.addTarget(name, target);
    }

    public IMObjectRelationship addNodeTarget(String name, IMObject target) {
        return (IMObjectRelationship)this.addTarget(name, target);
    }

    public IMObjectRelationship addNodeTarget(String name, String shortName, IMObject target) {
        return (IMObjectRelationship)this.addTarget(name, shortName, target);
    }

    public IMObjectRelationship addNodeTarget(String name, String shortName, Reference target) {
        return (IMObjectRelationship)this.addTarget(name, shortName, target);
    }

    public Object getDefaultValue(String name) {
        Object result = null;
        NodeDescriptor node = this.toNode(name);
        String expression = node.getDefaultValue();
        if (!StringUtils.isEmpty((CharSequence)expression)) {
            result = this.evaluate(expression);
        }
        return result;
    }

    public boolean isDefaultValue(String name) {
        boolean result = false;
        NodeDescriptor node = this.toNode(name);
        String expression = node.getDefaultValue();
        if (!StringUtils.isEmpty((CharSequence)expression)) {
            Object value = this.evaluate(expression);
            result = Objects.equals(this.getValue(name), value);
        }
        return result;
    }

    public void deriveValues() {
        this.getArchetypeService().deriveValues(this.getObject());
    }

    public void save() {
        IMObject object = this.getObject();
        IArchetypeService service = this.getArchetypeService();
        service.deriveValues(object);
        service.save(object);
    }

    public org.openvpms.component.model.object.IMObject getObject(Reference reference) {
        return this.service.get(reference);
    }

    public <T extends org.openvpms.component.model.object.IMObject> T getObject(Reference reference, Class<T> type) {
        return this.cast(this.getObject(reference), type);
    }

    public org.openvpms.component.model.object.IMObject getObject(Reference reference, boolean active) {
        return this.service.get(reference, active);
    }

    public <T extends org.openvpms.component.model.object.IMObject> T getObject(Reference reference, Class<T> type, boolean active) {
        return this.cast(this.getObject(reference, active), type);
    }

    public IMObjectBean getBean(org.openvpms.component.model.object.IMObject object) {
        return new IMObjectBean(object, this.service, this.lookups);
    }

    public org.openvpms.component.model.bean.IMObjectBean getBean(Reference reference) {
        org.openvpms.component.model.object.IMObject object = this.getObject(reference);
        return object != null ? this.getBean(object) : null;
    }

    public org.openvpms.component.model.bean.IMObjectBean getBean(Reference reference, boolean active) {
        org.openvpms.component.model.object.IMObject object = this.getObject(reference, active);
        return object != null ? this.getBean(object) : null;
    }

    protected <T extends org.openvpms.component.model.object.IMObject> T resolve(Reference ref, Class<T> type, Policy.State state) {
        IMObject object = this.resolve(ref, state);
        if (object != null && !type.isInstance(object)) {
            throw new IMObjectBeanException(IMObjectBeanException.ErrorCode.InvalidClassCast, type.getName(), object.getClass().getName());
        }
        return (T)object;
    }

    protected IMObject resolve(Reference ref, Policy.State state) {
        IMObject result = null;
        if (ref != null) {
            IArchetypeService service = this.getArchetypeService();
            if (state == Policy.State.ANY) {
                result = service.get(ref);
            } else {
                boolean active = state == Policy.State.ACTIVE;
                result = service.get(ref, active);
            }
        }
        return result;
    }

    protected IArchetypeService getArchetypeService() {
        if (this.service == null) {
            this.service = ArchetypeServiceHelper.getArchetypeService();
        }
        return this.service;
    }

    protected LookupService getLookups() {
        if (this.lookups == null) {
            this.lookups = LookupServiceHelper.getLookupService();
        }
        return this.lookups;
    }

    protected <T extends org.openvpms.component.model.object.IMObject, R extends Relationship> List<T> getRelatedObjects(String node, Class<T> type, Policy<R> policy, boolean source) {
        List<Reference> refs = this.getRelatedRefs(node, policy, source);
        return this.resolve(refs, type, policy.getState());
    }

    protected <R extends Relationship, T extends IMObject> Map<R, T> getRelationshipObjects(Collection<R> relationships, Class<T> type, Policy<R> policy, boolean source) {
        Map<R, IMObject> result;
        Map<R, Reference> refs = this.getRelationshipRefs(relationships, policy, source);
        if (refs.isEmpty()) {
            result = Collections.emptyMap();
        } else {
            result = new HashMap();
            Policy.State state = policy.getState();
            for (Map.Entry<R, Reference> entry : refs.entrySet()) {
                IMObject object = (IMObject)this.resolve(entry.getValue(), type, state);
                if (object == null) continue;
                result.put(entry.getKey(), object);
            }
        }
        return result;
    }

    protected <R extends Relationship> Map<R, Reference> getRelationshipRefs(Collection<R> relationships, Policy<R> policy, boolean source) {
        HashMap<Relationship, Reference> result = new HashMap<Relationship, Reference>();
        Function<R, Reference> accessor = this.getAccessor(source);
        java.util.function.Predicate predicate = policy.getPredicate();
        for (Relationship relationship : relationships) {
            Reference ref;
            if (predicate != null && !predicate.test(relationship) || (ref = accessor.apply(relationship)) == null) continue;
            result.put(relationship, ref);
        }
        return result;
    }

    protected <R extends Relationship> IMObject getRelatedObject(String node, Policy<R> policy, boolean source) {
        List<org.openvpms.component.model.object.IMObject> relationships = this.getValues(node);
        if (policy.getComparator() != null) {
            relationships.sort(policy.getComparator());
        }
        return this.getRelatedObject(relationships, policy, source);
    }

    protected <R extends Relationship> IMObject getRelatedObject(Collection<? extends org.openvpms.component.model.object.IMObject> relationships, Policy<R> policy, boolean source) {
        IMObject result = null;
        Function<R, Reference> accessor = this.getAccessor(source);
        Class type = policy.getType();
        java.util.function.Predicate predicate = policy.getPredicate();
        Policy.State state = policy.getState();
        for (org.openvpms.component.model.object.IMObject iMObject : relationships) {
            Reference ref;
            IMObject object;
            Relationship relationship = (Relationship)this.cast(iMObject, type);
            if (predicate != null && !predicate.test(relationship) || (object = this.resolve(ref = accessor.apply(relationship), state)) == null) continue;
            if (object.isActive() || state == Policy.State.INACTIVE) {
                result = object;
                break;
            }
            if (result != null) continue;
            result = object;
        }
        return result;
    }

    protected <R extends Relationship> IMObjectReference getRelatedRef(String name, Policy<R> policy, boolean source) {
        Function<R, Reference> accessor = this.getAccessor(source);
        java.util.function.Predicate predicate = policy.getPredicate();
        Class type = policy.getType();
        for (org.openvpms.component.model.object.IMObject object : this.getValues(name)) {
            Reference reference;
            Relationship relationship = (Relationship)this.cast(object, type);
            if (predicate != null && !predicate.test(relationship) || (reference = accessor.apply(relationship)) == null) continue;
            return (IMObjectReference)reference;
        }
        return null;
    }

    protected <R extends Relationship> List<Reference> getRelatedRefs(String node, Policy<R> policy, boolean source) {
        List relationships = this.getValues(node, policy.getType());
        Comparator comparator = policy.getComparator();
        if (comparator != null) {
            relationships.sort(comparator);
        }
        return this.getRelatedRefs(relationships, policy, source);
    }

    protected <R extends Relationship> List<Reference> getRelatedRefs(Collection<R> relationships, Policy<R> policy, boolean source) {
        Function accessor = this.getAccessor(source);
        ArrayList<Reference> result = new ArrayList<Reference>();
        Stream<R> stream = relationships.stream();
        java.util.function.Predicate predicate = policy.getPredicate();
        if (predicate != null) {
            stream = stream.filter(predicate);
        }
        stream.forEach(r -> {
            Reference reference = (Reference)accessor.apply(r);
            if (reference != null) {
                result.add(reference);
            }
        });
        return result;
    }

    protected <R extends Relationship, T extends IMObject> List<T> getRelatedObjects(Collection<R> relationships, Class<T> type, Policy<R> policy, boolean source) {
        List<Reference> refs = this.getRelatedRefs(relationships, policy, source);
        return this.resolve(refs, type, policy.getState());
    }

    protected <T extends org.openvpms.component.model.object.IMObject> List<T> resolve(List<Reference> refs, Class<T> type, Policy.State state) {
        List result;
        if (refs.isEmpty()) {
            result = Collections.emptyList();
        } else {
            result = new ArrayList();
            for (Reference ref : refs) {
                T object = this.resolve(ref, type, state);
                if (object == null) continue;
                result.add(object);
            }
        }
        return result;
    }

    protected IMObject getSourceOrTarget(Relationship relationship, Reference ref, Policy.State state) {
        Reference target = relationship.getTarget();
        Reference related = null;
        if (target != null && !target.equals((Object)ref)) {
            related = target;
        } else {
            Reference source = relationship.getSource();
            if (source != null && !source.equals((Object)ref)) {
                related = source;
            }
        }
        return related != null ? this.resolve(related, state) : null;
    }

    protected String getRelationshipTargetArchetype(String name, IMObject target) {
        return this.getRelationshipTargetArchetype(name, target.getObjectReference());
    }

    protected String getRelationshipTargetArchetype(String name, Reference target) {
        String[] range = this.getArchetypeRange(name);
        IArchetypeService service = this.getArchetypeService();
        String result = null;
        String archetype = target.getArchetype();
        for (String shortName : range) {
            NodeDescriptor node;
            String targetName = TypeHelper.matches(shortName, "participation.*") ? "entity" : "target";
            ArchetypeDescriptor descriptor = service.getArchetypeDescriptor(shortName);
            if (descriptor == null || (node = descriptor.getNodeDescriptor(targetName)) == null || !this.isA(node, archetype)) continue;
            if (result != null) {
                throw new IMObjectBeanException(IMObjectBeanException.ErrorCode.MultipleRelationshipsForTarget, archetype, name, this.getObject().getArchetype());
            }
            result = shortName;
        }
        if (result == null) {
            throw new IMObjectBeanException(IMObjectBeanException.ErrorCode.CannotAddTargetToNode, archetype, name, this.getObject().getArchetype());
        }
        return result;
    }

    protected String getRelationshipSourceArchetype(String name, Reference source) {
        String[] range = this.getArchetypeRange(name);
        IArchetypeService service = this.getArchetypeService();
        String result = null;
        String archetype = source.getArchetype();
        for (String shortName : range) {
            NodeDescriptor node;
            ArchetypeDescriptor descriptor = service.getArchetypeDescriptor(shortName);
            if (descriptor == null || (node = descriptor.getNodeDescriptor("source")) == null || !this.isA(node, archetype)) continue;
            if (result != null) {
                throw new IMObjectBeanException(IMObjectBeanException.ErrorCode.MultipleRelationshipsForSource, archetype, name, this.getObject().getArchetype());
            }
            result = shortName;
        }
        if (result == null) {
            throw new IMObjectBeanException(IMObjectBeanException.ErrorCode.CannotAddSourceToNode, archetype, name, this.getObject().getArchetype());
        }
        return result;
    }

    protected <R extends Relationship> IMObjectReference getRelatedRef(Collection<R> relationships, java.util.function.Predicate<R> predicate, boolean source) {
        Function<R, Reference> accessor = this.getAccessor(source);
        for (Relationship relationship : relationships) {
            IMObjectReference reference;
            if (predicate != null && !predicate.test(relationship) || (reference = (IMObjectReference)accessor.apply(relationship)) == null) continue;
            return reference;
        }
        return null;
    }

    protected <R extends Relationship> IMObjectReference getObjectRef(Collection<R> relationships, String[] shortNames, boolean active, boolean source) {
        java.util.function.Predicate<Relationship> predicate = this.getActiveIsA(shortNames);
        IMObjectReference ref = this.getRelatedRef(relationships, predicate, source);
        if (ref == null && !active) {
            ref = this.getRelatedRef(relationships, Predicates.isA((String[])shortNames), source);
        }
        return ref;
    }

    protected <T> List<T> select(Collection<T> objects, java.util.function.Predicate<T> predicate) {
        ArrayList<T> result = new ArrayList<T>();
        for (T object : objects) {
            if (!predicate.test(object)) continue;
            result.add(object);
        }
        return result;
    }

    protected <T> T selectFirst(Collection<T> objects, Predicate predicate) {
        for (T object : objects) {
            if (!predicate.evaluate(object)) continue;
            return object;
        }
        return null;
    }

    protected java.util.function.Predicate<Relationship> getIsActiveRelationship(Date time, String ... shortNames) {
        return Predicates.activeAt((Date)time).and(Predicates.isA((String[])shortNames));
    }

    protected <R extends Relationship> java.util.function.Predicate<R> getActiveIsA(boolean active, String ... shortNames) {
        java.util.function.Predicate isA = Predicates.isA((String[])shortNames);
        return active ? Predicates.activeNow().and(isA) : isA;
    }

    protected java.util.function.Predicate<Relationship> getActiveIsA(String ... shortNames) {
        return Predicates.activeNow().and(Predicates.isA((String[])shortNames));
    }

    protected NodeDescriptor toNode(String name) {
        return this.properties.getNode(name);
    }

    private Relationship addRelationship(String name, String archetype, Reference source, Reference target) {
        Relationship relationship = (Relationship)this.getArchetypeService().create(archetype, Relationship.class);
        relationship.setSource(source);
        relationship.setTarget(target);
        this.addValue(name, (org.openvpms.component.model.object.IMObject)relationship);
        return relationship;
    }

    private Object getValue(NodeDescriptor node) {
        return node.getValue(this.getObject());
    }

    private List<IMObject> getValues(NodeDescriptor node) {
        return node.getChildren(this.getObject());
    }

    private <R extends Relationship> Function<R, Reference> getAccessor(boolean source) {
        return source ? Relationship::getSource : Relationship::getTarget;
    }

    private boolean isA(NodeDescriptor node, String archetype) {
        String[] range = node.getArchetypeRange();
        if (range.length != 0) {
            return TypeHelper.isA(archetype, range);
        }
        return node.getFilter() == null || TypeHelper.isA(archetype, node.getFilter());
    }

    private Object evaluate(String expression) {
        JXPathContext context = JXPathHelper.newContext(this.properties.getObject());
        Object result = context.getValue(expression);
        return result;
    }

    private IMObject cast(org.openvpms.component.model.object.IMObject object) {
        if (object instanceof Beanable) {
            return ((Beanable)object).getObject();
        }
        return (IMObject)object;
    }

    private <T extends org.openvpms.component.model.object.IMObject> T cast(org.openvpms.component.model.object.IMObject object, Class<T> type) {
        if (object != null && !type.isInstance(object)) {
            throw new ClassCastException("Cannot cast " + object.getArchetype() + " from " + object.getClass().getName() + " to " + object.getName());
        }
        return (T)object;
    }

    private class NodePropertySet
    extends AbstractNodePropertySet {
        public NodePropertySet(IMObject object) {
            super(object);
        }

        @Override
        protected IArchetypeService getArchetypeService() {
            return IMObjectBean.this.getArchetypeService();
        }
    }
}

