/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.functor;

import java.util.Date;
import org.apache.commons.collections.Predicate;
import org.openvpms.component.business.domain.im.common.IMObjectRelationship;
import org.openvpms.component.business.domain.im.common.PeriodRelationship;

public abstract class IsActiveRelationship
implements Predicate {
    private static final Predicate ACTIVE_NOW = new IsActive();

    public boolean evaluate(Object object) {
        IMObjectRelationship relationship = (IMObjectRelationship)object;
        return relationship.isActive();
    }

    public static Predicate isActiveNow() {
        return ACTIVE_NOW;
    }

    public static Predicate isActive(Date time) {
        return new IsActive(time);
    }

    public static Predicate isActive(Date from, Date to) {
        return new IsActiveRange(from, to);
    }

    private static class IsActiveRange
    extends IsActiveRelationship {
        private final Date from;
        private final Date to;

        public IsActiveRange(Date from, Date to) {
            this.from = from;
            this.to = to;
        }

        @Override
        public boolean evaluate(Object object) {
            boolean result;
            if (object instanceof PeriodRelationship) {
                PeriodRelationship relationship = (PeriodRelationship)object;
                result = relationship.isActive(this.from, this.to);
            } else {
                result = super.evaluate(object);
            }
            return result;
        }
    }

    private static class IsActive
    extends IsActiveRelationship {
        private final long time;

        public IsActive() {
            this(-1L);
        }

        public IsActive(Date time) {
            this(time.getTime());
        }

        public IsActive(long time) {
            this.time = time;
        }

        @Override
        public boolean evaluate(Object object) {
            boolean result;
            if (object instanceof PeriodRelationship) {
                PeriodRelationship relationship = (PeriodRelationship)object;
                result = this.time == -1L ? relationship.isActive() : relationship.isActive(this.time);
            } else {
                result = super.evaluate(object);
            }
            return result;
        }
    }
}

