/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype;

import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.ReadOnlyArchetypeService;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.cache.IMObjectCache;
import org.openvpms.component.system.common.cache.LRUIMObjectCache;

public class CachingReadOnlyArchetypeService
extends ReadOnlyArchetypeService {
    private final IMObjectCache cache;

    public CachingReadOnlyArchetypeService(int maxSize, IArchetypeService service) {
        this(new LRUIMObjectCache(maxSize, (ArchetypeService)service), service);
    }

    public CachingReadOnlyArchetypeService(IMObjectCache cache, IArchetypeService service) {
        super(service);
        this.cache = cache;
    }

    @Override
    public IMObject get(Reference reference) {
        return (IMObject)this.cache.get(reference);
    }

    @Override
    public IMObject get(Reference reference, boolean active) {
        IMObject result = null;
        if (!active) {
            result = this.get(reference);
        } else {
            IMObject cached = (IMObject)this.cache.getCached(reference);
            if (cached != null) {
                if (cached.isActive()) {
                    result = cached;
                }
            } else {
                IMObject object = super.get(reference, true);
                if (object != null) {
                    this.cache.add(object);
                    result = object;
                }
            }
        }
        return result;
    }

    @Override
    public <T extends org.openvpms.component.model.object.IMObject> T get(Reference reference, Class<T> type) {
        return (T)((org.openvpms.component.model.object.IMObject)type.cast(this.get(reference)));
    }

    @Override
    public org.openvpms.component.model.object.IMObject get(String archetype, long id) {
        return this.get(new IMObjectReference(archetype, id));
    }

    @Override
    public org.openvpms.component.model.object.IMObject get(String archetype, long id, boolean active) {
        return this.get((Reference)new IMObjectReference(archetype, id), active);
    }

    @Override
    public <T extends org.openvpms.component.model.object.IMObject> T get(String archetype, long id, Class<T> type) {
        return (T)((org.openvpms.component.model.object.IMObject)type.cast(this.get(archetype, id)));
    }

    public void clear() {
        this.cache.clear();
    }
}

