/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype;

import java.util.ArrayList;
import java.util.List;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.helper.IMObjectBean;
import org.openvpms.component.business.service.archetype.helper.LookupHelper;
import org.openvpms.component.business.service.archetype.helper.NodeResolver;
import org.openvpms.component.business.service.archetype.helper.PropertyResolverException;
import org.openvpms.component.business.service.archetype.helper.PropertySetResolver;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.business.service.archetype.helper.lookup.LookupAssertion;
import org.openvpms.component.business.service.archetype.helper.lookup.LookupAssertionFactory;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.jxpath.FunctionHelper;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.component.system.common.util.PropertyState;

public class ArchetypeServiceFunctions {
    private final IArchetypeService service;
    private final LookupService lookups;

    public ArchetypeServiceFunctions(IArchetypeService service, LookupService lookups) {
        this.service = service;
        this.lookups = lookups;
    }

    public List<IMObject> resolveRefs(List<IMObjectReference> references) {
        ArrayList<IMObject> objects = new ArrayList<IMObject>();
        for (IMObjectReference ref : references) {
            objects.add(this.service.get(ref));
        }
        return objects;
    }

    public IMObject resolve(IMObjectReference reference) {
        return this.service.get(reference);
    }

    public Object get(Object object, String name) {
        Object result = (object = FunctionHelper.unwrap(object)) == null ? null : (object instanceof IMObject ? this.getNode((IMObject)object, name) : this.getProperty((PropertySet)object, name));
        return result;
    }

    public Object get(Object object, String name, Object defaultValue) {
        Object result = (object = FunctionHelper.unwrap(object)) == null ? defaultValue : (object instanceof IMObject ? this.getNode((IMObject)object, name, defaultValue) : this.getProperty((PropertySet)object, name, defaultValue));
        return result;
    }

    public void set(IMObject object, String node, Object value) {
        IMObjectBean bean = new IMObjectBean(object, this.service);
        bean.setValue(node, value);
        bean.save();
    }

    public String lookup(IMObject object, String node) {
        if (object == null) {
            return null;
        }
        return LookupHelper.getName((ArchetypeService)this.service, this.lookups, object, node);
    }

    public String lookup(IMObject object, String node, String defaultValue) {
        String result = null;
        if (object != null) {
            try {
                result = this.lookup(object, node);
            }
            catch (PropertyResolverException propertyResolverException) {
                // empty catch block
            }
        }
        return result != null ? result : defaultValue;
    }

    public Object defaultLookup(IMObject object, String node) {
        Lookup lookup = null;
        if (object != null) {
            NodeResolver resolver = new NodeResolver(object, this.service, this.lookups);
            PropertyState state = resolver.resolve(node);
            NodeDescriptor descriptor = state.getNode();
            if (descriptor == null) {
                throw new PropertyResolverException(PropertyResolverException.ErrorCode.InvalidProperty, node);
            }
            if (descriptor.isLookup()) {
                LookupAssertion assertion = LookupAssertionFactory.create(descriptor, this.service, this.lookups);
                lookup = assertion.getDefault();
            } else {
                String shortName;
                String[] shortNames = DescriptorHelper.getShortNames(descriptor, (ArchetypeService)this.service);
                if (!TypeHelper.matches(shortNames, "lookup.*")) {
                    throw new PropertyResolverException(PropertyResolverException.ErrorCode.InvalidProperty, node);
                }
                String[] stringArray = shortNames;
                int n = stringArray.length;
                for (int i = 0; i < n && (lookup = this.lookups.getDefaultLookup(shortName = stringArray[i])) == null; ++i) {
                }
            }
        }
        return lookup;
    }

    private Object getNode(IMObject object, String node) {
        NodeResolver resolver = new NodeResolver(object, this.service, this.lookups);
        return resolver.getObject(node);
    }

    private Object getNode(IMObject object, String node, Object defaultValue) {
        try {
            return this.getNode(object, node);
        }
        catch (PropertyResolverException exception) {
            return defaultValue;
        }
    }

    private Object getProperty(PropertySet set, String property) {
        PropertySetResolver resolver = new PropertySetResolver(set, this.service, this.lookups);
        return resolver.getObject(property);
    }

    private Object getProperty(PropertySet set, String property, Object defaultValue) {
        try {
            return this.getProperty(set, property);
        }
        catch (PropertyResolverException exception) {
            return defaultValue;
        }
    }
}

