/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.dao.hibernate.im.common.CompoundAssembler;
import org.openvpms.component.business.dao.hibernate.im.common.PeriodRelationshipDO;
import org.openvpms.component.business.dao.hibernate.im.entity.SequencedRelationshipDO;
import org.openvpms.component.business.dao.hibernate.im.query.QueryBuilderException;
import org.openvpms.component.business.dao.hibernate.im.query.QueryContext;
import org.openvpms.component.business.dao.hibernate.im.query.TypeSet;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.service.archetype.descriptor.cache.IArchetypeDescriptorCache;
import org.openvpms.component.model.archetype.ArchetypeDescriptor;
import org.openvpms.component.model.archetype.NodeDescriptor;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.query.AndConstraint;
import org.openvpms.component.system.common.query.ArchetypeConstraint;
import org.openvpms.component.system.common.query.ArchetypeIdConstraint;
import org.openvpms.component.system.common.query.ArchetypeNodeConstraint;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.ArchetypeSortConstraint;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.CollectionNodeConstraint;
import org.openvpms.component.system.common.query.ExistsConstraint;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IdConstraint;
import org.openvpms.component.system.common.query.IsAConstraint;
import org.openvpms.component.system.common.query.NodeConstraint;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.NotConstraint;
import org.openvpms.component.system.common.query.ObjectRefConstraint;
import org.openvpms.component.system.common.query.ObjectRefNodeConstraint;
import org.openvpms.component.system.common.query.ObjectRefSelectConstraint;
import org.openvpms.component.system.common.query.OrConstraint;
import org.openvpms.component.system.common.query.ParticipationConstraint;
import org.openvpms.component.system.common.query.RelationalOp;
import org.openvpms.component.system.common.query.SelectConstraint;
import org.openvpms.component.system.common.query.ShortNameConstraint;
import org.openvpms.component.system.common.util.ClassHelper;

public class QueryBuilder {
    private final IArchetypeDescriptorCache cache;
    private final CompoundAssembler assembler;
    private static final String ARCHETYPE_ID_SHORT_NAME = "archetypeId.shortName";

    public QueryBuilder(IArchetypeDescriptorCache cache, CompoundAssembler assembler) {
        this.cache = cache;
        this.assembler = assembler;
    }

    public QueryContext build(ArchetypeQuery query) {
        return this.process(query, null);
    }

    private QueryContext process(ArchetypeQuery query, QueryContext parent) {
        if (query == null || query.getArchetypeConstraint() == null) {
            throw new QueryBuilderException(QueryBuilderException.ErrorCode.NullQuery);
        }
        QueryContext context = new QueryContext(query.isDistinct(), parent);
        this.processConstraint(query.getArchetypeConstraint(), context);
        for (SelectConstraint constraint : context.getSelectConstraints()) {
            this.process(constraint, context);
        }
        return context;
    }

    private void process(SelectConstraint constraint, QueryContext context) {
        if (StringUtils.isEmpty((CharSequence)constraint.getNodeName()) && StringUtils.isEmpty((CharSequence)constraint.getAlias())) {
            throw new QueryBuilderException(QueryBuilderException.ErrorCode.InvalidQualifiedName, constraint.getName());
        }
        TypeSet types = constraint.getAlias() != null ? context.getTypeSet(constraint.getAlias()) : context.getPrimarySet();
        if (types == null) {
            throw new QueryBuilderException(QueryBuilderException.ErrorCode.InvalidQualifiedName, constraint.getName());
        }
        String property = null;
        if (constraint.getNodeName() != null) {
            NodeDescriptor ndesc = this.getMatchingNodeDescriptor(types.getDescriptors(), constraint.getNodeName());
            if (ndesc == null) {
                throw new QueryBuilderException(QueryBuilderException.ErrorCode.NoNodeDescriptorForName, constraint.getNodeName());
            }
            property = this.getProperty(ndesc);
        }
        if (constraint instanceof ObjectRefSelectConstraint) {
            context.addObjectRefSelectConstraint(types.getAlias(), constraint.getNodeName());
        } else {
            context.addSelectConstraint(types.getAlias(), constraint.getNodeName(), property);
        }
    }

    private void process(ArchetypeIdConstraint constraint, QueryContext context) {
        boolean popJoin = context.pushTypeSet(this.getTypeSet(constraint));
        this.processArchetypeConstraint(constraint, context);
        context.popTypeSet(popJoin);
    }

    private void processArchetypeConstraint(ArchetypeIdConstraint constraint, QueryContext context) {
        ArchetypeId id = constraint.getArchetypeId();
        String alias = constraint.getAlias();
        context.pushLogicalOperator(QueryContext.LogicalOperator.AND);
        context.addConstraint(alias, ARCHETYPE_ID_SHORT_NAME, RelationalOp.EQ, id.getShortName());
        this.addActiveConstraint(constraint, context);
        for (IConstraint oc : constraint.getConstraints()) {
            this.processConstraint(oc, context);
        }
        context.popLogicalOperator();
    }

    private void process(ShortNameConstraint constraint, QueryContext context) {
        if (constraint.getShortNames() == null || constraint.getShortNames().length == 0) {
            throw new QueryBuilderException(QueryBuilderException.ErrorCode.NoShortNamesSpecified);
        }
        boolean popJoin = context.pushTypeSet(this.getTypeSet(constraint));
        this.processArchetypeConstraint(constraint, context);
        context.popTypeSet(popJoin);
    }

    private void processArchetypeConstraint(ShortNameConstraint constraint, QueryContext context) {
        boolean and = false;
        if (constraint.getState() != BaseArchetypeConstraint.State.BOTH || !constraint.getConstraints().isEmpty()) {
            context.pushLogicalOperator(QueryContext.LogicalOperator.AND);
            and = true;
        }
        String alias = constraint.getAlias();
        String[] shortNames = constraint.getShortNames();
        boolean or = false;
        if (shortNames.length > 1) {
            context.pushLogicalOperator(QueryContext.LogicalOperator.OR);
            or = true;
        }
        for (String shortName : shortNames) {
            String value = shortName.replace('*', '%');
            context.addConstraint(alias, ARCHETYPE_ID_SHORT_NAME, RelationalOp.EQ, value);
        }
        if (or) {
            context.popLogicalOperator();
        }
        this.addActiveConstraint(constraint, context);
        for (IConstraint oc : constraint.getConstraints()) {
            this.processConstraint(oc, context);
        }
        if (and) {
            context.popLogicalOperator();
        }
    }

    private void addActiveConstraint(BaseArchetypeConstraint constraint, QueryContext context) {
        if (constraint.getState() != BaseArchetypeConstraint.State.BOTH) {
            String alias = constraint.getAlias();
            TypeSet set = context.getTypeSet(alias);
            boolean add = true;
            if (set != null) {
                try {
                    Class<?> type = ClassHelper.getClass(set.getClassName());
                    if (PeriodRelationshipDO.class.isAssignableFrom(type) || SequencedRelationshipDO.class.isAssignableFrom(type)) {
                        add = false;
                    }
                }
                catch (ClassNotFoundException type) {
                    // empty catch block
                }
            }
            if (add) {
                boolean active = constraint.getState() == BaseArchetypeConstraint.State.ACTIVE;
                context.addConstraint(alias, "active", RelationalOp.EQ, active);
            }
        }
    }

    private void processArchetypeConstraint(ArchetypeConstraint constraint, QueryContext context) {
        boolean and = false;
        if (constraint.getState() != BaseArchetypeConstraint.State.BOTH && !constraint.getConstraints().isEmpty()) {
            context.pushLogicalOperator(QueryContext.LogicalOperator.AND);
            and = true;
        }
        this.addActiveConstraint(constraint, context);
        for (IConstraint oc : constraint.getConstraints()) {
            this.processConstraint(oc, context);
        }
        if (and) {
            context.popLogicalOperator();
        }
    }

    private void process(OrConstraint constraint, QueryContext context) {
        context.pushLogicalOperator(QueryContext.LogicalOperator.OR);
        for (IConstraint oc : constraint.getConstraints()) {
            this.processConstraint(oc, context);
        }
        context.popLogicalOperator();
    }

    private void process(AndConstraint constraint, QueryContext context) {
        context.pushLogicalOperator(QueryContext.LogicalOperator.AND);
        for (IConstraint oc : constraint.getConstraints()) {
            this.processConstraint(oc, context);
        }
        context.popLogicalOperator();
    }

    private void process(NodeConstraint constraint, QueryContext context) {
        String property = this.getQualifiedPropertyName(constraint.getNodeName(), constraint.getAlias(), context);
        context.addNodeConstraint(property, constraint);
    }

    private void process(ArchetypeNodeConstraint constraint, QueryContext context) {
        context.addConstraint(null, ARCHETYPE_ID_SHORT_NAME, constraint.getOperator(), constraint.getParameter());
    }

    private void process(ObjectRefNodeConstraint constraint, QueryContext context) {
        RelationalOp op = constraint.getOperator();
        String property = this.getQualifiedPropertyName(constraint.getNodeName(), constraint.getAlias(), context);
        if (constraint.getObjectReference() != null) {
            Reference ref = constraint.getObjectReference();
            context.addConstraint(property + ".id", op, ref.getId());
        } else {
            ArchetypeId id = constraint.getArchetypeId();
            context.addConstraint(property + ".archetypeId.shortName", op, id.getShortName());
        }
    }

    private void process(IdConstraint constraint, QueryContext context) {
        String source = this.getAliasOrQualifiedName(constraint.getSourceName(), context);
        String target = this.getAliasOrQualifiedName(constraint.getTargetName(), context);
        context.addPropertyConstraint(source + ".id", constraint.getOperator(), target + ".id");
    }

    private void process(ObjectRefConstraint constraint, QueryContext context) {
        if (constraint.getArchetypeId() == null) {
            throw new QueryBuilderException(QueryBuilderException.ErrorCode.InvalidObjectReferenceConstraint, constraint);
        }
        ArchetypeId id = constraint.getArchetypeId();
        context.pushLogicalOperator(QueryContext.LogicalOperator.AND);
        TypeSet types = TypeSet.create(constraint, this.cache, this.assembler);
        boolean popJoin = context.pushTypeSet(types);
        String alias = constraint.getAlias();
        context.addConstraint(alias, ARCHETYPE_ID_SHORT_NAME, RelationalOp.EQ, id.getShortName());
        context.addConstraint(alias, "id", RelationalOp.EQ, constraint.getId());
        for (IConstraint oc : constraint.getConstraints()) {
            this.processConstraint(oc, context);
        }
        context.popTypeSet(popJoin);
        context.popLogicalOperator();
    }

    private void process(ParticipationConstraint constraint, QueryContext context) {
        String property = null;
        switch (constraint.getField()) {
            case ActShortName: {
                property = "actShortName";
                break;
            }
            case StartTime: {
                property = "activityStartTime";
                break;
            }
            case EndTime: {
                property = "activityEndTime";
            }
        }
        context.addConstraint(constraint.getAlias(), property, constraint.getOperator(), constraint.getValue());
    }

    private void process(CollectionNodeConstraint constraint, QueryContext context) {
        TypeSet types = context.peekTypeSet();
        String nodeName = constraint.getUnqualifiedName();
        List<NodeDescriptor> nodes = this.getMatchingNodeDescriptors(types.getDescriptors(), nodeName);
        if (nodes.isEmpty()) {
            throw new QueryBuilderException(QueryBuilderException.ErrorCode.NoNodeDescriptorForName, nodeName);
        }
        BaseArchetypeConstraint archetypeConstraint = constraint.getArchetypeConstraint();
        BaseArchetypeConstraint.State state = BaseArchetypeConstraint.State.BOTH;
        if (archetypeConstraint instanceof ArchetypeConstraint) {
            state = archetypeConstraint.getState();
            types = TypeSet.create((ArchetypeConstraint)archetypeConstraint, nodes, this.cache, this.assembler);
        } else {
            types = this.getTypeSet(archetypeConstraint);
        }
        types.setAlias(constraint.getAlias());
        context.pushTypeSet(types, this.getProperty(nodes.get(0)), constraint.getJoinType());
        boolean and = false;
        if (!this.constrainsByShortName(archetypeConstraint)) {
            if (state != BaseArchetypeConstraint.State.BOTH || !archetypeConstraint.getConstraints().isEmpty()) {
                context.pushLogicalOperator(QueryContext.LogicalOperator.AND);
                and = true;
            }
            Set<String> shortNames = types.getShortNames();
            boolean or = false;
            if (shortNames.size() > 1) {
                context.pushLogicalOperator(QueryContext.LogicalOperator.OR);
                or = true;
            }
            for (String shortName : shortNames) {
                this.process(new ArchetypeNodeConstraint(RelationalOp.EQ, shortName), context);
            }
            if (or) {
                context.popLogicalOperator();
            }
        }
        this.processArchetypeConstraint(archetypeConstraint, context);
        if (and) {
            context.popLogicalOperator();
        }
        context.popTypeSet(true);
    }

    private void process(ArchetypeSortConstraint constraint, QueryContext context) {
        context.addSortConstraint(constraint.getAlias(), ARCHETYPE_ID_SHORT_NAME, constraint.isAscending());
    }

    private void process(NodeSortConstraint constraint, QueryContext context) {
        TypeSet types = context.getTypeSet(constraint.getAlias());
        if (types == null) {
            throw new QueryBuilderException(QueryBuilderException.ErrorCode.InvalidQualifiedName, constraint.getNodeName());
        }
        NodeDescriptor ndesc = this.getMatchingNodeDescriptor(types.getDescriptors(), constraint.getNodeName());
        if (ndesc == null) {
            throw new QueryBuilderException(QueryBuilderException.ErrorCode.NoNodeDescriptorForName, constraint.getNodeName());
        }
        String property = this.getProperty(ndesc);
        context.addSortConstraint(constraint.getAlias(), property, constraint.isAscending());
    }

    private String getProperty(NodeDescriptor ndesc) {
        String aprop = ndesc.getPath();
        if (aprop.startsWith("/")) {
            aprop = ndesc.getPath().substring(1);
        }
        if (aprop.contains("/")) {
            throw new QueryBuilderException(QueryBuilderException.ErrorCode.CanOnlySortOnTopLevelNodes, ndesc.getName());
        }
        return aprop;
    }

    private NodeDescriptor getMatchingNodeDescriptor(Set<ArchetypeDescriptor> descriptors, String nodeName) {
        List<NodeDescriptor> matches = this.getMatchingNodeDescriptors(descriptors, nodeName);
        return !matches.isEmpty() ? matches.get(0) : null;
    }

    private List<NodeDescriptor> getMatchingNodeDescriptors(Set<ArchetypeDescriptor> descriptors, String nodeName) {
        ArrayList<NodeDescriptor> result = new ArrayList<NodeDescriptor>();
        NodeDescriptor matching = null;
        if (!StringUtils.isEmpty((CharSequence)nodeName)) {
            for (ArchetypeDescriptor descriptor : descriptors) {
                NodeDescriptor node = descriptor.getNodeDescriptor(nodeName);
                if (node == null) {
                    throw new QueryBuilderException(QueryBuilderException.ErrorCode.NoNodeDescWithName, descriptor.getName(), nodeName);
                }
                if (matching == null) {
                    matching = node;
                } else if (!node.getPath().equals(matching.getPath()) || !node.getType().equals(matching.getType())) {
                    throw new QueryBuilderException(QueryBuilderException.ErrorCode.NodeDescriptorsDoNotMatch, nodeName);
                }
                result.add(node);
            }
        }
        return result;
    }

    private TypeSet getTypeSet(BaseArchetypeConstraint constraint) {
        if (constraint instanceof ArchetypeIdConstraint) {
            return TypeSet.create((ArchetypeIdConstraint)constraint, this.cache, this.assembler);
        }
        if (constraint instanceof ShortNameConstraint) {
            return TypeSet.create((ShortNameConstraint)constraint, this.cache, this.assembler);
        }
        throw new QueryBuilderException(QueryBuilderException.ErrorCode.ConstraintTypeNotSupported, constraint.getClass().getName());
    }

    private void processArchetypeConstraint(BaseArchetypeConstraint constraint, QueryContext context) {
        if (constraint instanceof ArchetypeIdConstraint) {
            this.processArchetypeConstraint((ArchetypeIdConstraint)constraint, context);
        } else if (constraint instanceof ShortNameConstraint) {
            this.processArchetypeConstraint((ShortNameConstraint)constraint, context);
        } else if (constraint instanceof ArchetypeConstraint) {
            this.processArchetypeConstraint((ArchetypeConstraint)constraint, context);
        } else {
            throw new QueryBuilderException(QueryBuilderException.ErrorCode.ConstraintTypeNotSupported, constraint.getClass().getName());
        }
    }

    private void process(NotConstraint constraint, QueryContext context) {
        context.addNotConstraint();
        this.processConstraint(constraint.getConstraint(), context);
    }

    private void process(ExistsConstraint constraint, QueryContext context) {
        QueryContext subContext = this.process(constraint.getSubQuery(), context);
        context.addExistsConstraint(subContext.getQueryString());
    }

    private void process(IsAConstraint constraint, QueryContext context) {
        String name = constraint.getName();
        String[] shortNames = constraint.getShortNames();
        boolean or = false;
        if (shortNames.length > 1) {
            context.pushLogicalOperator(QueryContext.LogicalOperator.OR);
            or = true;
        }
        for (String shortName : shortNames) {
            String value = shortName.replace('*', '%');
            context.addConstraint(this.getAliasOrQualifiedName(name, context), ARCHETYPE_ID_SHORT_NAME, RelationalOp.EQ, value);
        }
        if (or) {
            context.popLogicalOperator();
        }
    }

    private void processConstraint(IConstraint constraint, QueryContext context) {
        if (constraint instanceof SelectConstraint) {
            context.addSelectConstraint((SelectConstraint)constraint);
        } else if (constraint instanceof ObjectRefConstraint) {
            this.process((ObjectRefConstraint)constraint, context);
        } else if (constraint instanceof ArchetypeIdConstraint) {
            this.process((ArchetypeIdConstraint)constraint, context);
        } else if (constraint instanceof ShortNameConstraint) {
            this.process((ShortNameConstraint)constraint, context);
        } else if (constraint instanceof CollectionNodeConstraint) {
            this.process((CollectionNodeConstraint)constraint, context);
        } else if (constraint instanceof ArchetypeNodeConstraint) {
            this.process((ArchetypeNodeConstraint)constraint, context);
        } else if (constraint instanceof NodeConstraint) {
            this.process((NodeConstraint)constraint, context);
        } else if (constraint instanceof ObjectRefNodeConstraint) {
            this.process((ObjectRefNodeConstraint)constraint, context);
        } else if (constraint instanceof IdConstraint) {
            this.process((IdConstraint)constraint, context);
        } else if (constraint instanceof AndConstraint) {
            this.process((AndConstraint)constraint, context);
        } else if (constraint instanceof OrConstraint) {
            this.process((OrConstraint)constraint, context);
        } else if (constraint instanceof NodeSortConstraint) {
            this.process((NodeSortConstraint)constraint, context);
        } else if (constraint instanceof ArchetypeSortConstraint) {
            this.process((ArchetypeSortConstraint)constraint, context);
        } else if (constraint instanceof ParticipationConstraint) {
            this.process((ParticipationConstraint)constraint, context);
        } else if (constraint instanceof NotConstraint) {
            this.process((NotConstraint)constraint, context);
        } else if (constraint instanceof ExistsConstraint) {
            this.process((ExistsConstraint)constraint, context);
        } else if (constraint instanceof IsAConstraint) {
            this.process((IsAConstraint)constraint, context);
        } else {
            throw new QueryBuilderException(QueryBuilderException.ErrorCode.ConstraintTypeNotSupported, constraint.getClass().getName());
        }
    }

    private String getQualifiedPropertyName(String nodeName, String alias, QueryContext context) {
        if (StringUtils.isEmpty((CharSequence)nodeName)) {
            throw new QueryBuilderException(QueryBuilderException.ErrorCode.MustSpecifyNodeName);
        }
        TypeSet types = context.getTypeSet(alias);
        if (types == null) {
            String name = alias != null ? alias + "." + nodeName : nodeName;
            throw new QueryBuilderException(QueryBuilderException.ErrorCode.NoNodeDescriptorForName, name);
        }
        NodeDescriptor desc = this.getMatchingNodeDescriptor(types.getDescriptors(), nodeName);
        if (desc == null) {
            throw new QueryBuilderException(QueryBuilderException.ErrorCode.NoNodeDescriptorForName, nodeName);
        }
        String property = this.getProperty(desc);
        if (alias == null) {
            alias = types.getAlias();
        }
        String result = alias + "." + property;
        return result;
    }

    private String getAliasOrQualifiedName(String name, QueryContext context) {
        String property;
        int index = name.indexOf(".");
        if (index == -1) {
            if (context.getTypeSet(name) == null) {
                String alias = context.peekTypeSet().getAlias();
                property = this.getQualifiedPropertyName(name, alias, context);
            } else {
                property = name;
            }
        } else {
            String alias = name.substring(0, index);
            String nodeName = name.substring(index + 1);
            property = this.getQualifiedPropertyName(nodeName, alias, context);
        }
        return property;
    }

    private boolean constrainsByShortName(BaseArchetypeConstraint constraint) {
        if (constraint instanceof ShortNameConstraint || constraint instanceof ArchetypeIdConstraint) {
            return true;
        }
        for (IConstraint c : constraint.getConstraints()) {
            if (c instanceof BaseArchetypeConstraint) {
                return this.constrainsByShortName((BaseArchetypeConstraint)c);
            }
            if (!(c instanceof ArchetypeNodeConstraint)) continue;
            return true;
        }
        return false;
    }
}

