/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import javax.persistence.criteria.CompoundSelection;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.query.criteria.internal.JoinImplementor;
import org.openvpms.component.business.dao.hibernate.im.common.CompoundAssembler;
import org.openvpms.component.business.dao.hibernate.im.common.IMObjectDO;
import org.openvpms.component.business.dao.hibernate.im.common.IMObjectDOImpl;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.model.archetype.NodeDescriptor;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.query.criteria.AggregateExpression;
import org.openvpms.component.system.common.query.criteria.BetweenPredicate;
import org.openvpms.component.system.common.query.criteria.ComparisonPredicate;
import org.openvpms.component.system.common.query.criteria.CriteriaQueryImpl;
import org.openvpms.component.system.common.query.criteria.ExistsPredicate;
import org.openvpms.component.system.common.query.criteria.ExpressionImpl;
import org.openvpms.component.system.common.query.criteria.FromImpl;
import org.openvpms.component.system.common.query.criteria.InPredicate;
import org.openvpms.component.system.common.query.criteria.JoinImpl;
import org.openvpms.component.system.common.query.criteria.MappedCriteriaQuery;
import org.openvpms.component.system.common.query.criteria.NotPredicate;
import org.openvpms.component.system.common.query.criteria.NullPredicate;
import org.openvpms.component.system.common.query.criteria.PathImpl;
import org.openvpms.component.system.common.query.criteria.PredicateImpl;
import org.openvpms.component.system.common.query.criteria.RootImpl;
import org.openvpms.component.system.common.query.criteria.SubqueryImpl;

public class MappedCriteriaQueryFactory {
    private final CriteriaBuilder builder;
    private final CompoundAssembler assembler;
    private static final String ARCHETYPE_ID = "archetypeId";
    private static final String ID = "id";
    private static final String LINK_ID = "linkId";
    private static final String SHORT_NAME = "shortName";

    public MappedCriteriaQueryFactory(CriteriaBuilder builder, CompoundAssembler assembler) {
        this.builder = builder;
        this.assembler = assembler;
    }

    public <X, Y> MappedCriteriaQuery<Y> createCriteriaQuery(CriteriaQueryImpl<X> query) {
        Class<?> impl = this.getImpl(query.getResultType());
        CriteriaQuery result = this.builder.createQuery(impl);
        HashMap built = new HashMap();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        this.buildRoots(query, result, built, predicates);
        this.buildSubqueries(query, result, built);
        this.buildSelection(query, result, built);
        this.buildWhere(query, result, built, predicates);
        this.buildGroupBy(query, result, built);
        this.buildHaving(query, result, built);
        this.buildOrderBy(query, result, built);
        return new MappedCriteriaQuery(result, built);
    }

    private <X, Y> void buildRoots(CriteriaQueryImpl<X> query, CriteriaQuery<Y> result, Map<TupleElement<?>, TupleElement<?>> built, List<Predicate> predicates) {
        for (RootImpl<IMObject> root : query.getRoots()) {
            Class type = root.getJavaType();
            Root from = result.from(this.getImpl(type));
            if (root.getAlias() != null) {
                from.alias(root.getAlias());
            }
            built.put((TupleElement<?>)root, (TupleElement<?>)from);
            Predicate archetype = this.getArchetypePredicate((Path<?>)from, root.getArchetypes());
            predicates.add(archetype);
            for (JoinImpl join : root.getJoins()) {
                this.buildJoin((From<? extends IMObjectDO, ? extends IMObjectDO>)from, join, built);
            }
        }
    }

    private <X, Y> void buildSubqueries(CriteriaQueryImpl<X> query, CriteriaQuery<Y> result, Map<TupleElement<?>, TupleElement<?>> built) {
        for (SubqueryImpl<?> subquery : query.getSubqueries()) {
            this.buildSubquery(subquery, result, built);
        }
    }

    private <X, Y> void buildSelection(CriteriaQueryImpl<X> query, CriteriaQuery<Y> result, Map<TupleElement<?>, TupleElement<?>> built) {
        if (query.getSelection() != null) {
            this.buildSelect(query.getSelection(), result, built);
        } else if (query.getMultiselect() != null) {
            this.buildMultiselect(query.getMultiselect(), result, built);
        }
        result.distinct(query.getDistinct());
    }

    private <X, Y> void buildWhere(CriteriaQueryImpl<X> query, CriteriaQuery<Y> result, Map<TupleElement<?>, TupleElement<?>> built, List<Predicate> predicates) {
        Expression<Boolean> where = query.getWhere();
        if (where != null) {
            Expression<?> expression = this.buildExpression(where, built);
            if (expression instanceof Predicate) {
                predicates.add((Predicate)expression);
                result.where(predicates.toArray(new Predicate[0]));
            } else {
                Predicate and = this.builder.and(predicates.toArray(new Predicate[0]));
                result.where((Expression)this.builder.and((Expression)and, expression));
            }
        } else {
            result.where(predicates.toArray(new Predicate[0]));
        }
    }

    private <X, Y> void buildGroupBy(CriteriaQueryImpl<X> query, CriteriaQuery<Y> result, Map<TupleElement<?>, TupleElement<?>> built) {
        if (query.getGroupBy() != null) {
            ArrayList grouping = new ArrayList();
            for (Expression<?> expression : query.getGroupBy()) {
                grouping.add(this.buildExpression(expression, built));
            }
            result.groupBy(grouping);
        }
    }

    private <X, Y> void buildHaving(CriteriaQueryImpl<X> query, CriteriaQuery<Y> result, Map<TupleElement<?>, TupleElement<?>> built) {
        if (query.getHaving() != null) {
            Expression<?> expression = this.buildExpression(query.getHaving(), built);
            result.having(this.cast(expression, Boolean.class));
        }
    }

    private <X, Y> void buildOrderBy(CriteriaQueryImpl<X> query, CriteriaQuery<Y> result, Map<TupleElement<?>, TupleElement<?>> built) {
        if (query.getOrderBy() != null) {
            ArrayList<Order> orderBy = new ArrayList<Order>();
            for (Order order : query.getOrderBy()) {
                Expression<?> expression = this.buildExpression(order.getExpression(), built);
                if (order.isAscending()) {
                    orderBy.add(this.builder.asc(expression));
                    continue;
                }
                orderBy.add(this.builder.desc(expression));
            }
            result.orderBy(orderBy);
        }
    }

    private <X, Y> void buildSubquery(SubqueryImpl<X> subquery, CriteriaQuery<?> query, Map<TupleElement<?>, TupleElement<?>> built) {
        Class<?> impl = this.getImpl(subquery.getJavaType());
        Subquery target = query.subquery(impl);
        built.put((TupleElement<?>)subquery, (TupleElement<?>)target);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        for (RootImpl<IMObject> root : subquery.getRoots()) {
            Class type = root.getJavaType();
            Root from = target.from(this.getImpl(type));
            if (root.getAlias() != null) {
                from.alias(root.getAlias());
            }
            built.put((TupleElement<?>)root, (TupleElement<?>)from);
            Predicate archetype = this.getArchetypePredicate((Path<?>)from, root.getArchetypes());
            predicates.add(archetype);
            for (JoinImpl join : root.getJoins()) {
                this.buildJoin((From<? extends IMObjectDO, ? extends IMObjectDO>)from, join, built);
            }
        }
        if (subquery.getSelect() != null) {
            Expression selection = (Expression)this.buildSelection((Selection<?>)subquery.getSelect(), built);
            target.select(selection);
        }
        target.distinct(subquery.getDistinct());
        Expression<Boolean> where = subquery.getWhere();
        if (where != null) {
            Expression<Boolean> expression = this.cast(this.buildExpression(where, built), Boolean.class);
            if (expression instanceof Predicate) {
                predicates.add((Predicate)expression);
                target.where(predicates.toArray(new Predicate[0]));
            } else {
                Predicate and = this.builder.and(predicates.toArray(new Predicate[0]));
                target.where((Expression)this.builder.and((Expression)and, expression));
            }
        } else {
            target.where(predicates.toArray(new Predicate[0]));
        }
    }

    private <X, Y> void buildSelect(Selection<? super X> selection, CriteriaQuery<Y> query, Map<TupleElement<?>, TupleElement<?>> built) {
        Selection<?> target = this.buildSelection(selection, built);
        query.select(target);
    }

    private <Y> void buildMultiselect(Selection<?>[] selections, CriteriaQuery<Y> query, Map<TupleElement<?>, TupleElement<?>> built) {
        Selection[] targets = new Selection[selections.length];
        for (int i = 0; i < selections.length; ++i) {
            targets[i] = this.buildSelection(selections[i], built);
        }
        query.multiselect(targets);
    }

    private Selection<?> buildSelection(Selection<?> selection, Map<TupleElement<?>, TupleElement<?>> built) {
        Selection<?> result;
        if (selection instanceof FromImpl) {
            result = (Selection<?>)built.get(selection);
            if (result == null) {
                throw new IllegalArgumentException("Selection doesn't map to a From instance: " + selection);
            }
        } else if (selection instanceof PathImpl) {
            PathImpl path = (PathImpl)selection;
            result = this.buildSelectionFromPath(path, built);
            built.put((TupleElement<?>)selection, (TupleElement<?>)result);
        } else if (selection instanceof AggregateExpression) {
            result = this.buildAggregate((AggregateExpression)selection, built);
            built.put((TupleElement<?>)selection, (TupleElement<?>)result);
        } else {
            throw new IllegalStateException("Selections of type " + selection.getClass() + " are not supported");
        }
        return result;
    }

    private Selection<?> buildSelectionFromPath(PathImpl<?> path, Map<TupleElement<?>, TupleElement<?>> built) {
        CompoundSelection result;
        if (Reference.class.isAssignableFrom(path.getJavaType())) {
            Path reference;
            Path parent = this.getParent(path, built);
            if (parent == null) {
                throw new IllegalStateException("Can't select reference. Not a known root");
            }
            if (path.getNode() == null) {
                reference = parent;
            } else {
                String[] parts = this.getNodePath(path);
                if (parts.length == 1) {
                    reference = parent.get(parts[0]);
                    if (path.getAlias() != null) {
                        reference.alias(path.getAlias());
                    }
                } else {
                    throw new IllegalArgumentException("Unsupported node " + path.getNode().getPath());
                }
            }
            result = this.builder.construct(IMObjectReference.class, new Selection[]{reference.get(ARCHETYPE_ID), reference.get(ID), reference.get(LINK_ID)});
        } else {
            From<?, ?> parent = this.getParent(path, built);
            if (parent == null) {
                throw new IllegalStateException("Can't select path. Not a known root");
            }
            String[] parts = this.getNodePath(path);
            if (parts.length == 1) {
                result = parent.get(parts[0]);
            } else if (parts.length == 2) {
                result = this.getDetailsValuePath(path, parent, parts[1]);
            } else {
                throw new IllegalArgumentException("Unsupported node " + path.getNode().getPath());
            }
            if (path.getAlias() != null) {
                result.alias(path.getAlias());
            }
        }
        return result;
    }

    private Path<?> getDetailsValuePath(PathImpl<?> path, From<?, ?> parent, String key) {
        JoinType joinType = parent instanceof Join ? ((Join)parent).getJoinType() : JoinType.INNER;
        MapJoin mapJoin = parent.joinMap("details", joinType);
        mapJoin.on((Expression)this.builder.equal((Expression)mapJoin.key(), (Object)key));
        if (path.getAlias() != null) {
            mapJoin.alias(path.getAlias());
        }
        return mapJoin.value().get("value");
    }

    private void buildJoin(From<? extends IMObjectDO, ? extends IMObjectDO> from, JoinImpl<?, ?> join, Map<TupleElement<?>, TupleElement<?>> built) {
        JoinType joinType = join.getJoinType() == JoinImpl.JoinType.INNER ? JoinType.INNER : JoinType.LEFT;
        String[] parts = this.getNodePath(join);
        if (parts.length != 1) {
            throw new IllegalArgumentException("Cannot join on " + join);
        }
        Join targetJoin = from.join(parts[0], joinType);
        Class<?> impl = this.getImpl(join.getJavaType());
        if (!targetJoin.getJavaType().equals(impl)) {
            JoinImplementor targetJoinImpl = (JoinImplementor)targetJoin;
            Set joins = targetJoinImpl.getParent().getJoins();
            joins.remove(targetJoin);
            targetJoin = targetJoinImpl.treatAs(impl);
            joins.add(targetJoin);
        }
        if (join.getAlias() != null) {
            targetJoin.alias(join.getAlias());
        }
        built.put((TupleElement<?>)join, (TupleElement<?>)targetJoin);
        Predicate archetypePredicate = this.getArchetypePredicate((Path<?>)targetJoin, join.getArchetypes());
        if (join.getExpression() != null) {
            Expression<Boolean> expression = this.cast(this.buildExpression(join.getExpression(), built), Boolean.class);
            if (expression instanceof Predicate) {
                targetJoin.on(new Predicate[]{archetypePredicate, (Predicate)expression});
            } else {
                targetJoin.on((Expression)this.builder.and((Expression)archetypePredicate, expression));
            }
        } else {
            targetJoin.on((Expression)archetypePredicate);
        }
        for (JoinImpl nested : join.getJoins()) {
            this.buildJoin((From<? extends IMObjectDO, ? extends IMObjectDO>)targetJoin, nested, built);
        }
    }

    private From<?, ?> getParent(PathImpl<?> path, Map<TupleElement<?>, TupleElement<?>> built) {
        PathImpl<?> parent = path.getParent();
        if (parent == null) {
            throw new IllegalStateException("Can't have an null parent when selecting by reference");
        }
        return (From)built.get(parent);
    }

    private Predicate getArchetypePredicate(Path<?> path, Set<String> archetypes) {
        String[] list = archetypes.toArray(new String[0]);
        Predicate result = list.length == 1 ? this.builder.equal((Expression)path.get(ARCHETYPE_ID).get(SHORT_NAME), (Object)list[0]) : path.get(ARCHETYPE_ID).get(SHORT_NAME).in((Object[])list);
        return result;
    }

    private Class<?> getImpl(Class<?> type) {
        Class<IMObjectDOImpl> result;
        if (IMObject.class.isAssignableFrom(type)) {
            result = this.assembler.getDOClass(type);
            if (result == null) {
                throw new IllegalStateException("Invalid type " + type.getName());
            }
        } else {
            result = Tuple.class.isAssignableFrom(type) ? Tuple.class : type;
        }
        return result;
    }

    private Expression<?> buildExpression(Expression<?> expression, Map<TupleElement<?>, TupleElement<?>> built) {
        Expression<?> result = (Expression<?>)built.get(expression);
        if (result == null) {
            if (expression instanceof ComparisonPredicate) {
                result = this.buildComparison((ComparisonPredicate)expression, built);
            } else if (expression instanceof PathImpl) {
                result = this.buildPath((PathImpl)expression, built);
            } else if (expression instanceof AggregateExpression) {
                result = this.buildAggregate((AggregateExpression)expression, built);
            } else if (expression instanceof BetweenPredicate) {
                result = this.buildBetween((BetweenPredicate)expression, built);
            } else if (expression instanceof InPredicate) {
                result = this.buildIn((InPredicate)expression, built);
            } else if (expression instanceof NullPredicate) {
                result = this.buildNull((NullPredicate)expression, built);
            } else if (expression instanceof ExistsPredicate) {
                result = this.buildExists((ExistsPredicate)expression, built);
            } else if (expression instanceof NotPredicate) {
                result = this.buildNot((NotPredicate)expression, built);
            } else if (expression instanceof PredicateImpl) {
                result = this.buildPredicate((PredicateImpl)expression, built);
            } else {
                throw new IllegalArgumentException("Unsupported argument " + expression);
            }
        }
        return result;
    }

    private Expression<?> buildIn(InPredicate predicate, Map<TupleElement<?>, TupleElement<?>> built) {
        Expression<?> expression = this.buildExpression(predicate.getExpression(), built);
        if (predicate.getValues() != null) {
            return expression.in(predicate.getValues());
        }
        ArrayList values = new ArrayList();
        for (Expression<?> value : predicate.getExpressionValues()) {
            values.add(this.buildExpression(value, built));
        }
        return expression.in(values);
    }

    private Predicate buildNull(NullPredicate predicate, Map<TupleElement<?>, TupleElement<?>> built) {
        Expression<?> expression = this.buildExpression(predicate.getExpression(), built);
        Predicate result = predicate.isNegated() ? this.builder.isNotNull(expression) : this.builder.isNull(expression);
        return result;
    }

    private Expression<?> buildExists(ExistsPredicate predicate, Map<TupleElement<?>, TupleElement<?>> built) {
        Subquery subquery = (Subquery)built.get(predicate.getSubquery());
        if (subquery == null) {
            throw new IllegalArgumentException("Subquery not found");
        }
        return this.builder.exists(subquery);
    }

    private Expression<?> buildNot(NotPredicate predicate, Map<TupleElement<?>, TupleElement<?>> built) {
        Expression<Boolean> expression = this.cast(this.buildExpression(predicate.getExpression(), built), Boolean.class);
        return this.builder.not(expression);
    }

    private Expression<Boolean> buildBooleanExpression(Expression<Boolean> expression, Map<TupleElement<?>, TupleElement<?>> built) {
        return this.cast(this.buildExpression(expression, built), Boolean.class);
    }

    private Expression<?> buildPredicate(PredicateImpl expression, Map<TupleElement<?>, TupleElement<?>> built) {
        Predicate result;
        List<Expression<Boolean>> expressions = expression.getExpressions();
        switch (expression.getOperator()) {
            case AND: {
                if (expressions.size() == 2) {
                    result = this.builder.and(this.buildBooleanExpression(expressions.get(0), built), this.buildBooleanExpression(expressions.get(1), built));
                    break;
                }
                result = this.builder.and(this.buildPredicates(expressions, built));
                break;
            }
            case OR: {
                if (expressions.size() == 2) {
                    result = this.builder.or(this.buildBooleanExpression(expressions.get(0), built), this.buildBooleanExpression(expressions.get(1), built));
                    break;
                }
                result = this.builder.or(this.buildPredicates(expressions, built));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operator: " + expression.getOperator());
            }
        }
        return result;
    }

    private Predicate[] buildPredicates(List<? extends Expression<Boolean>> expressions, Map<TupleElement<?>, TupleElement<?>> built) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        for (Expression<Boolean> expression : expressions) {
            predicates.add((Predicate)this.buildExpression(expression, built));
        }
        return predicates.toArray(new Predicate[0]);
    }

    private Expression<?> buildAggregate(AggregateExpression<?> expression, Map<TupleElement<?>, TupleElement<?>> built) {
        Expression result;
        switch (expression.getFunction()) {
            case COUNT: {
                result = this.builder.count(this.buildExpression(expression.getExpression(), built));
                break;
            }
            case COUNT_DISTINCT: {
                result = this.builder.countDistinct(this.buildExpression(expression.getExpression(), built));
                break;
            }
            case SUM: {
                result = this.builder.sum(this.cast(this.buildExpression(expression.getExpression(), built), Number.class));
                break;
            }
            case MAX: {
                result = this.builder.max(this.cast(this.buildExpression(expression.getExpression(), built), Number.class));
                break;
            }
            case MIN: {
                result = this.builder.min(this.cast(this.buildExpression(expression.getExpression(), built), Number.class));
                break;
            }
            case GREATEST: {
                result = this.builder.greatest(this.cast(this.buildExpression(expression.getExpression(), built), Comparable.class));
                break;
            }
            case LEAST: {
                result = this.builder.least(this.cast(this.buildExpression(expression.getExpression(), built), Comparable.class));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported function " + (Object)((Object)expression.getFunction()));
            }
        }
        return result;
    }

    private Path<?> buildPath(PathImpl<?> path, Map<TupleElement<?>, TupleElement<?>> built) {
        Path<?> result = (Path<?>)built.get(path);
        if (result == null) {
            PathImpl<?> parent = path.getParent();
            From from = (From)built.get(parent);
            if (from == null) {
                throw new IllegalStateException("Failed to find From for path=" + path.getName());
            }
            boolean reference = path.isReference();
            if (reference && path.getNode() == null) {
                result = from;
            } else {
                String[] parts = this.getNodePath(path);
                if (parts.length == 1) {
                    result = from.get(parts[0]);
                } else if (parts.length == 2) {
                    result = this.getDetailsValuePath(path, from, parts[1]);
                } else {
                    throw new IllegalArgumentException("Unsupported node " + path.getNode().getPath());
                }
            }
            if (path.getAlias() != null) {
                result.alias(path.getAlias());
            }
            built.put((TupleElement<?>)path, (TupleElement<?>)result);
        }
        return result;
    }

    private String[] getNodePath(PathImpl<?> path) {
        NodeDescriptor node = path.getNode();
        if (node == null) {
            throw new IllegalArgumentException("Path doesn't have a node");
        }
        String[] parts = StringUtils.split((String)node.getPath(), (char)'/');
        if (parts.length == 0 || parts.length > 2) {
            throw new IllegalArgumentException("Unsupported path=" + node.getPath() + " for node " + path.getName());
        }
        if (parts.length == 2 && !"details".equals(parts[0])) {
            throw new IllegalArgumentException("Unsupported path=" + node.getPath() + " associated with node: " + node.getName());
        }
        return parts;
    }

    private boolean isReference(Object expression) {
        return expression instanceof PathImpl && ((PathImpl)expression).isReference();
    }

    private Path<?> buildArchetypePath(PathImpl<?> path, Map<TupleElement<?>, TupleElement<?>> built) {
        Path result;
        PathImpl<?> parent = path.getParent();
        From from = (From)built.get(parent);
        if (from == null) {
            throw new IllegalStateException("Failed to find From for path=" + path.getName());
        }
        if (path.getNode() == null) {
            result = from.get(ARCHETYPE_ID).get(SHORT_NAME);
        } else {
            String[] parts = this.getNodePath(path);
            if (parts.length == 1) {
                result = from.get(parts[0]).get(ARCHETYPE_ID).get(SHORT_NAME);
            } else {
                throw new IllegalArgumentException("Unsupported node " + path.getNode().getPath());
            }
        }
        return result;
    }

    private Predicate buildComparison(ComparisonPredicate comparison, Map<TupleElement<?>, TupleElement<?>> built) {
        Predicate result;
        if (this.isReference(comparison.getLHS())) {
            result = this.buildReferenceComparison(comparison, built);
        } else {
            Expression<?> lhs = this.buildExpression(comparison.getLHS(), built);
            if (comparison.getRHS() instanceof ExpressionImpl) {
                Expression<?> rhs = this.buildExpression((Expression)comparison.getRHS(), built);
                switch (comparison.getComparisonOperator()) {
                    case EQ: {
                        result = this.builder.equal(lhs, rhs);
                        break;
                    }
                    case NE: {
                        result = this.builder.notEqual(lhs, rhs);
                        break;
                    }
                    case GT: {
                        result = this.builder.greaterThan(lhs, rhs);
                        break;
                    }
                    case GTE: {
                        result = this.builder.greaterThanOrEqualTo(lhs, rhs);
                        break;
                    }
                    case LT: {
                        result = this.builder.lessThan(lhs, rhs);
                        break;
                    }
                    case LTE: {
                        result = this.builder.lessThanOrEqualTo(lhs, rhs);
                        break;
                    }
                    case LIKE: {
                        result = this.builder.like(this.cast(lhs, String.class), this.cast(rhs, String.class));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported operator: " + (Object)((Object)comparison.getComparisonOperator()));
                    }
                }
            } else if (comparison.getLHS() instanceof ExpressionImpl) {
                Comparable rhs = (Comparable)comparison.getRHS();
                switch (comparison.getComparisonOperator()) {
                    case EQ: {
                        result = this.builder.equal(lhs, (Object)rhs);
                        break;
                    }
                    case NE: {
                        result = this.builder.notEqual(lhs, (Object)rhs);
                        break;
                    }
                    case GT: {
                        result = this.builder.greaterThan(this.cast(lhs, Comparable.class), rhs);
                        break;
                    }
                    case GTE: {
                        result = this.builder.greaterThanOrEqualTo(this.cast(lhs, Comparable.class), rhs);
                        break;
                    }
                    case LT: {
                        result = this.builder.lessThan(this.cast(lhs, Comparable.class), rhs);
                        break;
                    }
                    case LTE: {
                        result = this.builder.lessThanOrEqualTo(this.cast(lhs, Comparable.class), rhs);
                        break;
                    }
                    case LIKE: {
                        result = this.builder.like(this.cast(lhs, String.class), rhs.toString());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported operator: " + (Object)((Object)comparison.getComparisonOperator()));
                    }
                }
            } else {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
        return result;
    }

    private Predicate buildReferenceComparison(ComparisonPredicate comparison, Map<TupleElement<?>, TupleElement<?>> built) {
        Predicate result;
        if (comparison.getComparisonOperator() != ComparisonPredicate.Operator.EQ && comparison.getComparisonOperator() != ComparisonPredicate.Operator.NE) {
            throw new IllegalArgumentException("Cannot perform " + (Object)((Object)comparison.getComparisonOperator()) + " on reference expressions");
        }
        boolean equal = comparison.getComparisonOperator() == ComparisonPredicate.Operator.EQ;
        PathImpl lhs = (PathImpl)comparison.getLHS();
        Path lhsId = this.buildPath(lhs, built).get(ID);
        if (this.isReference(comparison.getRHS())) {
            PathImpl rhs = (PathImpl)comparison.getRHS();
            Path rhsId = this.buildPath(rhs, built).get(ID);
            if (equal) {
                Path<?> lhsArchetype = this.buildArchetypePath(lhs, built);
                Path<?> rhsArchetype = this.buildArchetypePath(rhs, built);
                result = this.builder.and((Expression)this.builder.equal((Expression)lhsId, (Expression)rhsId), (Expression)this.builder.equal(lhsArchetype, rhsArchetype));
            } else {
                result = this.builder.notEqual((Expression)lhsId, (Expression)rhsId);
            }
        } else if (comparison.getRHS() instanceof Reference) {
            Reference reference = (Reference)comparison.getRHS();
            if (equal) {
                Path<?> lhsArchetype = this.buildArchetypePath(lhs, built);
                result = this.builder.and((Expression)this.builder.equal((Expression)lhsId, (Object)reference.getId()), (Expression)this.builder.equal(lhsArchetype, (Object)reference.getArchetype()));
            } else {
                result = this.builder.notEqual((Expression)lhsId, (Object)reference.getId());
            }
        } else if (comparison.getRHS() instanceof Long) {
            result = this.builder.and(new Predicate[]{this.builder.equal((Expression)lhsId, comparison.getRHS())});
        } else {
            throw new IllegalArgumentException("Cannot compare reference with " + comparison.getRHS());
        }
        return result;
    }

    private Predicate buildBetween(BetweenPredicate between, Map<TupleElement<?>, TupleElement<?>> built) {
        Predicate result;
        Expression<?> value = this.buildExpression(between.getValue(), built);
        Object lowerBound = between.getLowerBound();
        Object upperBound = between.getUpperBound();
        if (lowerBound instanceof Expression) {
            Expression<?> lower = this.buildExpression((Expression)lowerBound, built);
            Expression<?> upper = this.buildExpression((Expression)upperBound, built);
            result = this.builder.between(value, lower, upper);
        } else {
            result = this.builder.between(value, (Comparable)lowerBound, (Comparable)upperBound);
        }
        return result;
    }

    private <T> Expression<T> cast(Expression<?> expression, Class<T> type) {
        Class wrapper;
        Class exprType = expression.getJavaType();
        if (!(type.isAssignableFrom(exprType) || (wrapper = ClassUtils.primitiveToWrapper((Class)exprType)) != null && type.isAssignableFrom(wrapper))) {
            throw new IllegalArgumentException("Expression type is not a " + type.getName() + ": " + exprType.getName());
        }
        return expression;
    }
}

