/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im.common;

import org.hibernate.Session;
import org.openvpms.component.business.dao.hibernate.im.common.CompoundAssembler;
import org.openvpms.component.business.dao.hibernate.im.common.Context;
import org.openvpms.component.business.dao.hibernate.im.common.DOState;
import org.openvpms.component.business.dao.hibernate.im.common.DeleteHandler;
import org.openvpms.component.business.dao.hibernate.im.common.IMObjectDO;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.model.object.Reference;

public abstract class AbstractDeleteHandler
implements DeleteHandler {
    private final CompoundAssembler assembler;

    protected AbstractDeleteHandler(CompoundAssembler assembler) {
        this.assembler = assembler;
    }

    @Override
    public void delete(IMObject object, Session session, Context context) {
        if (!object.isNew()) {
            DOState state = this.assembler.assemble(object, context);
            this.delete(state, session, context);
        }
    }

    @Override
    public void delete(Reference reference, Session session, Context context) {
        if (!reference.isNew()) {
            DOState state = this.assembler.assemble(reference, context);
            this.delete(state, session, context);
        }
    }

    protected void delete(IMObjectDO object, Session session, Context context) {
        context.remove(object);
    }

    private void delete(DOState state, Session session, Context context) {
        this.delete(state.getObject(), session, context);
        session.flush();
    }
}

