/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im.archetype;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.openvpms.component.business.dao.hibernate.im.archetype.ArchetypeDescriptorDO;
import org.openvpms.component.business.dao.hibernate.im.archetype.AssertionDescriptorDO;
import org.openvpms.component.business.dao.hibernate.im.archetype.DescriptorDOImpl;
import org.openvpms.component.business.dao.hibernate.im.archetype.NodeDescriptorDO;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.im.archetype.descriptor.DescriptorException;

public class NodeDescriptorDOImpl
extends DescriptorDOImpl
implements NodeDescriptorDO {
    private String defaultValue;
    private boolean derived = false;
    private String derivedValue;
    private String displayName;
    private String filter;
    private int index;
    private boolean hidden = false;
    private boolean readOnly = false;
    private String baseName;
    private boolean isParentChild = true;
    private boolean isArray = false;
    private int maxCardinality = 1;
    private int minCardinality = 0;
    private int maxLength;
    private int minLength;
    private NodeDescriptorDO parent;
    private ArchetypeDescriptorDO archetype;
    private final Map<String, NodeDescriptorDO> nodeDescriptors = new LinkedHashMap<String, NodeDescriptorDO>();
    private final Map<String, AssertionDescriptorDO> assertionDescriptors = new LinkedHashMap<String, AssertionDescriptorDO>();
    private String path;
    private String type;
    private static final ArchetypeId NODE = new ArchetypeId("descriptor.node.1.0");
    private static final ArchetypeId COLLECTION_NODE = new ArchetypeId("descriptor.collectionNode");

    @Override
    public ArchetypeId getArchetypeId() {
        return this.nodeDescriptors == null || this.nodeDescriptors.isEmpty() ? NODE : COLLECTION_NODE;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean isDerived() {
        return this.derived;
    }

    @Override
    public void setDerived(boolean derived) {
        this.derived = derived;
    }

    @Override
    public String getDerivedValue() {
        return this.derivedValue;
    }

    @Override
    public void setDerivedValue(String derivedValue) {
        this.derivedValue = derivedValue;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    @Override
    public void setBaseName(String baseName) {
        this.baseName = baseName;
    }

    @Override
    public boolean isParentChild() {
        return this.isParentChild;
    }

    @Override
    public void setParentChild(boolean parentChild) {
        this.isParentChild = parentChild;
    }

    @Override
    public int getMaxCardinality() {
        return this.maxCardinality;
    }

    @Override
    public void setMaxCardinality(int cardinality) {
        this.maxCardinality = cardinality;
    }

    @Override
    public int getMinCardinality() {
        return this.minCardinality;
    }

    @Override
    public void setMinCardinality(int cardinality) {
        this.minCardinality = cardinality;
    }

    @Override
    public int getMaxLength() {
        return this.maxLength <= 0 ? 255 : this.maxLength;
    }

    @Override
    public void setMaxLength(int length) {
        this.maxLength = length;
    }

    @Override
    public int getMinLength() {
        return this.minLength;
    }

    @Override
    public void setMinLength(int length) {
        this.minLength = length;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        if (StringUtils.isEmpty((CharSequence)type)) {
            this.type = null;
        } else if (type.endsWith("[]")) {
            this.isArray = true;
            this.type = type.substring(0, type.indexOf("[]"));
        } else {
            this.type = type;
        }
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public ArchetypeDescriptorDO getArchetypeDescriptor() {
        return this.archetype;
    }

    @Override
    public void setArchetypeDescriptor(ArchetypeDescriptorDO descriptor) {
        this.archetype = descriptor;
    }

    @Override
    public NodeDescriptorDO getParent() {
        return this.parent;
    }

    @Override
    public void setParent(NodeDescriptorDO parent) {
        this.parent = parent;
    }

    @Override
    public Map<String, NodeDescriptorDO> getNodeDescriptors() {
        return this.nodeDescriptors;
    }

    @Override
    public Map<String, NodeDescriptorDO> getAllNodeDescriptors() {
        LinkedHashMap<String, NodeDescriptorDO> result = new LinkedHashMap<String, NodeDescriptorDO>();
        for (NodeDescriptorDO descriptor : this.nodeDescriptors.values()) {
            result.put(descriptor.getName(), descriptor);
            result.putAll(descriptor.getNodeDescriptors());
        }
        return result;
    }

    @Override
    public void addNodeDescriptor(NodeDescriptorDO child) {
        if (this.nodeDescriptors.containsKey(child.getName())) {
            throw new DescriptorException(DescriptorException.ErrorCode.DuplicateNodeDescriptor, child.getName(), this.getName());
        }
        this.nodeDescriptors.put(child.getName(), child);
        child.setParent(this);
    }

    @Override
    public AssertionDescriptorDO getAssertionDescriptor(String name) {
        return this.assertionDescriptors.get(name);
    }

    @Override
    public Map<String, AssertionDescriptorDO> getAssertionDescriptors() {
        return this.assertionDescriptors;
    }

    @Override
    public void addAssertionDescriptor(AssertionDescriptorDO descriptor) {
        this.assertionDescriptors.put(descriptor.getName(), descriptor);
    }

    @Override
    public void removeAssertionDescriptor(AssertionDescriptorDO descriptor) {
        this.assertionDescriptors.remove(descriptor.getName());
    }

    @Override
    public void removeAssertionDescriptor(String name) {
        this.assertionDescriptors.remove(name);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.getName()).append("displayName", (Object)this.displayName).append("isHidden", this.hidden).append("isArray", this.isArray).append("isDerived", this.derived).append("derivedValue", (Object)this.derivedValue).append("path", (Object)this.path).append("type", (Object)this.type).append("defaultValue", (Object)this.defaultValue).append("minCardinality", this.minCardinality).append("maxCardinality", this.maxCardinality).append("minLength", this.minLength).append("maxLength", this.maxLength).append("baseName", (Object)this.baseName).append("isParentChild", this.isParentChild).append("index", this.index).append("assertionDescriptors", this.assertionDescriptors).append("nodeDescriptors", this.nodeDescriptors).toString();
    }
}

