/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.FlushMode;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.openvpms.component.business.dao.hibernate.cache.ArchetypeIdCache;
import org.openvpms.component.business.dao.hibernate.im.DeleteHandlerFactory;
import org.openvpms.component.business.dao.hibernate.im.common.CompoundAssembler;
import org.openvpms.component.business.dao.hibernate.im.common.Context;
import org.openvpms.component.business.dao.hibernate.im.common.ContextHandler;
import org.openvpms.component.business.dao.hibernate.im.common.DOState;
import org.openvpms.component.business.dao.hibernate.im.common.DeferredAssembler;
import org.openvpms.component.business.dao.hibernate.im.common.DeleteHandler;
import org.openvpms.component.business.dao.hibernate.im.common.IMObjectDO;
import org.openvpms.component.business.dao.hibernate.im.entity.DefaultObjectLoader;
import org.openvpms.component.business.dao.hibernate.im.entity.HibernateResultCollector;
import org.openvpms.component.business.dao.hibernate.im.entity.IMObjectNodeResultCollector;
import org.openvpms.component.business.dao.hibernate.im.entity.IMObjectResultCollector;
import org.openvpms.component.business.dao.hibernate.im.entity.NodeSetResultCollector;
import org.openvpms.component.business.dao.hibernate.im.entity.ObjectSetResultCollector;
import org.openvpms.component.business.dao.hibernate.im.lookup.LookupReplacer;
import org.openvpms.component.business.dao.hibernate.im.query.MappedCriteriaQueryFactory;
import org.openvpms.component.business.dao.hibernate.im.query.QueryBuilder;
import org.openvpms.component.business.dao.hibernate.im.query.QueryContext;
import org.openvpms.component.business.dao.im.common.IMObjectDAO;
import org.openvpms.component.business.dao.im.common.IMObjectDAOException;
import org.openvpms.component.business.dao.im.common.ResultCollector;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.service.archetype.descriptor.cache.ArchetypeDescriptorCacheDB;
import org.openvpms.component.business.service.archetype.descriptor.cache.IArchetypeDescriptorCache;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.component.system.common.query.NamedQuery;
import org.openvpms.component.system.common.query.NodeSet;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.TupleImpl;
import org.openvpms.component.system.common.query.criteria.CriteriaQueryImpl;
import org.openvpms.component.system.common.query.criteria.MappedCriteriaQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.annotation.Transactional;

public class IMObjectDAOHibernate
implements IMObjectDAO,
ContextHandler,
InitializingBean {
    private final SessionFactory factory;
    private final ArchetypeIdCache archetypeIds;
    private DeleteHandlerFactory handlerFactory;
    private CompoundAssembler assembler;
    private IArchetypeDescriptorCache cache;
    private MappedCriteriaQueryFactory queryFactory;
    private static final Logger log = LoggerFactory.getLogger(IMObjectDAOHibernate.class);

    public IMObjectDAOHibernate(SessionFactory factory) {
        this(factory, new ArchetypeIdCache());
    }

    public IMObjectDAOHibernate(SessionFactory factory, ArchetypeIdCache archetypeIds) {
        this.factory = factory;
        this.archetypeIds = archetypeIds;
    }

    public void setArchetypeDescriptorCache(IArchetypeDescriptorCache cache) {
        this.cache = cache;
    }

    public void setAssembler(CompoundAssembler assembler) {
        this.assembler = assembler;
    }

    public void afterPropertiesSet() {
        if (this.cache instanceof ArchetypeDescriptorCacheDB) {
            ((ArchetypeDescriptorCacheDB)this.cache).setDao(this);
        }
        this.queryFactory = new MappedCriteriaQueryFactory(this.factory.getCriteriaBuilder(), this.assembler);
        this.handlerFactory = new DeleteHandlerFactory(this.assembler, this.cache);
    }

    @Override
    @Transactional
    public void save(IMObject object) {
        try {
            this.save(Collections.singletonList(object), this.getSession());
        }
        catch (Exception exception) {
            throw new IMObjectDAOException(IMObjectDAOException.ErrorCode.FailedToSaveIMObject, exception, object.getId());
        }
    }

    @Override
    @Transactional
    public void save(Collection<? extends IMObject> objects) {
        try {
            this.save(objects, this.getSession());
        }
        catch (Exception exception) {
            throw new IMObjectDAOException(IMObjectDAOException.ErrorCode.FailedToSaveCollectionOfObjects, exception);
        }
    }

    @Override
    @Transactional
    public void delete(IMObject object) {
        try {
            Session session = this.getSession();
            Context context = this.getContext(session);
            DeleteHandler handler = this.handlerFactory.getHandler(object);
            handler.delete(object, session, context);
            this.updateIds(context);
        }
        catch (IMObjectDAOException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new IMObjectDAOException(IMObjectDAOException.ErrorCode.FailedToDeleteIMObject, exception, object.getObjectReference());
        }
    }

    @Override
    @Transactional
    public void delete(Reference reference) {
        try {
            Session session = this.getSession();
            Context context = this.getContext(session);
            DeleteHandler handler = this.handlerFactory.getHandler(reference);
            handler.delete(reference, session, context);
            this.updateIds(context);
        }
        catch (IMObjectDAOException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new IMObjectDAOException(IMObjectDAOException.ErrorCode.FailedToDeleteIMObject, exception, reference);
        }
    }

    @Override
    @Transactional
    public IPage<IMObject> get(IArchetypeQuery query) {
        return this.getQueryDelegator(query).get(query);
    }

    @Override
    @Transactional
    public IPage<IMObject> get(IArchetypeQuery query, Collection<String> nodes) {
        return this.getQueryDelegator(query).get(query, nodes);
    }

    @Override
    @Transactional
    public IPage<ObjectSet> getObjects(IArchetypeQuery query) {
        return this.getQueryDelegator(query).getObjects(query);
    }

    @Override
    @Transactional
    public IPage<NodeSet> getNodes(IArchetypeQuery query, Collection<String> nodes) {
        return this.getQueryDelegator(query).getNodes(query, nodes);
    }

    @Override
    public <X, Y> MappedCriteriaQuery<Y> createQuery(CriteriaQuery<X> query) {
        CriteriaQueryImpl impl = (CriteriaQueryImpl)query;
        return this.queryFactory.createCriteriaQuery(impl);
    }

    @Override
    @Transactional
    public <X, Y> List<Y> getResults(MappedCriteriaQuery<X> criteriaQuery, Class<Y> type, int firstResult, int maxResults) {
        ArrayList<Y> result = new ArrayList<Y>();
        Session session = this.getSession();
        Query typedQuery = session.createQuery(criteriaQuery.getQuery());
        typedQuery.setHint("org.hibernate.cacheable", (Object)true);
        typedQuery.setFirstResult(firstResult);
        if (maxResults != Integer.MAX_VALUE) {
            typedQuery.setMaxResults(maxResults);
        }
        Context context = Context.getContext(session, this.assembler, this.archetypeIds);
        for (Object source : typedQuery.getResultList()) {
            Y target = this.adapt(source, type, criteriaQuery, context);
            result.add(target);
        }
        context.resolveDeferredReferences();
        return result;
    }

    @Override
    @Transactional
    public <X, Y> Y getSingleResult(MappedCriteriaQuery<X> criteriaQuery, Class<Y> type) {
        Session session = this.getSession();
        Query typedQuery = session.createQuery(criteriaQuery.getQuery());
        Context context = Context.getContext(session, this.assembler, this.archetypeIds);
        Object source = typedQuery.getSingleResult();
        Y result = this.adapt(source, type, criteriaQuery, context);
        context.resolveDeferredReferences();
        return result;
    }

    @Override
    @Transactional
    public IPage<IMObject> get(String shortName, String instanceName, String clazz, boolean activeOnly, int firstResult, int maxResults) {
        if ((clazz = this.assembler.getDOClassName(clazz)) == null) {
            throw new IMObjectDAOException(IMObjectDAOException.ErrorCode.ClassNameMustBeSpecified);
        }
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Object> params = new ArrayList<Object>();
        String queryString = this.buildQuery(shortName, instanceName, clazz, activeOnly, names, params);
        log.debug("Executing {} with names {} and params {}", new Object[]{queryString, names, params});
        try {
            IMObjectResultCollector collector = new IMObjectResultCollector();
            this.executeQuery(queryString, null, new Params(names, params), collector, firstResult, maxResults);
            return collector.getPage();
        }
        catch (Exception exception) {
            throw new IMObjectDAOException(IMObjectDAOException.ErrorCode.FailedToFindIMObjects, exception, shortName, instanceName, clazz);
        }
    }

    @Override
    @Transactional
    public IMObject get(Reference reference) {
        return this.getObject(reference, null);
    }

    @Override
    @Transactional
    public IMObject get(Reference reference, boolean active) {
        return this.getObject(reference, active);
    }

    @Override
    @Transactional
    public void getByNamedQuery(String query, Map<String, Object> parameters, ResultCollector<?> collector, int firstResult, int maxResults, boolean count) {
        try {
            this.executeNamedQuery(query, parameters, firstResult, maxResults, (HibernateResultCollector)collector, count);
        }
        catch (Exception exception) {
            throw new IMObjectDAOException(IMObjectDAOException.ErrorCode.FailedToExecuteNamedQuery, exception);
        }
    }

    @Override
    public void preCommit(Context context) {
        if (!context.getSaveDeferred().isEmpty()) {
            this.saveDeferred(context, true);
        }
    }

    @Override
    public void commit(Context context) {
        context.commit();
    }

    @Override
    public void rollback(Context context) {
        context.rollback();
    }

    @Override
    @Transactional
    public void replace(Lookup source, Lookup target) {
        try {
            LookupReplacer replacer = new LookupReplacer(this.cache);
            replacer.replace(source, target, this.getSession());
        }
        catch (Exception exception) {
            throw new IMObjectDAOException(IMObjectDAOException.ErrorCode.FailedToSaveIMObject, exception, source.getId());
        }
    }

    private String buildQuery(String shortName, String instanceName, String clazz, boolean activeOnly, List<String> names, List<Object> params) {
        StringBuilder result = new StringBuilder();
        boolean andRequired = false;
        result.append("from ");
        result.append(clazz);
        result.append(" as entity");
        if (!StringUtils.isEmpty((CharSequence)shortName) || !StringUtils.isEmpty((CharSequence)instanceName)) {
            result.append(" where ");
        }
        if (!StringUtils.isEmpty((CharSequence)shortName)) {
            names.add("shortName");
            andRequired = true;
            if (shortName.endsWith("*") || shortName.startsWith("*")) {
                result.append(" entity.archetypeId.shortName like :shortName");
                params.add(shortName.replace("*", "%"));
            } else {
                result.append(" entity.archetypeId.shortName = :shortName");
                params.add(shortName);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)instanceName)) {
            if (andRequired) {
                result.append(" and ");
            }
            names.add("instanceName");
            andRequired = true;
            if (instanceName.endsWith("*") || instanceName.startsWith("*")) {
                result.append(" entity.name like :instanceName");
                params.add(instanceName.replace("*", "%"));
            } else {
                result.append(" entity.name = :instanceName");
                params.add(instanceName);
            }
        }
        if (activeOnly) {
            if (andRequired) {
                result.append(" and ");
            }
            result.append(" entity.active = 1");
        }
        return result.toString();
    }

    private Session getSession() {
        Session session = this.factory.getCurrentSession();
        session.setHibernateFlushMode(FlushMode.COMMIT);
        return session;
    }

    private IMObject getObject(Reference reference, Boolean active) {
        ArchetypeDescriptor desc;
        IMObject cached;
        IMObject result = null;
        Session session = this.getSession();
        Context context = this.getContext(session);
        DOState state = context.getCached(reference);
        IMObject iMObject = cached = state != null ? state.getSource() : null;
        if (cached != null) {
            result = active != null && active.booleanValue() != cached.isActive() ? null : cached;
        } else if (!reference.isNew() && (desc = this.cache.getArchetypeDescriptor(reference.getArchetype())) != null) {
            result = this.getObject(desc.getClassName(), reference, active);
        }
        return result;
    }

    private void executeQuery(String queryString, String countQuery, Params params, HibernateResultCollector<?> collector, int firstResult, int maxResults) {
        Session session = this.getSession();
        collector.setFirstResult(firstResult);
        collector.setPageSize(maxResults);
        collector.setSession(session);
        Context context = this.getContext(session);
        collector.setContext(context);
        if (maxResults == 0 && countQuery != null) {
            int rowCount = this.count(countQuery, params, session);
            collector.setTotalResults(rowCount);
        } else {
            Query query = session.createQuery(queryString);
            params.setParameters(query);
            if (firstResult != 0) {
                query.setFirstResult(firstResult);
            }
            if (maxResults != -1) {
                query.setMaxResults(maxResults);
                log.debug("The maximum number of rows is {}", (Object)maxResults);
            }
            query.setCacheable(true);
            List rows = query.list();
            if (maxResults == -1) {
                collector.setTotalResults(rows.size());
            } else if (countQuery != null) {
                int rowCount = this.count(countQuery, params, session);
                if (rowCount < rows.size()) {
                    rowCount = rows.size();
                }
                collector.setTotalResults(rowCount);
            } else {
                collector.setTotalResults(-1);
            }
            for (Object object : rows) {
                collector.collect(object);
            }
            context.resolveDeferredReferences();
        }
    }

    private void executeNamedQuery(String name, Map<String, Object> params, int firstRow, int numOfRows, HibernateResultCollector<?> collector, boolean count) {
        Session session = this.getSession();
        Query query = session.getNamedQuery(name);
        Params p = new Params(params);
        p.setParameters(query);
        if (firstRow != 0) {
            query.setFirstResult(firstRow);
        }
        if (numOfRows != -1) {
            query.setMaxResults(numOfRows);
            log.debug("The maximum number of rows is {}", (Object)numOfRows);
        }
        List rows = query.list();
        collector.setFirstResult(firstRow);
        collector.setPageSize(numOfRows);
        collector.setSession(session);
        Context context = this.getContext(session);
        collector.setContext(context);
        if (numOfRows == -1) {
            collector.setTotalResults(rows.size());
        } else if (count) {
            int rowCount = this.countNamedQuery(name, p, session);
            if (rowCount < rows.size()) {
                rowCount = rows.size();
            }
            collector.setTotalResults(rowCount);
        } else {
            collector.setTotalResults(-1);
        }
        for (Object object : rows) {
            collector.collect(object);
        }
        context.resolveDeferredReferences();
    }

    private int count(String queryString, Params params, Session session) {
        Query query = session.createQuery(queryString);
        params.setParameters(query);
        return ((Number)query.list().get(0)).intValue();
    }

    private int countNamedQuery(String name, Params params, Session session) {
        Query query = session.getNamedQuery(name);
        params.setParameters(query);
        int result = 0;
        try (ScrollableResults results = query.scroll(ScrollMode.FORWARD_ONLY);){
            if (results.last()) {
                result = results.getRowNumber() + 1;
            }
        }
        return result;
    }

    private IMObject getObject(String clazz, Reference reference, Boolean active) {
        List results;
        if ((clazz = this.assembler.getDOClassName(clazz)) == null) {
            throw new IMObjectDAOException(IMObjectDAOException.ErrorCode.ClassNameMustBeSpecified);
        }
        StringBuilder queryString = new StringBuilder();
        queryString.append("select entity from ");
        queryString.append(clazz);
        queryString.append(" as entity where entity.id = :id and entity.archetypeId.shortName = :shortName");
        if (active != null) {
            queryString.append(" and entity.active = :active");
        }
        Session session = this.getSession();
        Query query = session.createQuery(queryString.toString(), IMObjectDO.class);
        query.setParameter("id", (Object)reference.getId());
        query.setParameter("shortName", (Object)reference.getArchetype());
        if (active != null) {
            query.setParameter("active", (Object)active);
        }
        if ((results = query.list()).isEmpty()) {
            return null;
        }
        Context context = this.getContext(session);
        IMObjectDO object = (IMObjectDO)results.get(0);
        IMObject result = this.assembler.assemble(object, context);
        context.resolveDeferredReferences();
        return result;
    }

    private <X, Y> Y adapt(X object, Class<Y> type, MappedCriteriaQuery<?> query, Context context) {
        Object target = object instanceof IMObjectDO ? type.cast(this.assembler.assemble((IMObjectDO)object, context)) : (object instanceof Tuple ? type.cast(this.adapt((Tuple)object, query, context)) : (object instanceof ArchetypeId ? type.cast(this.archetypeIds.get((ArchetypeId)object)) : object));
        return (Y)target;
    }

    private Tuple adapt(Tuple tuple, MappedCriteriaQuery<?> query, Context context) {
        List sources = tuple.getElements();
        ArrayList targets = new ArrayList(sources.size());
        Object[] values = new Object[sources.size()];
        int index = 0;
        for (TupleElement source : sources) {
            TupleElement<?> target = query.getElement(source);
            if (target == null) {
                throw new IllegalStateException("No TupleElement found for: " + source);
            }
            Object object = tuple.get(source);
            if (object != null) {
                object = this.adapt(object, target.getJavaType(), query, context);
            }
            targets.add(target);
            values[index++] = object;
        }
        return new TupleImpl(targets, values);
    }

    private void save(Collection<? extends IMObject> objects, Session session) {
        Context context = this.getContext(session);
        boolean deferred = !context.getSaveDeferred().isEmpty();
        ArrayList<DOState> toSave = new ArrayList<DOState>();
        for (IMObject iMObject : objects) {
            DOState state = this.assembler.assemble(iMObject, context);
            if (state.isComplete()) {
                toSave.add(state);
                continue;
            }
            context.addSaveDeferred(state);
        }
        if (!toSave.isEmpty()) {
            this.save(toSave, context);
        }
        if (deferred || context.getSaveDeferred().size() > 1) {
            this.saveDeferred(context, false);
        }
        if (!context.isSynchronizationActive()) {
            this.preCommit(context);
        }
    }

    private void updateIds(Context context) {
        for (DOState state : context.getSaved()) {
            state.updateIds(context);
        }
    }

    private void saveDeferred(Context context, boolean failOnIncomplete) {
        List<DOState> states = this.assembleDeferred(context);
        this.save(states, context);
        Set<DOState> saveDeferred = context.getSaveDeferred();
        if (!saveDeferred.isEmpty() && failOnIncomplete) {
            DOState state = saveDeferred.iterator().next();
            Set<DeferredAssembler> deferred = state.getDeferred();
            Reference ref = null;
            if (!deferred.isEmpty()) {
                DeferredAssembler deferredAssembler = deferred.iterator().next();
                ref = deferredAssembler.getReference();
            }
            throw new IMObjectDAOException(IMObjectDAOException.ErrorCode.ObjectNotFound, ref);
        }
    }

    private List<DOState> assembleDeferred(Context context) {
        boolean processed;
        ArrayList<DOState> result = new ArrayList<DOState>();
        do {
            processed = false;
            Set<DeferredAssembler> assemblers = this.getDeferredAssemblers(context, result);
            if (assemblers.isEmpty()) continue;
            for (DeferredAssembler deferred : assemblers) {
                if (context.getCached(deferred.getReference()) == null) continue;
                deferred.assemble(context);
                processed = true;
            }
        } while (processed);
        return result;
    }

    private Set<DeferredAssembler> getDeferredAssemblers(Context context, List<DOState> result) {
        HashSet<DeferredAssembler> assemblers = new HashSet<DeferredAssembler>();
        Map<DOState, Set<DeferredAssembler>> deferred = DOState.getDeferred(context.getSaveDeferred());
        for (Map.Entry<DOState, Set<DeferredAssembler>> entry : deferred.entrySet()) {
            DOState state = entry.getKey();
            Set<DeferredAssembler> set = entry.getValue();
            if (!set.isEmpty()) {
                assemblers.addAll(set);
                continue;
            }
            context.removeSaveDeferred(state);
            result.add(state);
        }
        return assemblers;
    }

    private void save(List<DOState> states, Context context) {
        Session session = context.getSession();
        Collection<IMObjectDO> objects = DOState.getObjects(states);
        for (IMObjectDO object : objects) {
            session.saveOrUpdate((Object)object);
        }
        DOState.updateIds(states, context);
        for (DOState state : states) {
            context.addSaved(state);
        }
    }

    private Context getContext(Session session) {
        Context context = Context.getContext(session, this.assembler, this.archetypeIds);
        context.setContextHandler(this);
        return context;
    }

    private QueryDelegator getQueryDelegator(IArchetypeQuery query) {
        if (query instanceof ArchetypeQuery) {
            return new DefaultQueryDelegator();
        }
        if (query instanceof NamedQuery) {
            return new NamedQueryDelegator();
        }
        throw new IllegalArgumentException("Unsupported query: " + query.getClass().getName());
    }

    private static class Params {
        private final String[] names;
        private final Object[] values;

        public Params(List<String> names, List<Object> values) {
            this.names = names.toArray(new String[0]);
            this.values = values.toArray();
        }

        public Params(Map<String, Object> params) {
            this.names = params.keySet().toArray(new String[0]);
            this.values = new Object[this.names.length];
            for (int i = 0; i < this.names.length; ++i) {
                this.values[i] = params.get(this.names[i]);
            }
        }

        public void setParameters(Query<?> query) {
            for (int i = 0; i < this.names.length; ++i) {
                if (this.values[i] instanceof Collection) {
                    query.setParameterList(this.names[i], (Collection)this.values[i]);
                    continue;
                }
                if (this.values[i] instanceof Object[]) {
                    query.setParameterList(this.names[i], (Object[])this.values[i]);
                    continue;
                }
                query.setParameter(this.names[i], this.values[i]);
            }
        }

        public String[] getNames() {
            return this.names;
        }

        public Object[] getValues() {
            return this.values;
        }
    }

    class NamedQueryDelegator
    extends QueryDelegator {
        NamedQueryDelegator() {
        }

        @Override
        public IPage<ObjectSet> getObjects(IArchetypeQuery query) {
            NamedQuery q = (NamedQuery)query;
            ArrayList<String> names = q.getNames() != null ? new ArrayList<String>(q.getNames()) : null;
            List<String> refNames = Collections.emptyList();
            ObjectSetResultCollector collector = new ObjectSetResultCollector(names, refNames, null, IMObjectDAOHibernate.this.archetypeIds);
            collector.setLoader(new DefaultObjectLoader());
            this.get(query, collector);
            return collector.getPage();
        }

        @Override
        protected void get(IArchetypeQuery query, ResultCollector<?> collector) {
            NamedQuery q = (NamedQuery)query;
            IMObjectDAOHibernate.this.getByNamedQuery(q.getQuery(), q.getParameters(), collector, q.getFirstResult(), q.getMaxResults(), q.countResults());
        }
    }

    class DefaultQueryDelegator
    extends QueryDelegator {
        DefaultQueryDelegator() {
        }

        @Override
        public IPage<ObjectSet> getObjects(IArchetypeQuery query) {
            QueryBuilder builder = new QueryBuilder(IMObjectDAOHibernate.this.cache, IMObjectDAOHibernate.this.assembler);
            QueryContext context = builder.build((ArchetypeQuery)query);
            ObjectSetResultCollector collector = new ObjectSetResultCollector(context.getSelectNames(), context.getRefSelectNames(), context.getSelectTypes(), IMObjectDAOHibernate.this.archetypeIds);
            collector.setLoader(new DefaultObjectLoader());
            this.get(context, query, collector);
            return collector.getPage();
        }

        @Override
        protected void get(IArchetypeQuery query, ResultCollector<?> collector) {
            QueryBuilder builder = new QueryBuilder(IMObjectDAOHibernate.this.cache, IMObjectDAOHibernate.this.assembler);
            QueryContext context = builder.build((ArchetypeQuery)query);
            this.get(context, query, collector);
        }

        private void get(QueryContext context, IArchetypeQuery query, ResultCollector<?> collector) {
            String queryString = context.getQueryString();
            String countQuery = null;
            log.debug("ArchetypeService.get: query {}", (Object)queryString);
            try {
                if (query.countResults()) {
                    countQuery = context.getQueryString(true);
                }
                IMObjectDAOHibernate.this.executeQuery(queryString, countQuery, new Params(context.getParameters()), (HibernateResultCollector)collector, query.getFirstResult(), query.getMaxResults());
            }
            catch (Exception exception) {
                throw new IMObjectDAOException(IMObjectDAOException.ErrorCode.FailedToExecuteQuery, exception, queryString);
            }
        }
    }

    abstract class QueryDelegator {
        QueryDelegator() {
        }

        public IPage<IMObject> get(IArchetypeQuery query) {
            IMObjectResultCollector collector = new IMObjectResultCollector();
            collector.setLoader(new DefaultObjectLoader());
            this.get(query, collector);
            return collector.getPage();
        }

        public IPage<IMObject> get(IArchetypeQuery query, Collection<String> nodes) {
            IMObjectNodeResultCollector collector = new IMObjectNodeResultCollector(IMObjectDAOHibernate.this.cache, nodes);
            collector.setLoader(new DefaultObjectLoader());
            this.get(query, collector);
            return collector.getPage();
        }

        public IPage<NodeSet> getNodes(IArchetypeQuery query, Collection<String> nodes) {
            NodeSetResultCollector collector = new NodeSetResultCollector(IMObjectDAOHibernate.this.cache, nodes);
            collector.setLoader(new DefaultObjectLoader());
            this.get(query, collector);
            return collector.getPage();
        }

        public abstract IPage<ObjectSet> getObjects(IArchetypeQuery var1);

        protected abstract void get(IArchetypeQuery var1, ResultCollector<?> var2);
    }
}

