/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2021 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.component.business.dao.hibernate.im.entity;

import org.openvpms.component.business.dao.hibernate.im.common.IMObjectDOImpl;
import org.openvpms.component.business.domain.archetype.ArchetypeId;


/**
 * Implementation of the {@link EntityIdentityDO} interface.
 *
 * @author <a href="mailto:support@openvpms.org>OpenVPMS Team</a>
 */
public class EntityIdentityDOImpl extends IMObjectDOImpl implements EntityIdentityDO {

    /**
     * The identity.
     */
    private String identity;

    /**
     * The entity that has the identity.
     */
    private EntityDO entity;


    /**
     * Default constructor.
     */
    public EntityIdentityDOImpl() {
        // do nothing
    }

    /**
     * Constructs a {@link EntityIdentityDOImpl}.
     *
     * @param archetypeId the archetype id
     */
    public EntityIdentityDOImpl(ArchetypeId archetypeId) {
        super(archetypeId);
    }

    /**
     * Returns the identity.
     *
     * @return the identity
     */
    public String getIdentity() {
        return identity;
    }

    /**
     * Sets the identity.
     *
     * @param identity the identity
     */
    public void setIdentity(String identity) {
        this.identity = identity;
    }

    /**
     * Returns the entity that has the identity.
     *
     * @return the entity
     */
    public EntityDO getEntity() {
        return entity;
    }

    /**
     * Sets the entity that has the identity.
     *
     * @param entity the entity
     */
    public void setEntity(EntityDO entity) {
        this.entity = entity;
    }

}
