/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tools.archetype.loader;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.stringparsers.BooleanStringParser;
import com.martiansoftware.jsap.stringparsers.IntegerStringParser;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.tools.archetype.loader.ArchetypeLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class DerivedNodeUpdater {
    private final IArchetypeService service;
    private int batchSize = 100;
    private boolean failOnError = true;
    private static final String APPLICATION_CONTEXT = "applicationContext.xml";
    private static final int DEFAULT_BATCH_SIZE = 100;
    private static final Logger log = LoggerFactory.getLogger(ArchetypeLoader.class);

    public DerivedNodeUpdater(IArchetypeService service) {
        this.service = service;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public int update(String shortName) {
        return this.update(new String[]{shortName});
    }

    public int update(String[] shortNames) {
        if (log.isInfoEnabled()) {
            log.info("Updating: " + StringUtils.join((Object[])shortNames, (String)", "));
        }
        int saved = 0;
        ArchetypeQuery query = new ArchetypeQuery(shortNames, false, false);
        IMObjectQueryIterator iter = new IMObjectQueryIterator(this.service, query);
        ArrayList<IMObject> batch = new ArrayList<IMObject>();
        while (iter.hasNext()) {
            IMObject object = (IMObject)iter.next();
            this.service.deriveValues(object);
            batch.add(object);
            if (batch.size() < this.batchSize) continue;
            saved += this.saveBatch(batch);
        }
        if (!batch.isEmpty()) {
            saved += this.saveBatch(batch);
        }
        if (log.isInfoEnabled()) {
            log.info("Updated " + saved + " objects");
        }
        return saved;
    }

    public static void main(String[] args) {
        try {
            JSAP parser = DerivedNodeUpdater.createParser();
            JSAPResult config = parser.parse(args);
            if (!config.success()) {
                DerivedNodeUpdater.displayUsage(parser, config);
            } else {
                String contextPath = config.getString("context");
                Object context = !new File(contextPath).exists() ? new ClassPathXmlApplicationContext(contextPath) : new FileSystemXmlApplicationContext(contextPath);
                IArchetypeService service = (IArchetypeService)context.getBean("archetypeService");
                DerivedNodeUpdater updater = new DerivedNodeUpdater(service);
                updater.setBatchSize(config.getInt("batchSize"));
                updater.setFailOnError(config.getBoolean("failOnError"));
                String archetype = config.getString("archetype");
                if (StringUtils.isEmpty((CharSequence)archetype)) {
                    DerivedNodeUpdater.displayUsage(parser, config);
                } else {
                    updater.update(archetype);
                }
            }
        }
        catch (Throwable throwable) {
            log.error(throwable.getMessage(), throwable);
        }
    }

    private int saveBatch(List<IMObject> batch) {
        int saved = 0;
        try {
            this.service.save(batch);
            saved = batch.size();
        }
        catch (OpenVPMSException exception) {
            if (this.failOnError) {
                throw exception;
            }
            for (IMObject object : batch) {
                try {
                    this.service.save(object);
                    ++saved;
                }
                catch (OpenVPMSException error) {
                    log.error("Failed to save object: " + object, (Throwable)error);
                }
            }
        }
        batch.clear();
        return saved;
    }

    private static JSAP createParser() throws JSAPException {
        JSAP parser = new JSAP();
        parser.registerParameter(new FlaggedOption("archetype").setShortFlag('a').setLongFlag("archetype").setHelp("The short name of the archetype to update. May contain wildcards"));
        parser.registerParameter(new FlaggedOption("batchSize").setLongFlag("batchSize").setDefault("100").setStringParser((StringParser)IntegerStringParser.getParser()).setHelp("The batch size"));
        parser.registerParameter(new FlaggedOption("failOnError").setShortFlag('e').setLongFlag("failOnError").setDefault("true").setStringParser((StringParser)BooleanStringParser.getParser()).setHelp("Fail on validation error"));
        parser.registerParameter(new Switch("verbose").setShortFlag('v').setLongFlag("verbose").setDefault("false").setHelp("Displays verbose info to the console."));
        parser.registerParameter(new FlaggedOption("context").setLongFlag("context").setDefault(APPLICATION_CONTEXT).setHelp("The application context path"));
        return parser;
    }

    private static void displayUsage(JSAP parser, JSAPResult result) {
        Iterator iter = result.getErrorMessageIterator();
        while (iter.hasNext()) {
            System.err.println(iter.next());
        }
        System.err.println();
        System.err.println("Usage: java " + DerivedNodeUpdater.class.getName());
        System.err.println("                " + parser.getUsage());
        System.err.println();
        System.err.println(parser.getHelp());
        System.exit(1);
    }
}

