/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tools.archetype.loader;

import org.openvpms.component.business.domain.im.archetype.descriptor.AssertionTypeDescriptor;
import org.openvpms.component.model.archetype.ActionTypeDescriptor;
import org.openvpms.tools.archetype.comparator.ActionTypeChange;
import org.openvpms.tools.archetype.comparator.AssertionTypeChange;
import org.openvpms.tools.archetype.comparator.AssertionTypeComparator;
import org.openvpms.tools.archetype.comparator.AssertionTypeFieldChange;
import org.openvpms.tools.archetype.loader.DescriptorUpdater;

public class AssertionTypeUpdater
extends DescriptorUpdater<AssertionTypeDescriptor> {
    @Override
    public boolean update(AssertionTypeDescriptor target, AssertionTypeDescriptor source) {
        boolean updated = false;
        AssertionTypeComparator comparator = new AssertionTypeComparator();
        AssertionTypeChange change = comparator.compare(target, source);
        if (change != null) {
            for (AssertionTypeFieldChange fieldChange : change.getFieldChanges()) {
                switch (fieldChange.getField()) {
                    case NAME: {
                        target.setName(this.toString(fieldChange));
                        break;
                    }
                    case PROPERTY_ARCHETYPE: {
                        target.setPropertyArchetype(this.toString(fieldChange));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Cannot update " + target.getName() + ": unsupported field " + (Object)((Object)fieldChange.getField()));
                    }
                }
                updated = true;
            }
            for (ActionTypeChange typeChange : change.getActionTypeChanges()) {
                if (typeChange.isAdd()) {
                    target.addActionType((ActionTypeDescriptor)typeChange.getNewVersion());
                } else if (typeChange.isUpdate()) {
                    ActionTypeDescriptor existingType = (ActionTypeDescriptor)typeChange.getOldVersion();
                    ActionTypeDescriptor newType = (ActionTypeDescriptor)typeChange.getNewVersion();
                    existingType.setName(newType.getName());
                    existingType.setClassName(newType.getClassName());
                    existingType.setMethodName(newType.getMethodName());
                } else {
                    target.removeActionType((ActionTypeDescriptor)typeChange.getOldVersion());
                }
                updated = true;
            }
        }
        return updated;
    }
}

