/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tools.archetype.loader;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Switch;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.Expression;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptors;
import org.openvpms.component.business.domain.im.archetype.descriptor.AssertionTypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.AssertionTypeDescriptors;
import org.openvpms.component.business.domain.im.archetype.descriptor.DescriptorValidationError;
import org.openvpms.component.business.service.archetype.DelegatingArchetypeService;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.tools.archetype.comparator.ArchetypeComparator;
import org.openvpms.tools.archetype.io.ArchetypeIOHelper;
import org.openvpms.tools.archetype.loader.ArchetypeLoaderException;
import org.openvpms.tools.archetype.loader.ArchetypeUpdater;
import org.openvpms.tools.archetype.loader.AssertionTypeUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class ArchetypeLoader {
    private final ArchetypeService service;
    private final ArchetypeComparator comparator = new ArchetypeComparator();
    private boolean verbose;
    private static final String APPLICATION_CONTEXT = "archetype-loader-context.xml";
    private static final Logger log = LoggerFactory.getLogger(ArchetypeLoader.class);
    private static final String ARCHETYPE_DESCRIPTOR = "descriptor.archetype";
    private static final String DESCRIPTORS = "descriptor.*";
    private static final String ASSERTIONS = "assertion.*";

    public ArchetypeLoader(ArchetypeService service) {
        this.service = service;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void clean() {
        this.removeAssertionTypeDescriptors();
        this.removeArchetypeDescriptors();
    }

    public void loadAssertions(String fileName) {
        if (this.verbose) {
            log.info("Processing assertion type descriptors from: {}", (Object)fileName);
        }
        try {
            this.loadAssertions(new FileInputStream(fileName));
        }
        catch (FileNotFoundException exception) {
            throw new ArchetypeLoaderException(ArchetypeLoaderException.ErrorCode.FileNotFound, exception, fileName);
        }
    }

    public void loadArchetypes(String dirName, boolean recurse) {
        File dir = new File(dirName);
        if (!dir.exists()) {
            throw new ArchetypeLoaderException(ArchetypeLoaderException.ErrorCode.DirNotFound, dirName);
        }
        Collection<File> files = ArchetypeIOHelper.getArchetypeFiles(dir, recurse);
        LinkedHashMap<String, org.openvpms.component.model.archetype.ArchetypeDescriptor> descriptors = new LinkedHashMap<String, org.openvpms.component.model.archetype.ArchetypeDescriptor>();
        for (File file : files) {
            this.readArchetypes(file, descriptors);
        }
        this.loadArchetypes(descriptors);
    }

    public void loadArchetypes(String fileName) {
        LinkedHashMap<String, org.openvpms.component.model.archetype.ArchetypeDescriptor> descriptors = new LinkedHashMap<String, org.openvpms.component.model.archetype.ArchetypeDescriptor>();
        this.readArchetypes(new File(fileName), descriptors);
        this.loadArchetypes(descriptors);
    }

    public boolean loadAssertion(AssertionTypeDescriptor descriptor) {
        AssertionTypeDescriptor existing;
        boolean result = false;
        if (this.verbose) {
            log.info("Processing assertion type descriptor: {}", (Object)descriptor.getName());
        }
        if ((existing = (AssertionTypeDescriptor)this.getLatest(this.service.getAssertionTypeDescriptor(descriptor.getName()))) != null) {
            AssertionTypeUpdater updater = new AssertionTypeUpdater();
            if (updater.update(existing, descriptor)) {
                this.save(existing);
                result = true;
            }
        } else {
            this.save(descriptor);
            result = true;
        }
        return result;
    }

    public boolean loadArchetype(org.openvpms.component.model.archetype.ArchetypeDescriptor descriptor) {
        this.validate(descriptor, null);
        return this.loadIfChanged(descriptor);
    }

    public static ArchetypeLoader newBootstrapLoader(IArchetypeService service) {
        service = new DelegatingArchetypeService(service){

            @Override
            public void save(IMObject object) {
                if (!object.isA(new String[]{ArchetypeLoader.DESCRIPTORS, ArchetypeLoader.ASSERTIONS})) {
                    super.save(object);
                } else {
                    super.save(object, false);
                }
            }
        };
        return new ArchetypeLoader(service);
    }

    public static void main(String[] args) {
        block11: {
            try {
                JSAP parser = ArchetypeLoader.createParser();
                JSAPResult config = parser.parse(args);
                if (!config.success()) {
                    ArchetypeLoader.displayUsage(parser, config);
                    break block11;
                }
                String contextPath = config.getString("context");
                Object context = !new File(contextPath).exists() ? new ClassPathXmlApplicationContext(contextPath) : new FileSystemXmlApplicationContext(contextPath);
                IArchetypeService service = (IArchetypeService)context.getBean("archetypeService");
                ArchetypeLoader loader = ArchetypeLoader.newBootstrapLoader(service);
                String file = config.getString("file");
                String dir = config.getString("dir");
                boolean recurse = config.getBoolean("subdir");
                loader.setVerbose(config.getBoolean("verbose"));
                boolean clean = config.getBoolean("clean");
                String mappingFile = config.getString("mappingFile");
                int processed = 0;
                PlatformTransactionManager mgr = (PlatformTransactionManager)context.getBean(PlatformTransactionManager.class);
                TransactionStatus status = mgr.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
                try {
                    if (clean) {
                        loader.clean();
                        ++processed;
                    }
                    if (mappingFile != null) {
                        loader.loadAssertions(mappingFile);
                        ++processed;
                    }
                    if (file != null) {
                        loader.loadArchetypes(file);
                        ++processed;
                    } else if (dir != null) {
                        loader.loadArchetypes(dir, recurse);
                        ++processed;
                    }
                    mgr.commit(status);
                    if (processed == 0) {
                        ArchetypeLoader.displayUsage(parser, config);
                    }
                }
                catch (Throwable throwable) {
                    log.error(throwable.getMessage(), throwable);
                    log.error("Rolling back changes");
                    mgr.rollback(status);
                }
            }
            catch (Throwable throwable) {
                log.error(throwable.getMessage(), throwable);
            }
        }
    }

    private void save(IMObject descriptor) {
        if (this.verbose) {
            log.info("Saving {}", (Object)descriptor.getName());
        }
        this.service.save(descriptor);
    }

    private void loadArchetypes(Map<String, org.openvpms.component.model.archetype.ArchetypeDescriptor> descriptors) {
        ArrayList<String> archetypes = new ArrayList<String>(descriptors.keySet());
        for (String archetype : archetypes) {
            if (!TypeHelper.isA(archetype, DESCRIPTORS)) continue;
            this.loadIfChanged(descriptors.remove(archetype));
        }
        for (org.openvpms.component.model.archetype.ArchetypeDescriptor descriptor : descriptors.values()) {
            this.loadIfChanged(descriptor);
        }
    }

    private void loadAssertions(InputStream stream) {
        AssertionTypeDescriptors descriptors = AssertionTypeDescriptors.read(stream);
        for (AssertionTypeDescriptor descriptor : descriptors.getAssertionTypeDescriptors().values()) {
            this.loadAssertion(descriptor);
        }
    }

    private <T extends IMObject> T getLatest(T descriptor) {
        if (descriptor != null) {
            descriptor = this.service.get(descriptor.getObjectReference());
        }
        return descriptor;
    }

    private void readArchetypes(File file, Map<String, org.openvpms.component.model.archetype.ArchetypeDescriptor> descriptorMap) {
        ArchetypeDescriptors descriptors;
        String name = file.getName();
        if (this.verbose) {
            log.info("Processing file: {}", (Object)file.getPath());
        }
        try {
            descriptors = ArchetypeDescriptors.read(new FileInputStream(file));
        }
        catch (FileNotFoundException exception) {
            throw new ArchetypeLoaderException(ArchetypeLoaderException.ErrorCode.FileNotFound, exception, name);
        }
        for (ArchetypeDescriptor descriptor : descriptors.getArchetypeDescriptorsAsArray()) {
            this.validate(descriptor, name);
            if (descriptorMap.get(descriptor.getArchetypeType()) != null) {
                throw new ArchetypeLoaderException(ArchetypeLoaderException.ErrorCode.ValidationError, "Duplicate descriptor: " + descriptor.getArchetypeType() + " loaded from " + file.getPath());
            }
            descriptorMap.put(descriptor.getArchetypeType(), descriptor);
        }
    }

    private void validate(org.openvpms.component.model.archetype.ArchetypeDescriptor descriptor, String fileName) {
        List<DescriptorValidationError> validation = ((ArchetypeDescriptor)descriptor).validate();
        if (!validation.isEmpty()) {
            StringBuilder builder = new StringBuilder("[Validation Error] ");
            if (fileName != null) {
                builder.append("[").append(fileName).append("]");
            }
            builder.append(" archetype ").append(descriptor.getName()).append(" had ").append(validation.size()).append(" errors.\n");
            for (DescriptorValidationError error : validation) {
                builder.append("\ttype:").append((Object)error.getDescriptorType()).append(" instance:").append(error.getInstanceName()).append(" attribute:").append(error.getAttributeName()).append(" error:").append((Object)error.getError());
            }
            log.error(builder.toString());
            throw new ArchetypeLoaderException(ArchetypeLoaderException.ErrorCode.ValidationError, builder.toString());
        }
    }

    private boolean loadIfChanged(org.openvpms.component.model.archetype.ArchetypeDescriptor descriptor) {
        boolean result = false;
        if (this.verbose) {
            log.info("Processing archetype descriptor: {}", (Object)descriptor.getName());
        }
        String archetype = descriptor.getArchetypeType();
        org.openvpms.component.model.archetype.ArchetypeDescriptor persistent = this.getPersistent(descriptor);
        org.openvpms.component.model.archetype.ArchetypeDescriptor cached = this.service.getArchetypeDescriptor(archetype);
        if (persistent != null && cached != null && (persistent.getId() != cached.getId() || this.comparator.compare(persistent, cached) != null)) {
            this.service.save((IMObject)persistent);
            cached = null;
        }
        if (persistent != null || cached != null) {
            ArchetypeUpdater updater = new ArchetypeUpdater();
            if (persistent != null && updater.update(persistent, descriptor)) {
                this.save((IMObject)persistent);
                result = true;
            } else if (cached != null && updater.update(cached, descriptor)) {
                this.save((IMObject)cached);
                result = true;
            }
        } else {
            this.save((IMObject)descriptor);
            result = true;
        }
        if (this.verbose && !result) {
            log.info("Unchanged: {}", (Object)descriptor.getName());
        }
        return result;
    }

    private org.openvpms.component.model.archetype.ArchetypeDescriptor getPersistent(org.openvpms.component.model.archetype.ArchetypeDescriptor descriptor) {
        org.openvpms.component.model.archetype.ArchetypeDescriptor result = null;
        if (this.service.getArchetypeDescriptor(ARCHETYPE_DESCRIPTOR) != null) {
            CriteriaBuilder builder = this.service.getCriteriaBuilder();
            CriteriaQuery query = builder.createQuery(org.openvpms.component.model.archetype.ArchetypeDescriptor.class);
            Root root = query.from(org.openvpms.component.model.archetype.ArchetypeDescriptor.class, new String[]{ARCHETYPE_DESCRIPTOR});
            query.where((Expression)builder.equal((Expression)root.get("name"), (Object)descriptor.getName()));
            result = (org.openvpms.component.model.archetype.ArchetypeDescriptor)this.service.createQuery(query).getFirstResult();
        }
        return result;
    }

    private static JSAP createParser() throws JSAPException {
        JSAP parser = new JSAP();
        parser.registerParameter(new FlaggedOption("dir").setShortFlag('d').setLongFlag("dir").setHelp("Directory where ADL files reside."));
        parser.registerParameter(new Switch("subdir").setShortFlag('s').setLongFlag("subdir").setDefault("false").setHelp("Search the subdirectories as well."));
        parser.registerParameter(new FlaggedOption("file").setShortFlag('f').setLongFlag("file").setHelp("Name of file containing archetypes"));
        parser.registerParameter(new Switch("verbose").setShortFlag('v').setLongFlag("verbose").setDefault("false").setHelp("Displays verbose info to the console."));
        parser.registerParameter(new Switch("overwrite").setShortFlag('o').setLongFlag("overwrite").setDefault("false").setHelp("Overwrite archetype if it already exists"));
        parser.registerParameter(new Switch("clean").setShortFlag('c').setLongFlag("clean").setDefault("false").setHelp("Clean all the archetypes before loading"));
        parser.registerParameter(new FlaggedOption("context").setLongFlag("context").setDefault(APPLICATION_CONTEXT).setHelp("The application context path"));
        parser.registerParameter(new FlaggedOption("mappingFile").setShortFlag('m').setLongFlag("mappingFile").setHelp("A location of the assertion type mapping file"));
        return parser;
    }

    private static void displayUsage(JSAP parser, JSAPResult result) {
        Iterator iter = result.getErrorMessageIterator();
        while (iter.hasNext()) {
            System.err.println(iter.next());
        }
        System.err.println();
        System.err.println("Usage: java " + ArchetypeLoader.class.getName());
        System.err.println("                " + parser.getUsage());
        System.err.println();
        System.err.println(parser.getHelp());
        System.exit(1);
    }

    private void removeArchetypeDescriptors() {
        List descriptors = this.service.getArchetypeDescriptors();
        for (org.openvpms.component.model.archetype.ArchetypeDescriptor descriptor : descriptors) {
            if (this.verbose) {
                log.info("Deleting {}", (Object)descriptor.getName());
            }
            this.service.remove((IMObject)descriptor);
        }
    }

    private void removeAssertionTypeDescriptors() {
        List descriptors = this.service.getAssertionTypeDescriptors();
        for (org.openvpms.component.model.archetype.AssertionTypeDescriptor descriptor : descriptors) {
            if (this.verbose) {
                log.info("Deleting {}", (Object)descriptor.getName());
            }
            this.service.remove((IMObject)descriptor);
        }
    }
}

