/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tools.archetype.comparator;

import java.util.Objects;

public class DescriptorChange<T> {
    private final T oldVersion;
    private final T newVersion;

    public DescriptorChange(T oldVersion, T newVersion) {
        if (oldVersion == null && newVersion == null) {
            throw new IllegalArgumentException("Both oldVersion and newVersion may not be null");
        }
        this.oldVersion = oldVersion;
        this.newVersion = newVersion;
    }

    public boolean isAdd() {
        return this.oldVersion == null && this.newVersion != null;
    }

    public boolean isUpdate() {
        return this.oldVersion != null && this.newVersion != null;
    }

    public boolean isDelete() {
        return !this.isAdd() && !this.isUpdate();
    }

    public T getOldVersion() {
        return this.oldVersion;
    }

    public T getNewVersion() {
        return this.newVersion;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DescriptorChange) {
            DescriptorChange other = (DescriptorChange)object;
            return Objects.equals(this.oldVersion, other.getOldVersion()) && Objects.equals(this.newVersion, other.getNewVersion());
        }
        return false;
    }

    public int hashCode() {
        int hash = this.newVersion != null ? this.newVersion.hashCode() : -1;
        return hash ^= this.oldVersion != null ? this.oldVersion.hashCode() : -1;
    }
}

