/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.util;

import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.jxpath.util.TypeConverter;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.domain.im.datatypes.quantity.Money;
import org.openvpms.component.system.common.jxpath.OpenVPMSTypeConverter;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.component.system.common.util.PropertySetException;
import org.openvpms.component.system.common.util.PropertyState;

public abstract class AbstractPropertySet
implements PropertySet {
    private static final TypeConverter CONVERTER = new OpenVPMSTypeConverter();

    @Override
    public boolean exists(String name) {
        return this.getNames().contains(name);
    }

    @Override
    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        return (Boolean)this.get(name, defaultValue, Boolean.TYPE);
    }

    @Override
    public int getInt(String name) {
        return this.getInt(name, 0);
    }

    @Override
    public int getInt(String name, int defaultValue) {
        return (Integer)this.get(name, defaultValue, Integer.TYPE);
    }

    @Override
    public long getLong(String name) {
        return this.getLong(name, 0L);
    }

    @Override
    public long getLong(String name, long defaultValue) {
        return (Long)this.get(name, defaultValue, Long.TYPE);
    }

    @Override
    public String getString(String name) {
        return this.getString(name, null);
    }

    @Override
    public String getString(String name, String defaultValue) {
        return (String)this.get(name, defaultValue, String.class);
    }

    @Override
    public BigDecimal getBigDecimal(String name) {
        return this.getBigDecimal(name, null);
    }

    @Override
    public BigDecimal getBigDecimal(String name, BigDecimal defaultValue) {
        return (BigDecimal)this.get(name, defaultValue, BigDecimal.class);
    }

    @Override
    public Money getMoney(String name) {
        return this.getMoney(name, null);
    }

    @Override
    public Money getMoney(String name, Money defaultValue) {
        return (Money)this.get(name, defaultValue, Money.class);
    }

    @Override
    public Date getDate(String name) {
        return this.getDate(name, null);
    }

    @Override
    public Date getDate(String name, Date defaultValue) {
        return (Date)this.get(name, defaultValue, Date.class);
    }

    @Override
    public IMObjectReference getReference(String name) {
        return (IMObjectReference)this.get(name);
    }

    @Override
    public PropertyState resolve(String name) {
        Object value = this.get(name);
        return new PropertyState(name, value);
    }

    protected Object get(String name, Object defaultValue, Class type) {
        Object value = this.get(name);
        Object result = value != null ? this.convert(name, value, type) : defaultValue;
        return result;
    }

    protected Object convert(String name, Object value, Class type) {
        Object result;
        try {
            result = CONVERTER.convert(value, type);
        }
        catch (Throwable exception) {
            throw new PropertySetException(PropertySetException.ErrorCode.ConversionFailed, exception, name, value, type);
        }
        return result;
    }
}

