/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.query.criteria;

import java.util.Iterator;
import java.util.List;
import org.openvpms.component.query.TypedQuery;

public class TypedQueryIterator<T>
implements Iterator<T> {
    private final TypedQuery<T> query;
    private final int pageSize;
    private List<T> page;
    private int position = 0;
    private Iterator<T> iterator;

    public TypedQueryIterator(TypedQuery<T> query, int pageSize) {
        this(query, 0, pageSize);
    }

    public TypedQueryIterator(TypedQuery<T> query, int position, int pageSize) {
        this.position = position;
        this.query = query;
        this.pageSize = pageSize;
    }

    @Override
    public boolean hasNext() {
        return this.getIterator().hasNext();
    }

    @Override
    public T next() {
        return this.getIterator().next();
    }

    protected Iterator<T> getIterator() {
        if (!(this.page != null && this.iterator.hasNext() || this.page != null && this.page.size() != this.pageSize)) {
            this.query.setMaxResults(this.pageSize);
            this.query.setFirstResult(this.position);
            this.position += this.pageSize;
            this.page = this.query.getResultList();
            this.iterator = this.page.iterator();
        }
        return this.iterator;
    }
}

