/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.query;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.openvpms.component.system.common.query.ArchetypeQueryException;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;

public class ShortNameConstraint
extends BaseArchetypeConstraint {
    private static final long serialVersionUID = 1L;
    private String[] shortNames;

    public ShortNameConstraint(String shortName) {
        this(null, shortName);
    }

    public ShortNameConstraint(String alias, String shortName) {
        this(alias, shortName, false);
    }

    public ShortNameConstraint(String shortName, boolean activeOnly) {
        this(null, shortName, activeOnly);
    }

    public ShortNameConstraint(String shortName, BaseArchetypeConstraint.State state) {
        this(null, shortName, state);
    }

    public ShortNameConstraint(String alias, String shortName, boolean activeOnly) {
        this(alias, shortName, false, activeOnly);
    }

    public ShortNameConstraint(String alias, String shortName, BaseArchetypeConstraint.State state) {
        this(alias, shortName, false, state);
    }

    public ShortNameConstraint(String shortName, boolean primaryOnly, boolean activeOnly) {
        this(null, shortName, primaryOnly, activeOnly);
    }

    public ShortNameConstraint(String shortName, boolean primaryOnly, BaseArchetypeConstraint.State state) {
        this(null, shortName, primaryOnly, state);
    }

    public ShortNameConstraint(String alias, String shortName, boolean primaryOnly, boolean activeOnly) {
        super(alias, primaryOnly, activeOnly);
        if (StringUtils.isEmpty((CharSequence)shortName)) {
            throw new ArchetypeQueryException(ArchetypeQueryException.ErrorCode.NoShortNameSpecified);
        }
        this.shortNames = new String[]{shortName};
    }

    public ShortNameConstraint(String alias, String shortName, boolean primaryOnly, BaseArchetypeConstraint.State state) {
        super(alias, primaryOnly, state);
        if (StringUtils.isEmpty((CharSequence)shortName)) {
            throw new ArchetypeQueryException(ArchetypeQueryException.ErrorCode.NoShortNameSpecified);
        }
        this.shortNames = new String[]{shortName};
    }

    public ShortNameConstraint(List<String> shortNames, boolean primaryOnly, boolean activeOnly) {
        this(shortNames.toArray(new String[0]), primaryOnly, activeOnly);
    }

    public ShortNameConstraint(String[] shortNames, boolean primaryOnly, boolean activeOnly) {
        this(null, shortNames, primaryOnly, activeOnly);
    }

    public ShortNameConstraint(String[] shortNames, boolean primaryOnly, BaseArchetypeConstraint.State state) {
        this(null, shortNames, primaryOnly, state);
    }

    public ShortNameConstraint(String alias, List<String> shortNames, boolean primaryOnly, boolean activeOnly) {
        this(alias, shortNames.toArray(new String[0]), primaryOnly, activeOnly);
    }

    public ShortNameConstraint(String alias, String[] shortNames, boolean primaryOnly, boolean activeOnly) {
        super(alias, primaryOnly, activeOnly);
        if (shortNames == null || shortNames.length == 0) {
            throw new ArchetypeQueryException(ArchetypeQueryException.ErrorCode.MustSpecifyAtLeastOneShortName);
        }
        this.shortNames = shortNames;
    }

    public ShortNameConstraint(String alias, String[] shortNames, boolean primaryOnly, BaseArchetypeConstraint.State state) {
        super(alias, primaryOnly, state);
        if (shortNames == null || shortNames.length == 0) {
            throw new ArchetypeQueryException(ArchetypeQueryException.ErrorCode.MustSpecifyAtLeastOneShortName);
        }
        this.shortNames = shortNames;
    }

    public String[] getShortNames() {
        return this.shortNames;
    }

    public void setShortNames(String[] shortNames) {
        this.shortNames = shortNames;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ShortNameConstraint)) {
            return false;
        }
        ShortNameConstraint rhs = (ShortNameConstraint)obj;
        return new EqualsBuilder().appendSuper(super.equals(rhs)).append((Object[])this.shortNames, (Object[])rhs.shortNames).isEquals();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("shortNames", (Object[])this.shortNames).toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ShortNameConstraint copy = (ShortNameConstraint)super.clone();
        copy.shortNames = new String[this.shortNames.length];
        System.arraycopy(this.shortNames, 0, copy.shortNames, 0, this.shortNames.length);
        return copy;
    }
}

