/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.jxpath;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.jxpath.JXPathTypeConversionException;
import org.apache.commons.jxpath.NodeSet;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.util.BasicTypeConverter;
import org.openvpms.component.business.domain.im.datatypes.quantity.Money;
import org.openvpms.component.system.common.jxpath.MoneyConverter;
import org.openvpms.component.system.common.jxpath.UtilDateConverter;

public class OpenVPMSTypeConverter
extends BasicTypeConverter {
    private final MoneyConverter moneyConverter = new MoneyConverter();
    private final UtilDateConverter dateConverter = new UtilDateConverter();

    public OpenVPMSTypeConverter() {
        ConvertUtils.register((Converter)new MoneyConverter(), Money.class);
        ConvertUtils.register((Converter)new UtilDateConverter(), Date.class);
    }

    public Object convert(Object object, Class toType) {
        Converter converter;
        Object value;
        if (object == null) {
            if (toType.isPrimitive()) {
                return this.convertNullToPrimitive(toType);
            }
            return null;
        }
        if (toType == Object.class) {
            if (object instanceof NodeSet) {
                return this.convert(((NodeSet)object).getValues(), toType);
            }
            if (object instanceof Pointer) {
                return this.convert(((Pointer)object).getValue(), toType);
            }
            return object;
        }
        Class<?> fromType = object.getClass();
        if (fromType.equals(toType) || toType.isAssignableFrom(fromType)) {
            return object;
        }
        if (fromType.isArray()) {
            int length = Array.getLength(object);
            if (toType.isArray()) {
                Class<?> cType = toType.getComponentType();
                Object array = Array.newInstance(cType, length);
                for (int i = 0; i < length; ++i) {
                    Object value2 = Array.get(object, i);
                    Array.set(array, i, this.convert(value2, cType));
                }
                return array;
            }
            if (Collection.class.isAssignableFrom(toType)) {
                Collection collection = this.allocateCollection(toType);
                for (int i = 0; i < length; ++i) {
                    collection.add(Array.get(object, i));
                }
                return this.unmodifiableCollection(collection);
            }
            if (length > 0) {
                Object value3 = Array.get(object, 0);
                return this.convert(value3, toType);
            }
            return this.convert("", toType);
        }
        if (object instanceof Collection) {
            int length = ((Collection)object).size();
            if (toType.isArray()) {
                Class<?> cType = toType.getComponentType();
                Object array = Array.newInstance(cType, length);
                Iterator it = ((Collection)object).iterator();
                for (int i = 0; i < length; ++i) {
                    Object value4 = it.next();
                    Array.set(array, i, this.convert(value4, cType));
                }
                return array;
            }
            if (Collection.class.isAssignableFrom(toType)) {
                Collection collection = this.allocateCollection(toType);
                collection.addAll((Collection)object);
                return this.unmodifiableCollection(collection);
            }
            if (length > 0) {
                Object value5;
                if (object instanceof List) {
                    value5 = ((List)object).get(0);
                } else {
                    Iterator it = ((Collection)object).iterator();
                    value5 = it.next();
                }
                return this.convert(value5, toType);
            }
            return this.convert("", toType);
        }
        if (object instanceof NodeSet) {
            return this.convert(((NodeSet)object).getValues(), toType);
        }
        if (object instanceof Pointer) {
            return this.convert(((Pointer)object).getValue(), toType);
        }
        if (toType == String.class) {
            return object.toString();
        }
        if (object instanceof Boolean) {
            if (toType == Boolean.TYPE) {
                return object;
            }
            boolean value6 = (Boolean)object;
            return this.allocateNumber(toType, value6 ? 1.0 : 0.0);
        }
        if (object instanceof BigDecimal) {
            BigDecimal value7 = (BigDecimal)object;
            if (toType == Boolean.TYPE || toType == Boolean.class) {
                return value7.equals(BigDecimal.ZERO) ? Boolean.FALSE : Boolean.TRUE;
            }
            if (toType.isPrimitive() || Number.class.isAssignableFrom(toType)) {
                return this.allocateNumber(toType, value7);
            }
        } else if (object instanceof BigInteger) {
            BigInteger value8 = (BigInteger)object;
            if (toType == Boolean.TYPE || toType == Boolean.class) {
                return value8.equals(BigInteger.ZERO) ? Boolean.FALSE : Boolean.TRUE;
            }
            if (toType.isPrimitive() || Number.class.isAssignableFrom(toType)) {
                return this.allocateNumber(toType, value8);
            }
        } else if (object instanceof Number) {
            double value9 = ((Number)object).doubleValue();
            if (toType == Boolean.TYPE || toType == Boolean.class) {
                return value9 == 0.0 ? Boolean.FALSE : Boolean.TRUE;
            }
            if (toType.isPrimitive() || Number.class.isAssignableFrom(toType)) {
                return this.allocateNumber(toType, value9);
            }
        } else if (object instanceof Character) {
            if (toType == Character.TYPE) {
                return object;
            }
        } else if (object instanceof String && (value = this.convertStringToPrimitive(object, toType)) != null) {
            return value;
        }
        if ((converter = this.getConverter(toType)) != null) {
            return converter.convert(toType, object);
        }
        throw new JXPathTypeConversionException("Cannot convert " + object.getClass() + " to " + toType);
    }

    protected Number allocateNumber(Class type, double value) {
        if (type == Byte.class || type == Byte.TYPE) {
            return (byte)value;
        }
        if (type == Short.class || type == Short.TYPE) {
            return (short)value;
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return (int)value;
        }
        if (type == Long.class || type == Long.TYPE) {
            return (long)value;
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.valueOf((float)value);
        }
        if (type == Double.class || type == Double.TYPE) {
            return value;
        }
        if (type == BigDecimal.class) {
            return BigDecimal.valueOf(value);
        }
        if (type == BigInteger.class) {
            return BigInteger.valueOf((long)value);
        }
        if (type == Money.class) {
            return new Money(value);
        }
        return null;
    }

    protected Number allocateNumber(Class<?> type, BigDecimal value) {
        if (type == Byte.class || type == Byte.TYPE) {
            return value.byteValue();
        }
        if (type == Short.class || type == Short.TYPE) {
            return value.shortValue();
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return value.intValue();
        }
        if (type == Long.class || type == Long.TYPE) {
            return value.longValue();
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.valueOf(value.floatValue());
        }
        if (type == Double.class || type == Double.TYPE) {
            return value.doubleValue();
        }
        if (type == BigDecimal.class) {
            return value;
        }
        if (type == BigInteger.class) {
            return BigInteger.valueOf(value.longValue());
        }
        if (type == Money.class) {
            return new Money(value);
        }
        return null;
    }

    protected Number allocateNumber(Class<?> type, BigInteger value) {
        if (type == Byte.class || type == Byte.TYPE) {
            return value.byteValue();
        }
        if (type == Short.class || type == Short.TYPE) {
            return value.shortValue();
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return value.intValue();
        }
        if (type == Long.class || type == Long.TYPE) {
            return value.longValue();
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.valueOf(value.floatValue());
        }
        if (type == Double.class || type == Double.TYPE) {
            return value.doubleValue();
        }
        if (type == BigDecimal.class) {
            return new BigDecimal(value);
        }
        if (type == BigInteger.class) {
            return value;
        }
        if (type == Money.class) {
            return new Money(value);
        }
        return null;
    }

    private Converter getConverter(Class<?> toType) {
        if (Money.class == toType) {
            return this.moneyConverter;
        }
        if (Date.class == toType) {
            return this.dateConverter;
        }
        return ConvertUtils.lookup(toType);
    }
}

