/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.ruleengine;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.openvpms.component.business.service.ruleengine.RuleEngineException;

public class RuleDescriptor {
    private SourceType source = SourceType.SYSTEM;
    private String path;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getSourceAsString() {
        return this.source.toString();
    }

    public void setSourceAsString(String source) {
        if (source.toLowerCase().equals(SourceType.SYSTEM.toString())) {
            this.source = SourceType.SYSTEM;
        } else if (source.toLowerCase().equals(SourceType.CLASSPATH.toString())) {
            this.source = SourceType.CLASSPATH;
        } else {
            throw new RuleEngineException(RuleEngineException.ErrorCode.InvalidSourceSpecified, source);
        }
    }

    public SourceType getSource() {
        return this.source;
    }

    public void setSource(SourceType source) {
        this.source = source;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("source", (Object)this.source).append("path", (Object)this.path).toString();
    }

    public static enum SourceType {
        CLASSPATH,
        SYSTEM;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

