/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.lookup;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.ehcache.Cache;
import org.openvpms.component.business.dao.im.common.IMObjectDAO;
import org.openvpms.component.business.service.archetype.AbstractArchetypeServiceListener;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.IArchetypeServiceListener;
import org.openvpms.component.business.service.cache.EhCacheable;
import org.openvpms.component.business.service.cache.EhcacheManager;
import org.openvpms.component.business.service.lookup.AbstractLookupService;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.lookup.LookupRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.springframework.beans.factory.DisposableBean;

public class CachingLookupService
extends AbstractLookupService
implements DisposableBean,
EhCacheable {
    private final Cache<Key, Object> cache;
    private final IArchetypeServiceListener listener;
    private static final String ARCHETYPES = "lookup.*";

    public CachingLookupService(IArchetypeService service, IMObjectDAO dao, EhcacheManager cacheManager) {
        super(service, dao);
        this.cache = cacheManager.create("lookupCache", Key.class, Object.class);
        this.listener = new AbstractArchetypeServiceListener(){

            @Override
            public void saved(IMObject object) {
                CachingLookupService.this.addLookup((Lookup)object, true);
            }

            @Override
            public void removed(IMObject object) {
                CachingLookupService.this.removeLookup((Lookup)object, true);
            }
        };
        service.addListener(ARCHETYPES, this.listener);
    }

    public void destroy() {
        this.getService().removeListener(ARCHETYPES, this.listener);
        this.cache.clear();
    }

    public void setCached(String ... shortNames) {
        for (String wildcard : shortNames) {
            for (String shortName : this.getArchetypes(wildcard)) {
                this.getLookups(shortName);
            }
        }
    }

    @Override
    public Lookup getLookup(String shortName, String code, boolean activeOnly) {
        Lookup result = (Lookup)this.cache.get((Object)new Key(shortName, code));
        if (result != null) {
            if (activeOnly && !result.isActive()) {
                result = null;
            }
        } else {
            result = super.getLookup(shortName, code, activeOnly);
            if (result != null) {
                this.addLookup(result, false);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Lookup> getLookups(String shortName) {
        ArrayList<Lookup> result = new ArrayList<Lookup>();
        for (String archetype : this.getArchetypes(shortName)) {
            Key key = new Key(archetype);
            HashSet<Reference> references = (HashSet<Reference>)this.cache.get((Object)key);
            if (references != null) {
                HashSet<Reference> hashSet = references;
                synchronized (hashSet) {
                    for (Reference reference : references) {
                        Lookup lookup = this.getLookup(reference);
                        if (lookup == null || !lookup.isActive()) continue;
                        result.add(lookup);
                    }
                    continue;
                }
            }
            Collection<Lookup> matches = this.query(archetype);
            result.addAll(matches);
            references = new HashSet<Reference>();
            for (Lookup lookup : matches) {
                references.add(lookup.getObjectReference());
                this.addLookup(lookup, false);
            }
            this.cache.put((Object)key, references);
        }
        return result;
    }

    @Override
    public Lookup getDefaultLookup(String shortName) {
        for (Lookup lookup : this.getLookups(shortName)) {
            if (!lookup.isDefaultLookup()) continue;
            return lookup;
        }
        return null;
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public Cache<?, ?> getCache() {
        return this.cache;
    }

    @Override
    protected Lookup getLookup(Reference reference) {
        Lookup result = null;
        if (reference != null && (result = this.getCached(new Key(reference))) == null && (result = super.getLookup(reference)) != null) {
            this.addLookup(result, false);
        }
        return result;
    }

    private List<String> getArchetypes(String archetype) {
        return this.getService().getArchetypes(archetype, false);
    }

    private Lookup getCached(Key key) {
        return (Lookup)this.cache.get((Object)key);
    }

    private void addLookup(Lookup lookup, boolean evictRelated) {
        String archetype = lookup.getArchetype();
        Reference reference = lookup.getObjectReference();
        Lookup original = null;
        Key refKey = new Key(reference);
        Key codeKey = new Key(archetype, lookup.getCode());
        if (evictRelated && (original = this.getCached(refKey)) == null) {
            original = this.getCached(codeKey);
        }
        this.cache.put((Object)refKey, (Object)lookup);
        this.cache.put((Object)codeKey, (Object)lookup);
        if (lookup.isActive()) {
            this.addToCollection(reference);
        } else {
            this.removeFromCollection(reference);
        }
        if (original != null) {
            this.evictRelated(original, reference);
        }
        if (evictRelated) {
            this.evictRelated(lookup, reference);
        }
    }

    private void evictRelated(Lookup lookup, Reference reference) {
        for (LookupRelationship relationship : lookup.getLookupRelationships()) {
            Reference source = relationship.getSource();
            Lookup cached = null;
            if (source != null && !reference.equals((Object)source)) {
                cached = this.getCached(new Key(source));
            } else {
                Reference target = relationship.getTarget();
                if (target != null && !reference.equals((Object)target)) {
                    cached = this.getCached(new Key(target));
                }
            }
            if (cached == null) continue;
            this.removeLookup(cached, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToCollection(Reference reference) {
        Set lookups = (Set)this.cache.get((Object)new Key(reference.getArchetype()));
        if (lookups != null) {
            Set set = lookups;
            synchronized (set) {
                lookups.add(reference);
            }
        }
    }

    private void removeLookup(Lookup lookup, boolean removeFromCollection) {
        Reference reference = lookup.getObjectReference();
        Key refKey = new Key(reference);
        Key codeKey = new Key(lookup.getArchetype(), lookup.getCode());
        this.cache.remove((Object)refKey);
        this.cache.remove((Object)codeKey);
        this.evictRelated(lookup, reference);
        if (removeFromCollection) {
            this.removeFromCollection(reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromCollection(Reference reference) {
        Set lookups = (Set)this.cache.get((Object)new Key(reference.getArchetype()));
        if (lookups != null) {
            Set set = lookups;
            synchronized (set) {
                lookups.remove(reference);
            }
        }
    }

    private static class Key
    implements Serializable {
        private final int hashCode;
        private String key;
        private Reference ref;
        private boolean isShortName = false;

        public Key(String shortName) {
            this.key = shortName;
            this.isShortName = true;
            this.hashCode = this.key.hashCode();
        }

        public Key(String shortName, String code) {
            this.key = shortName + "-" + code;
            this.hashCode = this.key.hashCode();
        }

        public Key(Reference ref) {
            this.ref = ref;
            this.hashCode = ref.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            return Objects.equals(this.key, other.key) || Objects.equals(this.ref, other.ref);
        }

        public boolean matches(String shortName) {
            return this.isShortName && this.key.equals(shortName);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

