/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.helper.sort;

import java.sql.Timestamp;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.ComparatorUtils;
import org.apache.commons.collections4.FunctorException;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.comparators.ComparatorChain;
import org.apache.commons.collections4.comparators.ReverseComparator;
import org.apache.commons.collections4.comparators.TransformingComparator;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.DescriptorException;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.domain.im.common.Participation;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.NodeSelectConstraint;
import org.openvpms.component.system.common.query.ObjectRefConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IMObjectSorter {
    private final IArchetypeService service;
    private final LookupService lookups;
    private static final Comparator<IMObject> ID_COMPARATOR = new IdComparator<IMObject>();
    private static final Comparator<IMObject> NAME_COMPARATOR = new NameComparator<IMObject>();
    private static final Logger log = LoggerFactory.getLogger(IMObjectSorter.class);

    public IMObjectSorter(IArchetypeService service, LookupService lookups) {
        this.service = service;
        this.lookups = lookups;
    }

    public <T extends IMObject> List<T> sort(List<T> list, String name) {
        return this.sort(list, name, true);
    }

    public <T extends IMObject> List<T> sort(List<T> list, String name, boolean ascending) {
        Comparator<T> comparator = this.getComparator(name);
        this.sort(list, ascending, comparator);
        return list;
    }

    public <T extends IMObject> List<T> sort(List<T> list, boolean ascending, String ... names) {
        if (names.length >= 1) {
            ComparatorChain chain = new ComparatorChain();
            for (String name : names) {
                chain.addComparator(this.getComparator(name));
            }
            this.sort(list, ascending, (Comparator<T>)chain);
        }
        return list;
    }

    public static <T extends IMObject> Comparator<T> getIdComparator() {
        return ID_COMPARATOR;
    }

    public static <T extends IMObject> Comparator<T> getNameComparator() {
        return NAME_COMPARATOR;
    }

    private <T extends IMObject> Comparator<T> getComparator(String name) {
        Object comparator = "id".equals(name) ? IMObjectSorter.getIdComparator() : ("name".equals(name) ? IMObjectSorter.getNameComparator() : new TransformingComparator(new NodeTransformer(name), ComparatorUtils.nullLowComparator(null)));
        return comparator;
    }

    private <T extends IMObject> void sort(List<T> list, boolean ascending, Comparator<T> comparator) {
        if (!ascending) {
            comparator = new ReverseComparator(comparator);
        }
        list.sort((Comparator<T>)comparator);
    }

    private static class NameComparator<T extends IMObject>
    implements Comparator<T> {
        private final Comparator<String> comparator = ComparatorUtils.nullLowComparator((Comparator)ComparatorUtils.naturalComparator());

        private NameComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            return this.comparator.compare(o1.getName(), o2.getName());
        }
    }

    private static class IdComparator<T extends IMObject>
    implements Comparator<T> {
        private IdComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            return Long.compare(o1.getId(), o2.getId());
        }
    }

    private class NodeTransformer<T extends IMObject>
    implements Transformer<T, Object> {
        private final String node;
        private ArchetypeDescriptor archetype;
        private NodeDescriptor descriptor;

        public NodeTransformer(String node) {
            this.node = node;
        }

        public Object transform(T input) {
            NodeDescriptor descriptor;
            Object result = null;
            if (input != null && (descriptor = this.getDescriptor((IMObject)input)) != null) {
                try {
                    if (descriptor.isCollection()) {
                        List<IMObject> objects = descriptor.getValues((IMObject)input);
                        if (objects.size() == 1) {
                            result = objects.get(0);
                        }
                    } else {
                        result = descriptor.isLookup() ? IMObjectSorter.this.lookups.getName(input, this.node) : descriptor.getValue((IMObject)input);
                    }
                    if (result instanceof Participation) {
                        Participation p = (Participation)result;
                        result = this.getName(p.getEntity());
                    } else if (!(result instanceof Comparable)) {
                        result = null;
                    } else if (result instanceof Timestamp) {
                        result = new Date(((Timestamp)result).getTime());
                    }
                }
                catch (DescriptorException exception) {
                    log.error(exception.getMessage(), (Throwable)((Object)exception));
                }
            }
            return result;
        }

        private NodeDescriptor getDescriptor(IMObject object) {
            if (this.archetype == null || !this.archetype.getArchetypeType().equals(object.getArchetype())) {
                this.archetype = DescriptorHelper.getArchetypeDescriptor(object, (ArchetypeService)IMObjectSorter.this.service);
                if (this.archetype == null) {
                    throw new FunctorException("No archetype descriptor found for object, id=" + object.getId() + ", archetype=" + object.getArchetype());
                }
                this.descriptor = this.archetype.getNodeDescriptor(this.node);
            }
            return this.descriptor;
        }

        private String getName(Reference reference) {
            if (reference != null) {
                ArchetypeQuery query = new ArchetypeQuery(new ObjectRefConstraint("o", reference));
                query.add(new NodeSelectConstraint("o.name"));
                query.setMaxResults(1);
                ObjectSetQueryIterator iter = new ObjectSetQueryIterator(IMObjectSorter.this.service, query);
                if (iter.hasNext()) {
                    ObjectSet set = (ObjectSet)iter.next();
                    return set.getString("o.name");
                }
            }
            return null;
        }
    }
}

