/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.helper;

import java.util.List;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.service.archetype.helper.BasePropertyResolver;
import org.openvpms.component.business.service.archetype.helper.PropertyResolverException;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.util.PropertyState;

public class NodeResolver
extends BasePropertyResolver {
    private final IMObject root;
    private final ArchetypeDescriptor archetype;

    public NodeResolver(IMObject root, ArchetypeService service) {
        this(root, service, null);
    }

    public NodeResolver(IMObject root, ArchetypeService service, LookupService lookups) {
        super(service, lookups);
        this.root = root;
        this.archetype = (ArchetypeDescriptor)service.getArchetypeDescriptor(root.getArchetype());
    }

    public ArchetypeDescriptor getArchetype() {
        return this.archetype;
    }

    @Override
    public Object getObject(String name) {
        return this.resolve(name).getValue();
    }

    @Override
    public List<Object> getObjects(String name) {
        return this.getObjects(this.root, name);
    }

    @Override
    public PropertyState resolve(String name) {
        int index;
        IMObject object = this.root;
        ArchetypeDescriptor currentArchetype = this.archetype;
        while ((index = name.indexOf(".")) != -1) {
            String nodeName = name.substring(0, index);
            NodeDescriptor node = this.getNode(currentArchetype, nodeName);
            if (node == null) {
                throw new PropertyResolverException(PropertyResolverException.ErrorCode.InvalidNode, name, currentArchetype);
            }
            Object value = this.getValue(object, node, true);
            if (value == null) {
                object = null;
                break;
            }
            if (!(value instanceof IMObject)) {
                throw new PropertyResolverException(PropertyResolverException.ErrorCode.InvalidObject, name);
            }
            object = (IMObject)value;
            currentArchetype = this.getArchetype(object);
            name = name.substring(index + 1);
        }
        PropertyState state = object != null ? this.getLeafPropertyState(object, name, currentArchetype) : new PropertyState();
        return state;
    }
}

